/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes4;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class Deed
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_ADDMANAGER = "addManager";
    public static final String FUNC_ADDMINTER = "addMinter";
    public static final String FUNC_ADDSTRATEGY = "addStrategy";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_BALANCEOFBATCH = "balanceOfBatch";
    public static final String FUNC_CARDTYPE = "cardType";
    public static final String FUNC_CITYINDEX = "cityIndex";
    public static final String FUNC_CONTRACTURI = "contractURI";
    public static final String FUNC_CREATE = "create";
    public static final String FUNC_CREATORS = "creators";
    public static final String FUNC_ENDUSINGNFT = "endUsingNFT";
    public static final String FUNC_GETSTRATEGYUSECOUNT = "getStrategyUseCount";
    public static final String FUNC_GETTOTALUSECOUNT = "getTotalUseCount";
    public static final String FUNC_ISAPPROVEDFORALL = "isApprovedForAll";
    public static final String FUNC_ISMANAGER = "isManager";
    public static final String FUNC_ISMINTER = "isMinter";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_ISSTRATEGY = "isStrategy";
    public static final String FUNC_MAXSUPPLY = "maxSupply";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_NFTSOF = "nftsOf";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_PROXYREGISTRYADDRESS = "proxyRegistryAddress";
    public static final String FUNC_REMOVEMANAGER = "removeManager";
    public static final String FUNC_REMOVESTRATEGY = "removeStrategy";
    public static final String FUNC_RENOUNCEMINTER = "renounceMinter";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_SAFEBATCHTRANSFERFROM = "safeBatchTransferFrom";
    public static final String FUNC_SAFETRANSFERFROM = "safeTransferFrom";
    public static final String FUNC_SETAPPROVALFORALL = "setApprovalForAll";
    public static final String FUNC_SETBASEMETADATAURI = "setBaseMetadataURI";
    public static final String FUNC_STARTUSINGNFT = "startUsingNFT";
    public static final String FUNC_SUPPORTSINTERFACE = "supportsInterface";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_TOKENCITYINDEX = "tokenCityIndex";
    public static final String FUNC_TOKENMAXSUPPLY = "tokenMaxSupply";
    public static final String FUNC_TOKENSUPPLY = "tokenSupply";
    public static final String FUNC_TOKENTYPE = "tokenType";
    public static final String FUNC_totalSupply = "totalSupply";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_URI = "uri";
    public static final Event APPROVALFORALL_EVENT = new Event("ApprovalForAll", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Bool>(){}));
    public static final Event ENDEDUSINGNFT_EVENT = new Event("EndedUsingNFT", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}, new TypeReference<Address>(true){}));
    public static final Event MANAGERADDED_EVENT = new Event("ManagerAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event MANAGERREMOVED_EVENT = new Event("ManagerRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event MINTERADDED_EVENT = new Event("MinterAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event MINTERREMOVED_EVENT = new Event("MinterRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event STARTEDUSINGNFT_EVENT = new Event("StartedUsingNFT", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}, new TypeReference<Address>(true){}));
    public static final Event STRATEGYADDED_EVENT = new Event("StrategyAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event STRATEGYREMOVED_EVENT = new Event("StrategyRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event TRANSFERBATCH_EVENT = new Event("TransferBatch", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<DynamicArray<Uint256>>(){}, new TypeReference<DynamicArray<Uint256>>(){}));
    public static final Event TRANSFERSINGLE_EVENT = new Event("TransferSingle", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
    public static final Event URI_EVENT = new Event("URI", Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Uint256>(true){}));

    @Deprecated
    protected Deed(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected Deed(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected Deed(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected Deed(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<ApprovalForAllEventResponse> getApprovalForAllEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVALFORALL_EVENT, transactionReceipt);
        ArrayList<ApprovalForAllEventResponse> responses = new ArrayList<ApprovalForAllEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._approved = (Boolean)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovalForAllEventResponse>(){

            public ApprovalForAllEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(APPROVALFORALL_EVENT, log);
                ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._approved = (Boolean)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVALFORALL_EVENT));
        return this.approvalForAllEventFlowable(filter);
    }

    public List<EndedUsingNFTEventResponse> getEndedUsingNFTEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(ENDEDUSINGNFT_EVENT, transactionReceipt);
        ArrayList<EndedUsingNFTEventResponse> responses = new ArrayList<EndedUsingNFTEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            EndedUsingNFTEventResponse typedResponse = new EndedUsingNFTEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.strategy = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<EndedUsingNFTEventResponse> endedUsingNFTEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, EndedUsingNFTEventResponse>(){

            public EndedUsingNFTEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(ENDEDUSINGNFT_EVENT, log);
                EndedUsingNFTEventResponse typedResponse = new EndedUsingNFTEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.strategy = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<EndedUsingNFTEventResponse> endedUsingNFTEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ENDEDUSINGNFT_EVENT));
        return this.endedUsingNFTEventFlowable(filter);
    }

    public List<ManagerAddedEventResponse> getManagerAddedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(MANAGERADDED_EVENT, transactionReceipt);
        ArrayList<ManagerAddedEventResponse> responses = new ArrayList<ManagerAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ManagerAddedEventResponse>(){

            public ManagerAddedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(MANAGERADDED_EVENT, log);
                ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MANAGERADDED_EVENT));
        return this.managerAddedEventFlowable(filter);
    }

    public List<ManagerRemovedEventResponse> getManagerRemovedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(MANAGERREMOVED_EVENT, transactionReceipt);
        ArrayList<ManagerRemovedEventResponse> responses = new ArrayList<ManagerRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ManagerRemovedEventResponse>(){

            public ManagerRemovedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(MANAGERREMOVED_EVENT, log);
                ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MANAGERREMOVED_EVENT));
        return this.managerRemovedEventFlowable(filter);
    }

    public List<MinterAddedEventResponse> getMinterAddedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(MINTERADDED_EVENT, transactionReceipt);
        ArrayList<MinterAddedEventResponse> responses = new ArrayList<MinterAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MinterAddedEventResponse typedResponse = new MinterAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MinterAddedEventResponse> minterAddedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, MinterAddedEventResponse>(){

            public MinterAddedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(MINTERADDED_EVENT, log);
                MinterAddedEventResponse typedResponse = new MinterAddedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MinterAddedEventResponse> minterAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MINTERADDED_EVENT));
        return this.minterAddedEventFlowable(filter);
    }

    public List<MinterRemovedEventResponse> getMinterRemovedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(MINTERREMOVED_EVENT, transactionReceipt);
        ArrayList<MinterRemovedEventResponse> responses = new ArrayList<MinterRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MinterRemovedEventResponse typedResponse = new MinterRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MinterRemovedEventResponse> minterRemovedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, MinterRemovedEventResponse>(){

            public MinterRemovedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(MINTERREMOVED_EVENT, log);
                MinterRemovedEventResponse typedResponse = new MinterRemovedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MinterRemovedEventResponse> minterRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MINTERREMOVED_EVENT));
        return this.minterRemovedEventFlowable(filter);
    }

    public List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, OwnershipTransferredEventResponse>(){

            public OwnershipTransferredEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, log);
                OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
                typedResponse.log = log;
                typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public List<StartedUsingNFTEventResponse> getStartedUsingNFTEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(STARTEDUSINGNFT_EVENT, transactionReceipt);
        ArrayList<StartedUsingNFTEventResponse> responses = new ArrayList<StartedUsingNFTEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            StartedUsingNFTEventResponse typedResponse = new StartedUsingNFTEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.strategy = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<StartedUsingNFTEventResponse> startedUsingNFTEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, StartedUsingNFTEventResponse>(){

            public StartedUsingNFTEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(STARTEDUSINGNFT_EVENT, log);
                StartedUsingNFTEventResponse typedResponse = new StartedUsingNFTEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.id = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.strategy = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<StartedUsingNFTEventResponse> startedUsingNFTEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)STARTEDUSINGNFT_EVENT));
        return this.startedUsingNFTEventFlowable(filter);
    }

    public List<StrategyAddedEventResponse> getStrategyAddedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(STRATEGYADDED_EVENT, transactionReceipt);
        ArrayList<StrategyAddedEventResponse> responses = new ArrayList<StrategyAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            StrategyAddedEventResponse typedResponse = new StrategyAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<StrategyAddedEventResponse> strategyAddedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, StrategyAddedEventResponse>(){

            public StrategyAddedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(STRATEGYADDED_EVENT, log);
                StrategyAddedEventResponse typedResponse = new StrategyAddedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<StrategyAddedEventResponse> strategyAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)STRATEGYADDED_EVENT));
        return this.strategyAddedEventFlowable(filter);
    }

    public List<StrategyRemovedEventResponse> getStrategyRemovedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(STRATEGYREMOVED_EVENT, transactionReceipt);
        ArrayList<StrategyRemovedEventResponse> responses = new ArrayList<StrategyRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            StrategyRemovedEventResponse typedResponse = new StrategyRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<StrategyRemovedEventResponse> strategyRemovedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, StrategyRemovedEventResponse>(){

            public StrategyRemovedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(STRATEGYREMOVED_EVENT, log);
                StrategyRemovedEventResponse typedResponse = new StrategyRemovedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<StrategyRemovedEventResponse> strategyRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)STRATEGYREMOVED_EVENT));
        return this.strategyRemovedEventFlowable(filter);
    }

    public List<TransferBatchEventResponse> getTransferBatchEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFERBATCH_EVENT, transactionReceipt);
        ArrayList<TransferBatchEventResponse> responses = new ArrayList<TransferBatchEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferBatchEventResponse typedResponse = new TransferBatchEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
            typedResponse._ids = (List)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse._amounts = (List)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferBatchEventResponse> transferBatchEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferBatchEventResponse>(){

            public TransferBatchEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(TRANSFERBATCH_EVENT, log);
                TransferBatchEventResponse typedResponse = new TransferBatchEventResponse();
                typedResponse.log = log;
                typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
                typedResponse._ids = (List)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse._amounts = (List)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferBatchEventResponse> transferBatchEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFERBATCH_EVENT));
        return this.transferBatchEventFlowable(filter);
    }

    public List<TransferSingleEventResponse> getTransferSingleEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFERSINGLE_EVENT, transactionReceipt);
        ArrayList<TransferSingleEventResponse> responses = new ArrayList<TransferSingleEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
            typedResponse._id = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse._amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferSingleEventResponse>(){

            public TransferSingleEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(TRANSFERSINGLE_EVENT, log);
                TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
                typedResponse.log = log;
                typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
                typedResponse._id = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse._amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFERSINGLE_EVENT));
        return this.transferSingleEventFlowable(filter);
    }

    public List<URIEventResponse> getURIEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(URI_EVENT, transactionReceipt);
        ArrayList<URIEventResponse> responses = new ArrayList<URIEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            URIEventResponse typedResponse = new URIEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._uri = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<URIEventResponse> uRIEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, URIEventResponse>(){

            public URIEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = Deed.this.extractEventParametersWithLog(URI_EVENT, log);
                URIEventResponse typedResponse = new URIEventResponse();
                typedResponse.log = log;
                typedResponse._id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._uri = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<URIEventResponse> uRIEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)URI_EVENT));
        return this.uRIEventFlowable(filter);
    }

    public RemoteFunctionCall<TransactionReceipt> addManager(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ADDMANAGER, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> addMinter(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ADDMINTER, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> addStrategy(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ADDSTRATEGY, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String _owner, BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, Arrays.asList(new Address(160, _owner), new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<List> balanceOfBatch(List<String> _owners, List<BigInteger> _ids) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOFBATCH, Arrays.asList(new DynamicArray(Address.class, Utils.typeMap(_owners, Address.class)), new DynamicArray(Uint256.class, Utils.typeMap(_ids, Uint256.class))), Arrays.asList(new TypeReference<DynamicArray<Uint256>>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = (List)Deed.this.executeCallSingleValueReturn(function, List.class);
                return Deed.convertToNative((List)result);
            }
        });
    }

    public RemoteFunctionCall<BigInteger> cardType(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CARDTYPE, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> cityIndex(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CITYINDEX, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> contractURI() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CONTRACTURI, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> create(String _initialOwner, BigInteger _initialSupply, BigInteger _maxSupply, BigInteger _cityIndex, BigInteger _type, byte[] _data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CREATE, Arrays.asList(new Address(160, _initialOwner), new Uint256(_initialSupply), new Uint256(_maxSupply), new Uint8(_cityIndex), new Uint8(_type), new DynamicBytes(_data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> creators(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CREATORS, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> endUsingNFT(String _account, BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ENDUSINGNFT, Arrays.asList(new Address(160, _account), new Uint256(_id)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> getStrategyUseCount(String _account, BigInteger _id, String _strategy) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETSTRATEGYUSECOUNT, Arrays.asList(new Address(160, _account), new Uint256(_id), new Address(160, _strategy)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> getTotalUseCount(String _account, BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETTOTALUSECOUNT, Arrays.asList(new Address(160, _account), new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> isApprovedForAll(String _owner, String _operator) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISAPPROVEDFORALL, Arrays.asList(new Address(160, _owner), new Address(160, _operator)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isManager(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISMANAGER, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isMinter(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISMINTER, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isStrategy(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISSTRATEGY, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> maxSupply(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MAXSUPPLY, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> name() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<List> nftsOf(String _account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NFTSOF, Arrays.asList(new Address(160, _account)), Arrays.asList(new TypeReference<DynamicArray<Uint256>>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = (List)Deed.this.executeCallSingleValueReturn(function, List.class);
                return Deed.convertToNative((List)result);
            }
        });
    }

    public RemoteFunctionCall<String> owner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> proxyRegistryAddress() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PROXYREGISTRYADDRESS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> removeManager(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REMOVEMANAGER, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> removeStrategy(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REMOVESTRATEGY, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceMinter() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_RENOUNCEMINTER, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> safeBatchTransferFrom(String _from, String _to, List<BigInteger> _ids, List<BigInteger> _amounts, byte[] _data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SAFEBATCHTRANSFERFROM, Arrays.asList(new Address(160, _from), new Address(160, _to), new DynamicArray(Uint256.class, Utils.typeMap(_ids, Uint256.class)), new DynamicArray(Uint256.class, Utils.typeMap(_amounts, Uint256.class)), new DynamicBytes(_data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> safeTransferFrom(String _from, String _to, BigInteger _id, BigInteger _amount, byte[] _data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SAFETRANSFERFROM, Arrays.asList(new Address(160, _from), new Address(160, _to), new Uint256(_id), new Uint256(_amount), new DynamicBytes(_data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setApprovalForAll(String _operator, Boolean _approved) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETAPPROVALFORALL, Arrays.asList(new Address(160, _operator), new Bool(_approved)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setBaseMetadataURI(String _newBaseMetadataURI) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETBASEMETADATAURI, Arrays.asList(new Utf8String(_newBaseMetadataURI)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> startUsingNFT(String _account, BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_STARTUSINGNFT, Arrays.asList(new Address(160, _account), new Uint256(_id)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> supportsInterface(byte[] _interfaceID) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SUPPORTSINTERFACE, Arrays.asList(new Bytes4(_interfaceID)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> symbol() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> tokenCityIndex(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENCITYINDEX, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> tokenMaxSupply(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENMAXSUPPLY, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> tokenSupply(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENSUPPLY, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> tokenType(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENTYPE, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_totalSupply, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_totalSupply, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> uri(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_URI, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    @Deprecated
    public static Deed load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new Deed(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static Deed load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new Deed(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static Deed load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new Deed(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static Deed load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new Deed(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<Deed> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _proxyRegistryAddress, String _baseMetadataURI) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _proxyRegistryAddress), new Utf8String(_baseMetadataURI)));
        return Deed.deployRemoteCall(Deed.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    public static RemoteCall<Deed> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _proxyRegistryAddress, String _baseMetadataURI) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _proxyRegistryAddress), new Utf8String(_baseMetadataURI)));
        return Deed.deployRemoteCall(Deed.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<Deed> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _proxyRegistryAddress, String _baseMetadataURI) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _proxyRegistryAddress), new Utf8String(_baseMetadataURI)));
        return Deed.deployRemoteCall(Deed.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<Deed> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _proxyRegistryAddress, String _baseMetadataURI) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _proxyRegistryAddress), new Utf8String(_baseMetadataURI)));
        return Deed.deployRemoteCall(Deed.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    public static class URIEventResponse
    extends BaseEventResponse {
        public BigInteger _id;
        public String _uri;
    }

    public static class TransferSingleEventResponse
    extends BaseEventResponse {
        public String _operator;
        public String _from;
        public String _to;
        public BigInteger _id;
        public BigInteger _amount;
    }

    public static class TransferBatchEventResponse
    extends BaseEventResponse {
        public String _operator;
        public String _from;
        public String _to;
        public List<BigInteger> _ids;
        public List<BigInteger> _amounts;
    }

    public static class StrategyRemovedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class StrategyAddedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class StartedUsingNFTEventResponse
    extends BaseEventResponse {
        public String account;
        public BigInteger id;
        public String strategy;
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class MinterRemovedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class MinterAddedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class ManagerRemovedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class ManagerAddedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class EndedUsingNFTEventResponse
    extends BaseEventResponse {
        public String account;
        public BigInteger id;
        public String strategy;
    }

    public static class ApprovalForAllEventResponse
    extends BaseEventResponse {
        public String _owner;
        public String _operator;
        public Boolean _approved;
    }
}

