package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 4.9.4.
 */
@SuppressWarnings("rawtypes")
public class DeedTenantProvisioning extends Contract {
    public static final String BINARY = "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";

    public static final String FUNC_ADDMANAGER = "addManager";

    public static final String FUNC_DEED = "deed";

    public static final String FUNC_DELEGATEES = "delegatees";

    public static final String FUNC_GETDELEGATEE = "getDelegatee";

    public static final String FUNC_INITIALIZE = "initialize";

    public static final String FUNC_ISMANAGER = "isManager";

    public static final String FUNC_ISOWNER = "isOwner";

    public static final String FUNC_ISPROVISIONINGMANAGER = "isProvisioningManager";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_PROXIABLEUUID = "proxiableUUID";

    public static final String FUNC_REMOVEDELEGATEE = "removeDelegatee";

    public static final String FUNC_REMOVEMANAGER = "removeManager";

    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";

    public static final String FUNC_SETDELEGATEE = "setDelegatee";

    public static final String FUNC_STARTTENANT = "startTenant";

    public static final String FUNC_STOPTENANT = "stopTenant";

    public static final String FUNC_TENANTSTATUS = "tenantStatus";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final String FUNC_UPGRADETO = "upgradeTo";

    public static final String FUNC_UPGRADETOANDCALL = "upgradeToAndCall";

    public static final Event ADMINCHANGED_EVENT = new Event("AdminChanged", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Address>() {}));
    ;

    public static final Event BEACONUPGRADED_EVENT = new Event("BeaconUpgraded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event DELEGATEEADDED_EVENT = new Event("DelegateeAdded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Address>(true) {}, new TypeReference<Bool>() {}));
    ;

    public static final Event DELEGATEEREMOVED_EVENT = new Event("DelegateeRemoved", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Address>(true) {}, new TypeReference<Bool>() {}));
    ;

    public static final Event INITIALIZED_EVENT = new Event("Initialized", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
    ;

    public static final Event MANAGERADDED_EVENT = new Event("ManagerAdded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event MANAGERREMOVED_EVENT = new Event("ManagerRemoved", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}));
    ;

    public static final Event TENANTSTARTED_EVENT = new Event("TenantStarted", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>(true) {}));
    ;

    public static final Event TENANTSTOPPED_EVENT = new Event("TenantStopped", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>(true) {}));
    ;

    public static final Event UPGRADED_EVENT = new Event("Upgraded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    @Deprecated
    protected DeedTenantProvisioning(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected DeedTenantProvisioning(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected DeedTenantProvisioning(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected DeedTenantProvisioning(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<AdminChangedEventResponse> getAdminChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(ADMINCHANGED_EVENT, transactionReceipt);
        ArrayList<AdminChangedEventResponse> responses = new ArrayList<AdminChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousAdmin = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.newAdmin = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, AdminChangedEventResponse>() {
            @Override
            public AdminChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(ADMINCHANGED_EVENT, log);
                AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
                typedResponse.log = log;
                typedResponse.previousAdmin = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.newAdmin = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(ADMINCHANGED_EVENT));
        return adminChangedEventFlowable(filter);
    }

    public static List<BeaconUpgradedEventResponse> getBeaconUpgradedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(BEACONUPGRADED_EVENT, transactionReceipt);
        ArrayList<BeaconUpgradedEventResponse> responses = new ArrayList<BeaconUpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.beacon = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, BeaconUpgradedEventResponse>() {
            @Override
            public BeaconUpgradedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(BEACONUPGRADED_EVENT, log);
                BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
                typedResponse.log = log;
                typedResponse.beacon = (String) eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(BEACONUPGRADED_EVENT));
        return beaconUpgradedEventFlowable(filter);
    }

    public static List<DelegateeAddedEventResponse> getDelegateeAddedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(DELEGATEEADDED_EVENT, transactionReceipt);
        ArrayList<DelegateeAddedEventResponse> responses = new ArrayList<DelegateeAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DelegateeAddedEventResponse typedResponse = new DelegateeAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.manager = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse.nftId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.deployed = (Boolean) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DelegateeAddedEventResponse> delegateeAddedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, DelegateeAddedEventResponse>() {
            @Override
            public DelegateeAddedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DELEGATEEADDED_EVENT, log);
                DelegateeAddedEventResponse typedResponse = new DelegateeAddedEventResponse();
                typedResponse.log = log;
                typedResponse.owner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.manager = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse.nftId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.deployed = (Boolean) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DelegateeAddedEventResponse> delegateeAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DELEGATEEADDED_EVENT));
        return delegateeAddedEventFlowable(filter);
    }

    public static List<DelegateeRemovedEventResponse> getDelegateeRemovedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(DELEGATEEREMOVED_EVENT, transactionReceipt);
        ArrayList<DelegateeRemovedEventResponse> responses = new ArrayList<DelegateeRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DelegateeRemovedEventResponse typedResponse = new DelegateeRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.manager = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse.nftId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.deployed = (Boolean) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DelegateeRemovedEventResponse> delegateeRemovedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, DelegateeRemovedEventResponse>() {
            @Override
            public DelegateeRemovedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DELEGATEEREMOVED_EVENT, log);
                DelegateeRemovedEventResponse typedResponse = new DelegateeRemovedEventResponse();
                typedResponse.log = log;
                typedResponse.owner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.manager = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse.nftId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.deployed = (Boolean) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DelegateeRemovedEventResponse> delegateeRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DELEGATEEREMOVED_EVENT));
        return delegateeRemovedEventFlowable(filter);
    }

    public static List<InitializedEventResponse> getInitializedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(INITIALIZED_EVENT, transactionReceipt);
        ArrayList<InitializedEventResponse> responses = new ArrayList<InitializedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InitializedEventResponse typedResponse = new InitializedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.version = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, InitializedEventResponse>() {
            @Override
            public InitializedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(INITIALIZED_EVENT, log);
                InitializedEventResponse typedResponse = new InitializedEventResponse();
                typedResponse.log = log;
                typedResponse.version = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(INITIALIZED_EVENT));
        return initializedEventFlowable(filter);
    }

    public static List<ManagerAddedEventResponse> getManagerAddedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MANAGERADDED_EVENT, transactionReceipt);
        ArrayList<ManagerAddedEventResponse> responses = new ArrayList<ManagerAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, ManagerAddedEventResponse>() {
            @Override
            public ManagerAddedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MANAGERADDED_EVENT, log);
                ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MANAGERADDED_EVENT));
        return managerAddedEventFlowable(filter);
    }

    public static List<ManagerRemovedEventResponse> getManagerRemovedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MANAGERREMOVED_EVENT, transactionReceipt);
        ArrayList<ManagerRemovedEventResponse> responses = new ArrayList<ManagerRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, ManagerRemovedEventResponse>() {
            @Override
            public ManagerRemovedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MANAGERREMOVED_EVENT, log);
                ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MANAGERREMOVED_EVENT));
        return managerRemovedEventFlowable(filter);
    }

    public static List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, OwnershipTransferredEventResponse>() {
            @Override
            public OwnershipTransferredEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, log);
                OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
                typedResponse.log = log;
                typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(OWNERSHIPTRANSFERRED_EVENT));
        return ownershipTransferredEventFlowable(filter);
    }

    public static List<TenantStartedEventResponse> getTenantStartedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(TENANTSTARTED_EVENT, transactionReceipt);
        ArrayList<TenantStartedEventResponse> responses = new ArrayList<TenantStartedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TenantStartedEventResponse typedResponse = new TenantStartedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.manager = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TenantStartedEventResponse> tenantStartedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, TenantStartedEventResponse>() {
            @Override
            public TenantStartedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TENANTSTARTED_EVENT, log);
                TenantStartedEventResponse typedResponse = new TenantStartedEventResponse();
                typedResponse.log = log;
                typedResponse.manager = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TenantStartedEventResponse> tenantStartedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TENANTSTARTED_EVENT));
        return tenantStartedEventFlowable(filter);
    }

    public static List<TenantStoppedEventResponse> getTenantStoppedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(TENANTSTOPPED_EVENT, transactionReceipt);
        ArrayList<TenantStoppedEventResponse> responses = new ArrayList<TenantStoppedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TenantStoppedEventResponse typedResponse = new TenantStoppedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.manager = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TenantStoppedEventResponse> tenantStoppedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, TenantStoppedEventResponse>() {
            @Override
            public TenantStoppedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TENANTSTOPPED_EVENT, log);
                TenantStoppedEventResponse typedResponse = new TenantStoppedEventResponse();
                typedResponse.log = log;
                typedResponse.manager = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TenantStoppedEventResponse> tenantStoppedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TENANTSTOPPED_EVENT));
        return tenantStoppedEventFlowable(filter);
    }

    public static List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementation = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, UpgradedEventResponse>() {
            @Override
            public UpgradedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(UPGRADED_EVENT, log);
                UpgradedEventResponse typedResponse = new UpgradedEventResponse();
                typedResponse.log = log;
                typedResponse.implementation = (String) eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(UPGRADED_EVENT));
        return upgradedEventFlowable(filter);
    }

    public RemoteFunctionCall<TransactionReceipt> addManager(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_ADDMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> deed() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DEED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> delegatees(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DELEGATEES, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> getDelegatee(BigInteger _nftId) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETDELEGATEE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_nftId)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> initialize(String _deed) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_INITIALIZE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _deed)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isManager(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISOWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isProvisioningManager(String _address, BigInteger _nftId) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISPROVISIONINGMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _address), 
                new org.web3j.abi.datatypes.generated.Uint256(_nftId)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> owner() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<byte[]> proxiableUUID() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PROXIABLEUUID, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bytes32>() {}));
        return executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<TransactionReceipt> removeDelegatee(BigInteger _nftId) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_REMOVEDELEGATEE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_nftId)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> removeManager(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_REMOVEMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_RENOUNCEOWNERSHIP, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setDelegatee(String _address, BigInteger _nftId) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_SETDELEGATEE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _address), 
                new org.web3j.abi.datatypes.generated.Uint256(_nftId)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> startTenant(BigInteger _nftId) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_STARTTENANT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_nftId)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> stopTenant(BigInteger _nftId) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_STOPTENANT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_nftId)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> tenantStatus(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TENANTSTATUS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeTo(String newImplementation) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPGRADETO, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newImplementation)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeToAndCall(String newImplementation, byte[] data, BigInteger weiValue) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPGRADETOANDCALL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newImplementation), 
                new org.web3j.abi.datatypes.DynamicBytes(data)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function, weiValue);
    }

    @Deprecated
    public static DeedTenantProvisioning load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new DeedTenantProvisioning(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static DeedTenantProvisioning load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new DeedTenantProvisioning(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static DeedTenantProvisioning load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new DeedTenantProvisioning(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static DeedTenantProvisioning load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new DeedTenantProvisioning(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<DeedTenantProvisioning> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(DeedTenantProvisioning.class, web3j, credentials, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<DeedTenantProvisioning> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(DeedTenantProvisioning.class, web3j, credentials, gasPrice, gasLimit, BINARY, "");
    }

    public static RemoteCall<DeedTenantProvisioning> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(DeedTenantProvisioning.class, web3j, transactionManager, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<DeedTenantProvisioning> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(DeedTenantProvisioning.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, "");
    }

    public static class AdminChangedEventResponse extends BaseEventResponse {
        public String previousAdmin;

        public String newAdmin;
    }

    public static class BeaconUpgradedEventResponse extends BaseEventResponse {
        public String beacon;
    }

    public static class DelegateeAddedEventResponse extends BaseEventResponse {
        public String owner;

        public String manager;

        public BigInteger nftId;

        public Boolean deployed;
    }

    public static class DelegateeRemovedEventResponse extends BaseEventResponse {
        public String owner;

        public String manager;

        public BigInteger nftId;

        public Boolean deployed;
    }

    public static class InitializedEventResponse extends BaseEventResponse {
        public BigInteger version;
    }

    public static class ManagerAddedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class ManagerRemovedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class OwnershipTransferredEventResponse extends BaseEventResponse {
        public String previousOwner;

        public String newOwner;
    }

    public static class TenantStartedEventResponse extends BaseEventResponse {
        public String manager;

        public BigInteger nftId;
    }

    public static class TenantStoppedEventResponse extends BaseEventResponse {
        public String manager;

        public BigInteger nftId;
    }

    public static class UpgradedEventResponse extends BaseEventResponse {
        public String implementation;
    }
}
