/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.meeds.deeds.contract.TestWoM;
import io.meeds.deeds.contract.WoM;
import java.io.IOException;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public abstract class BaseWoMContractTest {
    protected static final String UNKOWN_DEED_ID = "Unkown DeedId : ";
    protected static final BigInteger CITY = BigInteger.valueOf(3L);
    protected static final BigInteger WRONG_TENANT_PERCENTAGE = BigInteger.valueOf(8L);
    protected static final String JOIN_DATE_SHOULD_NEVER_CHANGE = "Join Date should Never Change!";
    protected static final Credentials OWNER1_CREDENTIALS = Credentials.create((String)"0x1da4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    protected static final String OWNER1 = OWNER1_CREDENTIALS.getAddress();
    protected static final Credentials OWNER2_CREDENTIALS = Credentials.create((String)"0x2da4ef21b864d2cc786dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    protected static final String OWNER2 = OWNER2_CREDENTIALS.getAddress();
    protected static final Credentials OWNER3_CREDENTIALS = Credentials.create((String)"0x5da4ef21b864d2cc786dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    protected static final String OWNER3 = OWNER3_CREDENTIALS.getAddress();
    protected static final Credentials TENANT1_CREDENTIALS = Credentials.create((String)"0x3da4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    protected static final String TENANT1 = TENANT1_CREDENTIALS.getAddress();
    protected static final Credentials TENANT2_CREDENTIALS = Credentials.create((String)"0x4da4ef21b864d2cc786dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    protected static final String TENANT2 = TENANT2_CREDENTIALS.getAddress();
    protected static final Credentials TENANT3_CREDENTIALS = Credentials.create((String)"0x6da4ef21b864d2cc786dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    protected static final String TENANT3 = TENANT3_CREDENTIALS.getAddress();
    protected static final Credentials HUB1_CREDENTIALS = Credentials.create((String)"0xaaa4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    protected static final String HUB1 = HUB1_CREDENTIALS.getAddress();
    protected static final Credentials HUB2_CREDENTIALS = Credentials.create((String)"0xbba4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    protected static final String HUB2 = HUB2_CREDENTIALS.getAddress();
    protected static final Credentials HUB3_CREDENTIALS = Credentials.create((String)"0xcca4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    protected static final String HUB3 = HUB3_CREDENTIALS.getAddress();
    protected static final BigInteger DEED1 = BigInteger.valueOf(2L);
    protected static final BigInteger DEED2 = BigInteger.valueOf(33L);
    protected static final BigInteger DEED3 = BigInteger.valueOf(50L);
    protected Web3j web3j;
    protected TransactionManager transactionManager;
    protected ContractGasProvider contractGasProvider;
    protected TestWoM wom;

    public void init(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) throws Exception {
        this.wom = (TestWoM)TestWoM.deploy((Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider).send();
        this.web3j = web3j;
        this.transactionManager = transactionManager;
        this.contractGasProvider = contractGasProvider;
        Assertions.assertThrows(Exception.class, () -> this.bridgeDeed(DEED1, OWNER1, TENANT1), (String)"Only Contract Manager should be able to update The Deed");
        this.wom.addManager(transactionManager.getFromAddress()).send();
    }

    protected void checkHubJoinDate(String hubAddress, long boundary1, long boundary2) throws Exception {
        TestWoM.Hub hub = (TestWoM.Hub)this.wom.getHub(hubAddress).send();
        Assertions.assertTrue((hub.joinDate.longValue() >= boundary1 ? 1 : 0) != 0, (String)JOIN_DATE_SHOULD_NEVER_CHANGE);
        Assertions.assertTrue((hub.joinDate.longValue() <= boundary2 ? 1 : 0) != 0, (String)JOIN_DATE_SHOULD_NEVER_CHANGE);
    }

    protected void checkHubOwnershipTransferEvent(TransactionReceipt receipt, String previousOwner, String newOwner) {
        List transferHubOwnershipEvents = WoM.getHubOwnershipTransferredEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)transferHubOwnershipEvents);
        Assertions.assertEquals((int)1, (int)transferHubOwnershipEvents.size());
        WoM.HubOwnershipTransferredEventResponse hubOwnershipTransferredEvent = (WoM.HubOwnershipTransferredEventResponse)transferHubOwnershipEvents.get(0);
        Assertions.assertEquals((Object)previousOwner.toLowerCase().replace("0x", ""), (Object)hubOwnershipTransferredEvent.previousOwner.toLowerCase().replace("0x", ""));
        Assertions.assertEquals((Object)newOwner.toLowerCase().replace("0x", ""), (Object)hubOwnershipTransferredEvent.newOwner.toLowerCase().replace("0x", ""));
    }

    protected void checkHubProperties(String hubAddress, String hubOwnerAddress, BigInteger deedId) throws Exception {
        TestWoM.Hub hub = (TestWoM.Hub)this.wom.getHub(hubAddress).send();
        Assertions.assertEquals((Object)deedId, (Object)hub.deedId);
        Assertions.assertEquals((Object)hubOwnerAddress.toLowerCase().replace("0x", ""), (Object)hub.owner.toLowerCase().replace("0x", ""));
        Assertions.assertEquals((Object)hub.joinDate, (Object)this.wom.getHubJoinDate(hubAddress).send());
        Assertions.assertTrue((boolean)hub.enabled);
    }

    protected void checkHubProperties(String hubAddress, String hubOwnerAddress, BigInteger deedId, boolean enabled) throws Exception {
        TestWoM.Hub hub = (TestWoM.Hub)this.wom.getHub(hubAddress).send();
        Assertions.assertEquals((Object)deedId, (Object)hub.deedId);
        Assertions.assertEquals((Object)enabled, (Object)hub.enabled);
        Assertions.assertEquals((Object)hubOwnerAddress.toLowerCase().replace("0x", ""), (Object)hub.owner.toLowerCase().replace("0x", ""));
        Assertions.assertEquals((Object)hub.joinDate, (Object)this.wom.getHubJoinDate(hubAddress).send());
    }

    protected void checkHubConnected(BigInteger deedId, String hubAddress) throws Exception {
        Assertions.assertTrue((boolean)((Boolean)this.wom.isHubConnected(hubAddress).send()));
        Assertions.assertTrue((boolean)((Boolean)this.wom.isDeedConnected(deedId).send()));
        Assertions.assertEquals((Object)hubAddress.toLowerCase().replace("0x", ""), (Object)((String)this.wom.getConnectedHub(deedId).send()).toLowerCase().replace("0x", ""));
        Assertions.assertEquals((Object)deedId, (Object)this.wom.getConnectedDeed(hubAddress).send());
    }

    protected void checkHubDisconnected(BigInteger deedId, String hubAddress) throws Exception {
        Assertions.assertFalse((boolean)((Boolean)this.wom.isHubConnected(hubAddress).send()));
        Assertions.assertFalse((boolean)((Boolean)this.wom.isDeedConnected(deedId).send()));
    }

    protected void checkDeedProperties(BigInteger deedId, String owner, String tenant) throws Exception {
        this.checkDeedProperties(deedId, null, owner, tenant);
    }

    protected void checkDeedProperties(BigInteger deedId, String hubAddress, String owner, String tenant) throws Exception {
        TestWoM.Deed deed = (TestWoM.Deed)this.wom.getDeed(deedId).send();
        Assertions.assertEquals((Object)CITY, (Object)deed.city);
        Assertions.assertEquals((Object)this.cardType(deedId), (Object)deed.cardType);
        Assertions.assertEquals((Object)this.mintingPower(deedId), (Object)deed.mintingPower);
        Assertions.assertEquals((Object)this.maxUsers(deedId), (Object)deed.maxUsers);
        Assertions.assertEquals((Object)owner.toLowerCase().replace("0x", ""), (Object)deed.owner.toLowerCase().replace("0x", ""));
        Assertions.assertEquals((Object)tenant.toLowerCase().replace("0x", ""), (Object)deed.tenant.toLowerCase().replace("0x", ""));
        Assertions.assertEquals((Object)BigInteger.valueOf(100L).subtract(this.ownerPercentage(deedId)), (Object)deed.tenantPercentage);
        if (hubAddress != null) {
            Assertions.assertEquals((Object)hubAddress.toLowerCase().replace("0x", ""), (Object)deed.hub.toLowerCase().replace("0x", ""));
        }
    }

    protected void checkHubConnectedEvent(TransactionReceipt receipt, BigInteger deedId, String hubAddress, String deedTenantAddress) {
        List hubConnectedEvents = WoM.getHubConnectedEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)hubConnectedEvents);
        Assertions.assertEquals((int)1, (int)hubConnectedEvents.size());
        WoM.HubConnectedEventResponse hubConnectedEvent = (WoM.HubConnectedEventResponse)hubConnectedEvents.get(0);
        Assertions.assertEquals((Object)deedId, (Object)hubConnectedEvent.nftId);
        Assertions.assertEquals((Object)hubAddress.toLowerCase().replace("0x", ""), (Object)hubConnectedEvent.hub.toLowerCase().replace("0x", ""));
        Assertions.assertEquals((Object)deedTenantAddress.toLowerCase().replace("0x", ""), (Object)hubConnectedEvent.hubOwner.toLowerCase().replace("0x", ""));
    }

    protected void checkHubDisconnectedEvent(TransactionReceipt receipt, BigInteger deedId, String hubAddress) {
        List hubDisconnectedEvents = WoM.getHubDisconnectedEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)hubDisconnectedEvents);
        Assertions.assertEquals((int)1, (int)hubDisconnectedEvents.size());
        WoM.HubDisconnectedEventResponse hubDisconnectedEvent = (WoM.HubDisconnectedEventResponse)hubDisconnectedEvents.get(0);
        Assertions.assertEquals((Object)deedId, (Object)hubDisconnectedEvent.nftId);
        Assertions.assertEquals((Object)hubAddress.toLowerCase().replace("0x", ""), (Object)hubDisconnectedEvent.hub.toLowerCase().replace("0x", ""));
    }

    protected void checkDeedUpdatedEvent(TransactionReceipt receipt, BigInteger deedId) {
        List deedUpdatedEvents = WoM.getDeedUpdatedEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)deedUpdatedEvents);
        Assertions.assertEquals((int)1, (int)deedUpdatedEvents.size());
        Assertions.assertEquals((Object)deedId, (Object)((WoM.DeedUpdatedEventResponse)deedUpdatedEvents.get((int)0)).nftId);
    }

    protected void checkNoHubConnectedEvent(TransactionReceipt receipt) {
        List hubConnectedEvents = WoM.getHubConnectedEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)hubConnectedEvents);
        Assertions.assertEquals((int)0, (int)hubConnectedEvents.size());
    }

    protected void checkNoHubDisconnectedEvent(TransactionReceipt receipt) {
        List hubDisconnectedEvents = WoM.getHubDisconnectedEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)hubDisconnectedEvents);
        Assertions.assertEquals((int)0, (int)hubDisconnectedEvents.size());
    }

    protected void checkReceipt(TransactionReceipt receipt) {
        Assertions.assertNotNull((Object)receipt);
        Assertions.assertTrue((boolean)receipt.isStatusOK());
    }

    protected void sendGasFees() throws IOException {
        this.sendGasFee(OWNER1);
        this.sendGasFee(OWNER2);
        this.sendGasFee(TENANT1);
        this.sendGasFee(TENANT2);
    }

    protected void sendGasFeesForAll() throws IOException {
        this.sendGasFee(HUB1);
        this.sendGasFee(HUB2);
        this.sendGasFee(HUB3);
        this.sendGasFee(OWNER1);
        this.sendGasFee(OWNER2);
        this.sendGasFee(OWNER3);
        this.sendGasFee(TENANT1);
        this.sendGasFee(TENANT2);
        this.sendGasFee(TENANT3);
    }

    protected void sendGasFee(String receiver) throws IOException {
        if (new BigInteger(((String)((EthGetBalance)this.web3j.ethGetBalance(receiver, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getResult()).replace("0x", ""), 16).divide(BigInteger.valueOf(10L).pow(17)).longValue() < 2L) {
            this.transactionManager.sendTransaction(this.contractGasProvider.getGasPrice(), this.contractGasProvider.getGasLimit(), receiver, "", BigInteger.valueOf(5L).multiply(BigInteger.valueOf(10L).pow(17)));
        }
    }

    protected TransactionReceipt disconnectHub(Credentials from, String hubAddress) throws Exception {
        WoM contract = WoM.load((String)this.wom.getContractAddress(), (Web3j)this.web3j, (Credentials)from, (ContractGasProvider)this.contractGasProvider);
        return (TransactionReceipt)contract.disconnect(hubAddress).send();
    }

    protected TransactionReceipt connectHub(Credentials from, String hubAddress, BigInteger deedId) throws Exception {
        WoM contract = WoM.load((String)this.wom.getContractAddress(), (Web3j)this.web3j, (Credentials)from, (ContractGasProvider)this.contractGasProvider);
        return (TransactionReceipt)contract.connect(hubAddress, deedId).send();
    }

    protected TransactionReceipt transferHubOwnership(Credentials from, String hubAddress, String to) throws Exception {
        WoM contract = WoM.load((String)this.wom.getContractAddress(), (Web3j)this.web3j, (Credentials)from, (ContractGasProvider)this.contractGasProvider);
        return (TransactionReceipt)contract.transferHubOwnership(hubAddress, to).send();
    }

    protected TransactionReceipt bridgeDeedAndAutoConnect(BigInteger deedId, String hubAddress, String owner, String tenant) throws Exception {
        return this.updateDeed(deedId, hubAddress, owner, tenant);
    }

    protected TransactionReceipt bridgeDeed(BigInteger deedId, String owner, String tenant) throws Exception {
        return this.updateDeed(deedId, "0x0000000000000000000000000000000000000000", owner, tenant);
    }

    protected TransactionReceipt updateDeed(BigInteger deedId, String hubAddress, String owner, String tenant) throws Exception {
        return (TransactionReceipt)this.wom.updateDeed(deedId, new TestWoM.Deed(CITY, this.cardType(deedId), this.mintingPower(deedId), this.maxUsers(deedId), owner, tenant, hubAddress, this.ownerPercentage(deedId), WRONG_TENANT_PERCENTAGE)).send();
    }

    protected BigInteger ownerPercentage(BigInteger deedId) {
        if (DEED1.equals(deedId)) {
            return BigInteger.valueOf(20L);
        }
        if (DEED2.equals(deedId)) {
            return BigInteger.valueOf(30L);
        }
        if (DEED3.equals(deedId)) {
            return BigInteger.valueOf(0L);
        }
        throw new IllegalStateException(UNKOWN_DEED_ID + deedId);
    }

    protected BigInteger maxUsers(BigInteger deedId) {
        if (DEED1.equals(deedId)) {
            return BigInteger.valueOf(100L);
        }
        if (DEED2.equals(deedId)) {
            return BigInteger.valueOf(1000L);
        }
        if (DEED3.equals(deedId)) {
            return BigInteger.valueOf(Long.MAX_VALUE);
        }
        throw new IllegalStateException(UNKOWN_DEED_ID + deedId);
    }

    protected BigInteger mintingPower(BigInteger deedId) {
        if (DEED1.equals(deedId)) {
            return BigInteger.valueOf(100L);
        }
        if (DEED2.equals(deedId)) {
            return BigInteger.valueOf(110L);
        }
        if (DEED3.equals(deedId)) {
            return BigInteger.valueOf(200L);
        }
        throw new IllegalStateException(UNKOWN_DEED_ID + deedId);
    }

    protected BigInteger cardType(BigInteger deedId) {
        if (DEED1.equals(deedId)) {
            return BigInteger.valueOf(0L);
        }
        if (DEED2.equals(deedId)) {
            return BigInteger.valueOf(1L);
        }
        if (DEED3.equals(deedId)) {
            return BigInteger.valueOf(3L);
        }
        throw new IllegalStateException(UNKOWN_DEED_ID + deedId);
    }

    protected long now() {
        return ZonedDateTime.now().toEpochSecond();
    }
}

