package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple4;
import org.web3j.tuples.generated.Tuple9;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 4.10.3.
 */
@SuppressWarnings("rawtypes")
public class WoM extends Contract {
    public static final String BINARY = "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";

    public static final String FUNC_ADDMANAGER = "addManager";

    public static final String FUNC_CONNECT = "connect";

    public static final String FUNC_DISCONNECT = "disconnect";

    public static final String FUNC_GETCONNECTEDDEED = "getConnectedDeed";

    public static final String FUNC_GETCONNECTEDHUB = "getConnectedHub";

    public static final String FUNC_GETDEED = "getDeed";

    public static final String FUNC_GETHUB = "getHub";

    public static final String FUNC_GETHUBJOINDATE = "getHubJoinDate";

    public static final String FUNC_HUBS = "hubs";

    public static final String FUNC_INITIALIZE = "initialize";

    public static final String FUNC_ISDEEDCONNECTED = "isDeedConnected";

    public static final String FUNC_ISHUBCONNECTED = "isHubConnected";

    public static final String FUNC_ISMANAGER = "isManager";

    public static final String FUNC_ISOWNER = "isOwner";

    public static final String FUNC_NFTS = "nfts";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_PROXIABLEUUID = "proxiableUUID";

    public static final String FUNC_REMOVEMANAGER = "removeManager";

    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";

    public static final String FUNC_TRANSFERHUBOWNERSHIP = "transferHubOwnership";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final String FUNC_UPDATEDEED = "updateDeed";

    public static final String FUNC_UPGRADETO = "upgradeTo";

    public static final String FUNC_UPGRADETOANDCALL = "upgradeToAndCall";

    public static final Event ADMINCHANGED_EVENT = new Event("AdminChanged", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Address>() {}));
    ;

    public static final Event BEACONUPGRADED_EVENT = new Event("BeaconUpgraded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event DEEDUPDATED_EVENT = new Event("DeedUpdated", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>(true) {}));
    ;

    public static final Event HUBCONNECTED_EVENT = new Event("HubConnected", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>(true) {}, new TypeReference<Address>() {}));
    ;

    public static final Event HUBDISCONNECTED_EVENT = new Event("HubDisconnected", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>(true) {}));
    ;

    public static final Event HUBOWNERSHIPTRANSFERRED_EVENT = new Event("HubOwnershipTransferred", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}));
    ;

    public static final Event INITIALIZED_EVENT = new Event("Initialized", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
    ;

    public static final Event MANAGERADDED_EVENT = new Event("ManagerAdded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event MANAGERREMOVED_EVENT = new Event("ManagerRemoved", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}));
    ;

    public static final Event UPGRADED_EVENT = new Event("Upgraded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    @Deprecated
    protected WoM(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected WoM(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected WoM(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected WoM(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<AdminChangedEventResponse> getAdminChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(ADMINCHANGED_EVENT, transactionReceipt);
        ArrayList<AdminChangedEventResponse> responses = new ArrayList<AdminChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousAdmin = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.newAdmin = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static AdminChangedEventResponse getAdminChangedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(ADMINCHANGED_EVENT, log);
        AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
        typedResponse.log = log;
        typedResponse.previousAdmin = (String) eventValues.getNonIndexedValues().get(0).getValue();
        typedResponse.newAdmin = (String) eventValues.getNonIndexedValues().get(1).getValue();
        return typedResponse;
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getAdminChangedEventFromLog(log));
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(ADMINCHANGED_EVENT));
        return adminChangedEventFlowable(filter);
    }

    public static List<BeaconUpgradedEventResponse> getBeaconUpgradedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(BEACONUPGRADED_EVENT, transactionReceipt);
        ArrayList<BeaconUpgradedEventResponse> responses = new ArrayList<BeaconUpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.beacon = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static BeaconUpgradedEventResponse getBeaconUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(BEACONUPGRADED_EVENT, log);
        BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.beacon = (String) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getBeaconUpgradedEventFromLog(log));
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(BEACONUPGRADED_EVENT));
        return beaconUpgradedEventFlowable(filter);
    }

    public static List<DeedUpdatedEventResponse> getDeedUpdatedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(DEEDUPDATED_EVENT, transactionReceipt);
        ArrayList<DeedUpdatedEventResponse> responses = new ArrayList<DeedUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DeedUpdatedEventResponse typedResponse = new DeedUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static DeedUpdatedEventResponse getDeedUpdatedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(DEEDUPDATED_EVENT, log);
        DeedUpdatedEventResponse typedResponse = new DeedUpdatedEventResponse();
        typedResponse.log = log;
        typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<DeedUpdatedEventResponse> deedUpdatedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getDeedUpdatedEventFromLog(log));
    }

    public Flowable<DeedUpdatedEventResponse> deedUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DEEDUPDATED_EVENT));
        return deedUpdatedEventFlowable(filter);
    }

    public static List<HubConnectedEventResponse> getHubConnectedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(HUBCONNECTED_EVENT, transactionReceipt);
        ArrayList<HubConnectedEventResponse> responses = new ArrayList<HubConnectedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            HubConnectedEventResponse typedResponse = new HubConnectedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.hub = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
            typedResponse.hubOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static HubConnectedEventResponse getHubConnectedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(HUBCONNECTED_EVENT, log);
        HubConnectedEventResponse typedResponse = new HubConnectedEventResponse();
        typedResponse.log = log;
        typedResponse.hub = (String) eventValues.getIndexedValues().get(0).getValue();
        typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
        typedResponse.hubOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<HubConnectedEventResponse> hubConnectedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getHubConnectedEventFromLog(log));
    }

    public Flowable<HubConnectedEventResponse> hubConnectedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(HUBCONNECTED_EVENT));
        return hubConnectedEventFlowable(filter);
    }

    public static List<HubDisconnectedEventResponse> getHubDisconnectedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(HUBDISCONNECTED_EVENT, transactionReceipt);
        ArrayList<HubDisconnectedEventResponse> responses = new ArrayList<HubDisconnectedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            HubDisconnectedEventResponse typedResponse = new HubDisconnectedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.hub = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static HubDisconnectedEventResponse getHubDisconnectedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(HUBDISCONNECTED_EVENT, log);
        HubDisconnectedEventResponse typedResponse = new HubDisconnectedEventResponse();
        typedResponse.log = log;
        typedResponse.hub = (String) eventValues.getIndexedValues().get(0).getValue();
        typedResponse.nftId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
        return typedResponse;
    }

    public Flowable<HubDisconnectedEventResponse> hubDisconnectedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getHubDisconnectedEventFromLog(log));
    }

    public Flowable<HubDisconnectedEventResponse> hubDisconnectedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(HUBDISCONNECTED_EVENT));
        return hubDisconnectedEventFlowable(filter);
    }

    public static List<HubOwnershipTransferredEventResponse> getHubOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(HUBOWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<HubOwnershipTransferredEventResponse> responses = new ArrayList<HubOwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            HubOwnershipTransferredEventResponse typedResponse = new HubOwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static HubOwnershipTransferredEventResponse getHubOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(HUBOWNERSHIPTRANSFERRED_EVENT, log);
        HubOwnershipTransferredEventResponse typedResponse = new HubOwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
        typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
        return typedResponse;
    }

    public Flowable<HubOwnershipTransferredEventResponse> hubOwnershipTransferredEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getHubOwnershipTransferredEventFromLog(log));
    }

    public Flowable<HubOwnershipTransferredEventResponse> hubOwnershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(HUBOWNERSHIPTRANSFERRED_EVENT));
        return hubOwnershipTransferredEventFlowable(filter);
    }

    public static List<InitializedEventResponse> getInitializedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(INITIALIZED_EVENT, transactionReceipt);
        ArrayList<InitializedEventResponse> responses = new ArrayList<InitializedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InitializedEventResponse typedResponse = new InitializedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.version = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static InitializedEventResponse getInitializedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(INITIALIZED_EVENT, log);
        InitializedEventResponse typedResponse = new InitializedEventResponse();
        typedResponse.log = log;
        typedResponse.version = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getInitializedEventFromLog(log));
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(INITIALIZED_EVENT));
        return initializedEventFlowable(filter);
    }

    public static List<ManagerAddedEventResponse> getManagerAddedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MANAGERADDED_EVENT, transactionReceipt);
        ArrayList<ManagerAddedEventResponse> responses = new ArrayList<ManagerAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ManagerAddedEventResponse getManagerAddedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(MANAGERADDED_EVENT, log);
        ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
        typedResponse.log = log;
        typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getManagerAddedEventFromLog(log));
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MANAGERADDED_EVENT));
        return managerAddedEventFlowable(filter);
    }

    public static List<ManagerRemovedEventResponse> getManagerRemovedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MANAGERREMOVED_EVENT, transactionReceipt);
        ArrayList<ManagerRemovedEventResponse> responses = new ArrayList<ManagerRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ManagerRemovedEventResponse getManagerRemovedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(MANAGERREMOVED_EVENT, log);
        ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
        typedResponse.log = log;
        typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getManagerRemovedEventFromLog(log));
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MANAGERREMOVED_EVENT));
        return managerRemovedEventFlowable(filter);
    }

    public static List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OwnershipTransferredEventResponse getOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, log);
        OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
        typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
        return typedResponse;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getOwnershipTransferredEventFromLog(log));
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(OWNERSHIPTRANSFERRED_EVENT));
        return ownershipTransferredEventFlowable(filter);
    }

    public static List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementation = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static UpgradedEventResponse getUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(UPGRADED_EVENT, log);
        UpgradedEventResponse typedResponse = new UpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.implementation = (String) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getUpgradedEventFromLog(log));
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(UPGRADED_EVENT));
        return upgradedEventFlowable(filter);
    }

    public RemoteFunctionCall<TransactionReceipt> addManager(String account) {
        final Function function = new Function(
                FUNC_ADDMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> connect(String _hubAddress, BigInteger _deedId) {
        final Function function = new Function(
                FUNC_CONNECT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _hubAddress), 
                new org.web3j.abi.datatypes.generated.Uint256(_deedId)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> disconnect(String _hubAddress) {
        final Function function = new Function(
                FUNC_DISCONNECT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _hubAddress)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> getConnectedDeed(String _hubAddress) {
        final Function function = new Function(FUNC_GETCONNECTEDDEED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _hubAddress)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> getConnectedHub(BigInteger _deedId) {
        final Function function = new Function(FUNC_GETCONNECTEDHUB, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_deedId)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Deed> getDeed(BigInteger _deedId) {
        final Function function = new Function(FUNC_GETDEED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_deedId)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Deed>() {}));
        return executeRemoteCallSingleValueReturn(function, Deed.class);
    }

    public RemoteFunctionCall<Hub> getHub(String _hubAddress) {
        final Function function = new Function(FUNC_GETHUB, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _hubAddress)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Hub>() {}));
        return executeRemoteCallSingleValueReturn(function, Hub.class);
    }

    public RemoteFunctionCall<BigInteger> getHubJoinDate(String _hubAddress) {
        final Function function = new Function(FUNC_GETHUBJOINDATE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _hubAddress)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Tuple4<BigInteger, String, Boolean, BigInteger>> hubs(String param0) {
        final Function function = new Function(FUNC_HUBS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}, new TypeReference<Address>() {}, new TypeReference<Bool>() {}, new TypeReference<Uint256>() {}));
        return new RemoteFunctionCall<Tuple4<BigInteger, String, Boolean, BigInteger>>(function,
                new Callable<Tuple4<BigInteger, String, Boolean, BigInteger>>() {
                    @Override
                    public Tuple4<BigInteger, String, Boolean, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple4<BigInteger, String, Boolean, BigInteger>(
                                (BigInteger) results.get(0).getValue(), 
                                (String) results.get(1).getValue(), 
                                (Boolean) results.get(2).getValue(), 
                                (BigInteger) results.get(3).getValue());
                    }
                });
    }

    public RemoteFunctionCall<TransactionReceipt> initialize() {
        final Function function = new Function(
                FUNC_INITIALIZE, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isDeedConnected(BigInteger _deedId) {
        final Function function = new Function(FUNC_ISDEEDCONNECTED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_deedId)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isHubConnected(String _hubAddress) {
        final Function function = new Function(FUNC_ISHUBCONNECTED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _hubAddress)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isManager(String account) {
        final Function function = new Function(FUNC_ISMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        final Function function = new Function(FUNC_ISOWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Tuple9<BigInteger, BigInteger, BigInteger, BigInteger, String, String, String, BigInteger, BigInteger>> nfts(BigInteger param0) {
        final Function function = new Function(FUNC_NFTS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}, new TypeReference<Uint8>() {}, new TypeReference<Uint8>() {}, new TypeReference<Uint256>() {}, new TypeReference<Address>() {}, new TypeReference<Address>() {}, new TypeReference<Address>() {}, new TypeReference<Uint8>() {}, new TypeReference<Uint8>() {}));
        return new RemoteFunctionCall<Tuple9<BigInteger, BigInteger, BigInteger, BigInteger, String, String, String, BigInteger, BigInteger>>(function,
                new Callable<Tuple9<BigInteger, BigInteger, BigInteger, BigInteger, String, String, String, BigInteger, BigInteger>>() {
                    @Override
                    public Tuple9<BigInteger, BigInteger, BigInteger, BigInteger, String, String, String, BigInteger, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple9<BigInteger, BigInteger, BigInteger, BigInteger, String, String, String, BigInteger, BigInteger>(
                                (BigInteger) results.get(0).getValue(), 
                                (BigInteger) results.get(1).getValue(), 
                                (BigInteger) results.get(2).getValue(), 
                                (BigInteger) results.get(3).getValue(), 
                                (String) results.get(4).getValue(), 
                                (String) results.get(5).getValue(), 
                                (String) results.get(6).getValue(), 
                                (BigInteger) results.get(7).getValue(), 
                                (BigInteger) results.get(8).getValue());
                    }
                });
    }

    public RemoteFunctionCall<String> owner() {
        final Function function = new Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<byte[]> proxiableUUID() {
        final Function function = new Function(FUNC_PROXIABLEUUID, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bytes32>() {}));
        return executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<TransactionReceipt> removeManager(String account) {
        final Function function = new Function(
                FUNC_REMOVEMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        final Function function = new Function(
                FUNC_RENOUNCEOWNERSHIP, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferHubOwnership(String _hubAddress, String _owner) {
        final Function function = new Function(
                FUNC_TRANSFERHUBOWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _hubAddress), 
                new org.web3j.abi.datatypes.Address(160, _owner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        final Function function = new Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateDeed(BigInteger _deedId, Deed _deed) {
        final Function function = new Function(
                FUNC_UPDATEDEED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_deedId), 
                _deed), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeTo(String newImplementation) {
        final Function function = new Function(
                FUNC_UPGRADETO, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newImplementation)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeToAndCall(String newImplementation, byte[] data, BigInteger weiValue) {
        final Function function = new Function(
                FUNC_UPGRADETOANDCALL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newImplementation), 
                new org.web3j.abi.datatypes.DynamicBytes(data)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function, weiValue);
    }

    @Deprecated
    public static WoM load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new WoM(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static WoM load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new WoM(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static WoM load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new WoM(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static WoM load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new WoM(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<WoM> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(WoM.class, web3j, credentials, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<WoM> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(WoM.class, web3j, credentials, gasPrice, gasLimit, BINARY, "");
    }

    public static RemoteCall<WoM> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(WoM.class, web3j, transactionManager, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<WoM> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(WoM.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, "");
    }

    public static class Deed extends StaticStruct {
        public BigInteger city;

        public BigInteger cardType;

        public BigInteger mintingPower;

        public BigInteger maxUsers;

        public String owner;

        public String tenant;

        public String hub;

        public BigInteger ownerPercentage;

        public BigInteger tenantPercentage;

        public Deed(BigInteger city, BigInteger cardType, BigInteger mintingPower, BigInteger maxUsers, String owner, String tenant, String hub, BigInteger ownerPercentage, BigInteger tenantPercentage) {
            super(new org.web3j.abi.datatypes.generated.Uint8(city), 
                    new org.web3j.abi.datatypes.generated.Uint8(cardType), 
                    new org.web3j.abi.datatypes.generated.Uint8(mintingPower), 
                    new org.web3j.abi.datatypes.generated.Uint256(maxUsers), 
                    new org.web3j.abi.datatypes.Address(160, owner), 
                    new org.web3j.abi.datatypes.Address(160, tenant), 
                    new org.web3j.abi.datatypes.Address(160, hub), 
                    new org.web3j.abi.datatypes.generated.Uint8(ownerPercentage), 
                    new org.web3j.abi.datatypes.generated.Uint8(tenantPercentage));
            this.city = city;
            this.cardType = cardType;
            this.mintingPower = mintingPower;
            this.maxUsers = maxUsers;
            this.owner = owner;
            this.tenant = tenant;
            this.hub = hub;
            this.ownerPercentage = ownerPercentage;
            this.tenantPercentage = tenantPercentage;
        }

        public Deed(Uint8 city, Uint8 cardType, Uint8 mintingPower, Uint256 maxUsers, Address owner, Address tenant, Address hub, Uint8 ownerPercentage, Uint8 tenantPercentage) {
            super(city, cardType, mintingPower, maxUsers, owner, tenant, hub, ownerPercentage, tenantPercentage);
            this.city = city.getValue();
            this.cardType = cardType.getValue();
            this.mintingPower = mintingPower.getValue();
            this.maxUsers = maxUsers.getValue();
            this.owner = owner.getValue();
            this.tenant = tenant.getValue();
            this.hub = hub.getValue();
            this.ownerPercentage = ownerPercentage.getValue();
            this.tenantPercentage = tenantPercentage.getValue();
        }
    }

    public static class Hub extends StaticStruct {
        public BigInteger deedId;

        public String owner;

        public Boolean enabled;

        public BigInteger joinDate;

        public Hub(BigInteger deedId, String owner, Boolean enabled, BigInteger joinDate) {
            super(new org.web3j.abi.datatypes.generated.Uint256(deedId), 
                    new org.web3j.abi.datatypes.Address(160, owner), 
                    new org.web3j.abi.datatypes.Bool(enabled), 
                    new org.web3j.abi.datatypes.generated.Uint256(joinDate));
            this.deedId = deedId;
            this.owner = owner;
            this.enabled = enabled;
            this.joinDate = joinDate;
        }

        public Hub(Uint256 deedId, Address owner, Bool enabled, Uint256 joinDate) {
            super(deedId, owner, enabled, joinDate);
            this.deedId = deedId.getValue();
            this.owner = owner.getValue();
            this.enabled = enabled.getValue();
            this.joinDate = joinDate.getValue();
        }
    }

    public static class AdminChangedEventResponse extends BaseEventResponse {
        public String previousAdmin;

        public String newAdmin;
    }

    public static class BeaconUpgradedEventResponse extends BaseEventResponse {
        public String beacon;
    }

    public static class DeedUpdatedEventResponse extends BaseEventResponse {
        public BigInteger nftId;
    }

    public static class HubConnectedEventResponse extends BaseEventResponse {
        public String hub;

        public BigInteger nftId;

        public String hubOwner;
    }

    public static class HubDisconnectedEventResponse extends BaseEventResponse {
        public String hub;

        public BigInteger nftId;
    }

    public static class HubOwnershipTransferredEventResponse extends BaseEventResponse {
        public String previousOwner;

        public String newOwner;
    }

    public static class InitializedEventResponse extends BaseEventResponse {
        public BigInteger version;
    }

    public static class ManagerAddedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class ManagerRemovedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class OwnershipTransferredEventResponse extends BaseEventResponse {
        public String previousOwner;

        public String newOwner;
    }

    public static class UpgradedEventResponse extends BaseEventResponse {
        public String implementation;
    }
}
