/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.meeds.deeds.contract.BaseUEMContractTest;
import io.meeds.deeds.contract.TestUEM;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.web3j.EVMTest;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;

@EVMTest
public class UserEngagementMintingTest
extends BaseUEMContractTest {
    @Override
    @BeforeEach
    public void init(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) throws Exception {
        super.init(web3j, transactionManager, (ContractGasProvider)new StaticGasProvider(BigInteger.valueOf(41000000L), BigInteger.valueOf(9000000L)));
    }

    @Test
    public void setPeriodicRewardAmount() throws Exception {
        BigInteger periodicRewardAmount = (BigInteger)this.uem.periodicRewardAmount().send();
        Assertions.assertEquals((Object)PERIODIC_REWARD_AMOUNT, (Object)periodicRewardAmount);
    }

    @Test
    public void meedTokenAddress() throws Exception {
        String meedAddress = (String)this.uem.meed().send();
        Assertions.assertEquals((Object)this.meed.getContractAddress(), (Object)meedAddress);
    }

    @Test
    public void womAddress() throws Exception {
        String womAddress = (String)this.uem.wom().send();
        Assertions.assertEquals((Object)this.wom.getContractAddress(), (Object)womAddress);
    }

    @Test
    public void startRewardsTime() throws Exception {
        BigInteger startRewardsTime = (BigInteger)this.uem.startRewardsTime().send();
        Assertions.assertEquals((Object)START_REWARD_TIME, (Object)startRewardsTime);
    }

    @Test
    public void rewardPeriodicity() throws Exception {
        BigInteger rewardPeriodicity = (BigInteger)this.uem.REWARD_PERIOD_IN_SECONDS().send();
        Assertions.assertEquals((long)604800L, (long)rewardPeriodicity.longValue());
    }

    @Test
    public void addReportOnlyHubCanSendUEMReport() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        Assertions.assertThrows(Exception.class, () -> this.loadUem(TENANT1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport()).send(), (String)"uem.onlyHubCanSendUEMReport");
        Assertions.assertThrows(Exception.class, () -> this.loadUem(OWNER1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport()).send(), (String)"uem.onlyHubCanSendUEMReport");
        TransactionReceipt receipt = (TransactionReceipt)this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport()).send();
        this.checkReceipt(receipt);
        List reportSentEvents = TestUEM.getReportSentEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)reportSentEvents);
        Assertions.assertEquals((int)1, (int)reportSentEvents.size());
        TestUEM.ReportSentEventResponse reportSent = (TestUEM.ReportSentEventResponse)reportSentEvents.get(0);
        Assertions.assertNotNull((Object)reportSent);
        Assertions.assertEquals((Object)HUB1, (Object)reportSent.hub);
        Assertions.assertEquals((Object)this.uem.lastReportId().send(), (Object)reportSent.reportId);
        Assertions.assertNotEquals((Object)BigInteger.ZERO, (Object)reportSent.reportId);
    }

    @Test
    public void addReportHubIsNotConnectedToWoMUsingDeed() {
        Assertions.assertThrows(Exception.class, () -> this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport()).send(), (String)"wom.hubIsNotConnectedToWoMUsingDeed");
    }

    @Test
    public void addReportHubUsersIsMandatory() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        Assertions.assertThrows(Exception.class, () -> this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, BigInteger.ZERO, UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), UserEngagementMintingTest.achievementsCount(DEED1), UserEngagementMintingTest.amount(DEED1), FROM_DATE, TO_DATE)).send(), (String)"wom.hubUsersIsMandatory");
    }

    @Test
    public void addReportHubParticipantsCountIsMandatory() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        Assertions.assertThrows(Exception.class, () -> this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), BigInteger.ZERO, UserEngagementMintingTest.achievementsCount(DEED1), UserEngagementMintingTest.amount(DEED1), FROM_DATE, TO_DATE)).send(), (String)"wom.hubParticipantsCountIsMandatory");
    }

    @Test
    public void addReportHubAchievementsCountIsMandatory() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        Assertions.assertThrows(Exception.class, () -> this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), BigInteger.ZERO, UserEngagementMintingTest.amount(DEED1), FROM_DATE, TO_DATE)).send(), (String)"wom.hubAchievementsCountIsMandatory");
    }

    @Test
    public void addReportHubUsedRewardAmountIsMandatory() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        Assertions.assertThrows(Exception.class, () -> this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), UserEngagementMintingTest.achievementsCount(DEED1), BigInteger.ZERO, FROM_DATE, TO_DATE)).send(), (String)"wom.hubUsedRewardAmountIsMandatory");
    }

    @Test
    public void addReportHubReportHasNotEligibleToDate() throws Exception {
        this.connectHubs();
        Assertions.assertThrows(Exception.class, () -> this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport()).send(), (String)"wom.hubReportHasNotEligibleToDate");
    }

    @Test
    public void addReportWithJoinDateMinusOneWeek() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        long fromTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(2L).toEpochSecond();
        long toTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(1L).toEpochSecond();
        TransactionReceipt receipt = (TransactionReceipt)this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), UserEngagementMintingTest.achievementsCount(DEED1), UserEngagementMintingTest.amount(DEED1), fromTime, toTime)).send();
        this.checkReceipt(receipt);
        List reportSentEvents = TestUEM.getReportSentEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)reportSentEvents);
        Assertions.assertEquals((int)1, (int)reportSentEvents.size());
        TestUEM.ReportSentEventResponse reportSent = (TestUEM.ReportSentEventResponse)reportSentEvents.get(0);
        Assertions.assertNotNull((Object)reportSent);
        Assertions.assertEquals((Object)HUB1, (Object)reportSent.hub);
        Assertions.assertEquals((Object)this.uem.lastReportId().send(), (Object)reportSent.reportId);
        Assertions.assertNotEquals((Object)BigInteger.ZERO, (Object)reportSent.reportId);
    }

    @Test
    public void addReportHubAlreadySentReportInCurrentPeriod() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        long fromTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(5L).toEpochSecond();
        long toTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        TransactionReceipt receipt = (TransactionReceipt)this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), UserEngagementMintingTest.achievementsCount(DEED1), UserEngagementMintingTest.amount(DEED1), fromTime, toTime)).send();
        this.checkReceipt(receipt);
        List reportSentEvents = TestUEM.getReportSentEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)reportSentEvents);
        Assertions.assertEquals((int)1, (int)reportSentEvents.size());
        TestUEM.ReportSentEventResponse reportSent = (TestUEM.ReportSentEventResponse)reportSentEvents.get(0);
        Assertions.assertNotNull((Object)reportSent);
        Assertions.assertEquals((Object)HUB1, (Object)reportSent.hub);
        Assertions.assertEquals((Object)this.uem.lastReportId().send(), (Object)reportSent.reportId);
        Assertions.assertNotEquals((Object)BigInteger.ZERO, (Object)reportSent.reportId);
        long fromTime2 = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        long toTime2 = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toEpochSecond();
        Assertions.assertThrows(Exception.class, () -> this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), UserEngagementMintingTest.achievementsCount(DEED1), UserEngagementMintingTest.amount(DEED1), fromTime2, toTime2)).send(), (String)"wom.hubAlreadySentReportInCurrentPeriod");
    }

    @Test
    public void addReportDeedAlreadySentReportInCurrentPeriod() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        this.setValidJoinDate(HUB2);
        long fromTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(5L).toEpochSecond();
        long toTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        TransactionReceipt receipt = (TransactionReceipt)this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), UserEngagementMintingTest.achievementsCount(DEED1), UserEngagementMintingTest.amount(DEED1), fromTime, toTime)).send();
        this.checkReceipt(receipt);
        List reportSentEvents = TestUEM.getReportSentEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)reportSentEvents);
        Assertions.assertEquals((int)1, (int)reportSentEvents.size());
        TestUEM.ReportSentEventResponse reportSent = (TestUEM.ReportSentEventResponse)reportSentEvents.get(0);
        Assertions.assertNotNull((Object)reportSent);
        Assertions.assertEquals((Object)HUB1, (Object)reportSent.hub);
        Assertions.assertEquals((Object)this.uem.lastReportId().send(), (Object)reportSent.reportId);
        Assertions.assertNotEquals((Object)BigInteger.ZERO, (Object)reportSent.reportId);
        this.bridgeDeedAndAutoConnect(DEED1, HUB2, OWNER2, TENANT2);
        this.checkHubConnected(DEED1, HUB2);
        long fromTime2 = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        long toTime2 = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toEpochSecond();
        Assertions.assertThrows(Exception.class, () -> this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB2, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), UserEngagementMintingTest.achievementsCount(DEED1), UserEngagementMintingTest.amount(DEED1), fromTime2, toTime2)).send(), (String)"wom.deedAlreadySentReportInCurrentPeriod");
        this.bridgeDeedAndAutoConnect(DEED2, HUB2, OWNER2, TENANT2);
        this.checkHubConnected(DEED2, HUB2);
        receipt = (TransactionReceipt)this.loadUem(HUB2_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB2, UserEngagementMintingTest.usersCount(DEED2), UserEngagementMintingTest.recipientsCount(DEED2), UserEngagementMintingTest.participantsCount(DEED2), UserEngagementMintingTest.achievementsCount(DEED2), UserEngagementMintingTest.amount(DEED2), fromTime2, toTime2)).send();
        this.checkReceipt(receipt);
        reportSentEvents = TestUEM.getReportSentEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)reportSentEvents);
        Assertions.assertEquals((int)1, (int)reportSentEvents.size());
        reportSent = (TestUEM.ReportSentEventResponse)reportSentEvents.get(0);
        Assertions.assertNotNull((Object)reportSent);
        Assertions.assertEquals((Object)HUB2, (Object)reportSent.hub);
        Assertions.assertEquals((Object)this.uem.lastReportId().send(), (Object)reportSent.reportId);
        Assertions.assertNotEquals((Object)BigInteger.ZERO, (Object)reportSent.reportId);
    }

    @Test
    public void addReportLastReportFromDateMustBeLessThanCurrentReportFromDate() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        this.setValidJoinDate(HUB2);
        this.moveBackCurrentPeriodInWeeks(2);
        long fromTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        long toTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toEpochSecond();
        TransactionReceipt receipt = (TransactionReceipt)this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), UserEngagementMintingTest.achievementsCount(DEED1), UserEngagementMintingTest.amount(DEED1), fromTime, toTime)).send();
        this.checkReceipt(receipt);
        List reportSentEvents = TestUEM.getReportSentEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)reportSentEvents);
        Assertions.assertEquals((int)1, (int)reportSentEvents.size());
        TestUEM.ReportSentEventResponse reportSent = (TestUEM.ReportSentEventResponse)reportSentEvents.get(0);
        Assertions.assertNotNull((Object)reportSent);
        Assertions.assertEquals((Object)HUB1, (Object)reportSent.hub);
        Assertions.assertEquals((Object)this.uem.lastReportId().send(), (Object)reportSent.reportId);
        Assertions.assertNotEquals((Object)BigInteger.ZERO, (Object)reportSent.reportId);
        this.moveBackCurrentPeriodInWeeks(0);
        long fromTime2 = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(5L).toEpochSecond();
        long toTime2 = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        Assertions.assertThrows(Exception.class, () -> this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport(HUB1, UserEngagementMintingTest.usersCount(DEED1), UserEngagementMintingTest.recipientsCount(DEED1), UserEngagementMintingTest.participantsCount(DEED1), UserEngagementMintingTest.achievementsCount(DEED1), UserEngagementMintingTest.amount(DEED1), fromTime2, toTime2)).send(), (String)"wom.lastReportFromDateMustBeLessThanCurrentReportFromDate");
        receipt = (TransactionReceipt)this.loadUem(HUB1_CREDENTIALS).addReport(UserEngagementMintingTest.newHubReport()).send();
        reportSentEvents = TestUEM.getReportSentEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)reportSentEvents);
        Assertions.assertEquals((int)1, (int)reportSentEvents.size());
        reportSent = (TestUEM.ReportSentEventResponse)reportSentEvents.get(0);
        Assertions.assertNotNull((Object)reportSent);
        Assertions.assertEquals((Object)HUB1, (Object)reportSent.hub);
        Assertions.assertEquals((Object)this.uem.lastReportId().send(), (Object)reportSent.reportId);
        Assertions.assertNotEquals((Object)BigInteger.ZERO, (Object)reportSent.reportId);
    }

    @Test
    public void addReportPropertiesCheck() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        this.setValidJoinDate(HUB2);
        this.setValidJoinDate(HUB3);
        long fromTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        long toTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toEpochSecond();
        BigInteger reportId1 = this.addReportAndCheckProperties(HUB1_CREDENTIALS, HUB1, DEED1, OWNER1, TENANT1, fromTime, toTime);
        BigInteger reportId2 = this.addReportAndCheckProperties(HUB2_CREDENTIALS, HUB2, DEED2, OWNER2, TENANT2, fromTime, toTime);
        BigInteger reportId3 = this.addReportAndCheckProperties(HUB3_CREDENTIALS, HUB3, DEED3, OWNER3, TENANT3, fromTime, toTime);
        BaseUEMContractTest.RewardPeriod rewardPeriod = this.getRewardPeriodByReportId(reportId1);
        Assertions.assertEquals((Object)PERIODIC_REWARD_AMOUNT, (Object)rewardPeriod.amount);
        Assertions.assertEquals((long)3L, (long)rewardPeriod.reportsCount.longValue());
        Assertions.assertEquals((Object)reportId1, (Object)rewardPeriod.fromReport);
        Assertions.assertEquals((Object)reportId3, (Object)rewardPeriod.toReport);
        Assertions.assertEquals((Object)this.getFixedRewardIndex(reportId1).add(this.getFixedRewardIndex(reportId2)).add(this.getFixedRewardIndex(reportId3)), (Object)rewardPeriod.fixedGlobalIndex);
        Assertions.assertEquals((long)ZonedDateTime.now().with(DayOfWeek.MONDAY).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond(), (long)rewardPeriod.fromDate.longValue());
        Assertions.assertEquals((long)ZonedDateTime.now().with(DayOfWeek.MONDAY).plusWeeks(1L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond(), (long)rewardPeriod.toDate.longValue());
    }

    @Test
    public void pendingRewardBalanceOf() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        this.setValidJoinDate(HUB2);
        this.setValidJoinDate(HUB3);
        this.moveBackCurrentPeriodInWeeks(2);
        long fromTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        long toTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toEpochSecond();
        BigInteger reportId1 = this.addReport(HUB1_CREDENTIALS, HUB1, DEED1, fromTime, toTime);
        BigInteger reportId2 = this.addReport(HUB2_CREDENTIALS, HUB2, DEED2, fromTime, toTime);
        BigInteger reportId3 = this.addReport(HUB3_CREDENTIALS, HUB3, DEED3, fromTime, toTime);
        this.moveBackCurrentPeriodInWeeks(1);
        BigInteger owner1PendingReward = (BigInteger)this.uem.pendingRewardBalanceOf(OWNER1).send();
        BigInteger tenant1PendingReward = (BigInteger)this.uem.pendingRewardBalanceOf(TENANT1).send();
        BigInteger owner2PendingReward = (BigInteger)this.uem.pendingRewardBalanceOf(OWNER2).send();
        BigInteger tenant2PendingReward = (BigInteger)this.uem.pendingRewardBalanceOf(TENANT2).send();
        BigInteger owner3PendingReward = (BigInteger)this.uem.pendingRewardBalanceOf(OWNER3).send();
        BigInteger tenant3PendingReward = (BigInteger)this.uem.pendingRewardBalanceOf(TENANT3).send();
        BaseUEMContractTest.RewardPeriod rewardPeriod = this.getRewardPeriodByReportId(reportId1);
        BaseUEMContractTest.HubReportReward reportReward1 = this.getHubReportRewardById(reportId1);
        BaseUEMContractTest.HubReportReward reportReward2 = this.getHubReportRewardById(reportId2);
        BaseUEMContractTest.HubReportReward reportReward3 = this.getHubReportRewardById(reportId3);
        Assertions.assertEquals((Object)PERIODIC_REWARD_AMOUNT, (Object)rewardPeriod.amount);
        Assertions.assertEquals((Object)rewardPeriod.amount.divide(BigInteger.valueOf(100L)), (Object)new BigDecimal(owner1PendingReward.add(tenant1PendingReward).add(owner2PendingReward).add(tenant2PendingReward).add(owner3PendingReward).add(tenant3PendingReward)).divide(BigDecimal.valueOf(100L), MathContext.DECIMAL128).setScale(0, RoundingMode.HALF_EVEN).toBigInteger());
        Assertions.assertEquals((Object)new BigDecimal(rewardPeriod.amount).multiply(new BigDecimal(reportReward1.fixedRewardIndex)).divide(new BigDecimal(rewardPeriod.fixedGlobalIndex), MathContext.DECIMAL128).divide(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.DOWN).toBigInteger(), (Object)owner1PendingReward.add(tenant1PendingReward).divide(BigInteger.valueOf(100L)));
        Assertions.assertEquals((Object)new BigDecimal(rewardPeriod.amount).multiply(new BigDecimal(reportReward2.fixedRewardIndex)).divide(new BigDecimal(rewardPeriod.fixedGlobalIndex), MathContext.DECIMAL128).divide(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.DOWN).toBigInteger(), (Object)owner2PendingReward.add(tenant2PendingReward).divide(BigInteger.valueOf(100L)));
        Assertions.assertEquals((Object)new BigDecimal(rewardPeriod.amount).multiply(new BigDecimal(reportReward3.fixedRewardIndex)).divide(new BigDecimal(rewardPeriod.fixedGlobalIndex), MathContext.DECIMAL128).divide(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.DOWN).toBigInteger(), (Object)owner3PendingReward.add(tenant3PendingReward).divide(BigInteger.valueOf(100L)));
    }

    @Test
    public void claim() throws Exception {
        this.connectHubs();
        this.setValidJoinDate(HUB1);
        this.setValidJoinDate(HUB2);
        this.setValidJoinDate(HUB3);
        this.sendMeedsToUem();
        long fromTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(5L).toEpochSecond();
        long toTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        this.moveBackCurrentPeriodInWeeks(3);
        BigInteger report1Id1 = this.addReport(HUB1_CREDENTIALS, HUB1, DEED1, fromTime, toTime);
        BigInteger report2Id1 = this.addReport(HUB2_CREDENTIALS, HUB2, DEED2, fromTime, toTime);
        BigInteger report3Id1 = this.addReport(HUB3_CREDENTIALS, HUB3, DEED3, fromTime, toTime);
        BaseUEMContractTest.RewardPeriod rewardPeriod = this.getRewardPeriodByReportId(report1Id1);
        Assertions.assertEquals((Object)PERIODIC_REWARD_AMOUNT, (Object)rewardPeriod.amount);
        this.claimAndCheck(OWNER1_CREDENTIALS, OWNER1, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, 0, 1, report1Id1);
        this.claimAndCheck(TENANT1_CREDENTIALS, TENANT1, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, 0, 1, report1Id1);
        this.claimAndCheck(OWNER2_CREDENTIALS, OWNER2, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, 0, 1, report2Id1);
        this.claimAndCheck(TENANT2_CREDENTIALS, TENANT2, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, 0, 1, report2Id1);
        this.claimAndCheck(OWNER3_CREDENTIALS, OWNER3, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, 0, 0, BigInteger.ZERO);
        this.claimAndCheck(TENANT3_CREDENTIALS, TENANT3, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, 0, 1, report3Id1);
        this.moveBackCurrentPeriodInWeeks(2);
        BigInteger owner1Report1Earnings = this.computeRewardByReportAndRecipientType(report1Id1, true);
        BigInteger tenant1Report1Earnings = this.computeRewardByReportAndRecipientType(report1Id1, false);
        BigInteger owner2Report1Earnings = this.computeRewardByReportAndRecipientType(report2Id1, true);
        BigInteger tenant2Report1Earnings = this.computeRewardByReportAndRecipientType(report2Id1, false);
        BigInteger owner3Report1Earnings = this.computeRewardByReportAndRecipientType(report3Id1, true);
        BigInteger tenant3Report1Earnings = this.computeRewardByReportAndRecipientType(report3Id1, false);
        Assertions.assertThrows(Exception.class, () -> this.loadUem(OWNER1_CREDENTIALS).claim("0x0000000000000000000000000000000000000000", owner1Report1Earnings.add(BigInteger.ONE)).send(), (String)"Shouldn't be able to claim more than what we earn");
        this.claimAndCheck(OWNER1_CREDENTIALS, OWNER1, owner1Report1Earnings.subtract(BigInteger.ONE), owner1Report1Earnings.subtract(BigInteger.ONE), owner1Report1Earnings.subtract(BigInteger.ONE), owner1Report1Earnings, 1, 1, report1Id1);
        this.claimAndCheck(OWNER1_CREDENTIALS, "0x0000000000000000000000000000000000000000", BigInteger.ZERO, BigInteger.ONE, owner1Report1Earnings, owner1Report1Earnings, 1, 1, report1Id1);
        this.claimAndCheck(OWNER1_CREDENTIALS, OWNER1, BigInteger.ZERO, BigInteger.ZERO, owner1Report1Earnings, owner1Report1Earnings, 1, 1, report1Id1);
        fromTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(4L).toEpochSecond();
        toTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toEpochSecond();
        BigInteger report1Id2 = this.addReport(HUB1_CREDENTIALS, HUB1, DEED1, fromTime, toTime);
        BigInteger report2Id2 = this.addReport(HUB2_CREDENTIALS, HUB2, DEED2, fromTime, toTime);
        BigInteger report3Id2 = this.addReport(HUB3_CREDENTIALS, HUB3, DEED3, fromTime, toTime);
        this.checkPreviouslyRewardedAmount(owner1Report1Earnings, report1Id2, DEED1, true);
        this.checkPreviouslyRewardedAmount(owner2Report1Earnings, report2Id2, DEED2, true);
        this.checkPreviouslyRewardedAmount(tenant3Report1Earnings, report3Id2, DEED3, false);
        this.moveBackCurrentPeriodInWeeks(1);
        BigInteger owner1Report2Earnings = this.computeRewardByReportAndRecipientType(report1Id2, true);
        BigInteger tenant1Report2Earnings = this.computeRewardByReportAndRecipientType(report1Id2, false);
        BigInteger owner2Report2Earnings = this.computeRewardByReportAndRecipientType(report2Id2, true);
        BigInteger tenant2Report2Earnings = this.computeRewardByReportAndRecipientType(report2Id2, false);
        BigInteger owner3Report2Earnings = this.computeRewardByReportAndRecipientType(report3Id2, true);
        BigInteger tenant3Report2Earnings = this.computeRewardByReportAndRecipientType(report3Id2, false);
        fromTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toEpochSecond();
        toTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(2L).toEpochSecond();
        BigInteger report1Id3 = this.addReport(HUB1_CREDENTIALS, HUB1, DEED1, fromTime, toTime);
        BigInteger report2Id3 = this.addReport(HUB2_CREDENTIALS, HUB2, DEED2, fromTime, toTime);
        BigInteger report3Id3 = this.addReport(HUB3_CREDENTIALS, HUB3, DEED3, fromTime, toTime);
        this.checkPreviouslyRewardedAmount(owner1Report2Earnings, report1Id3, DEED1, true);
        this.checkPreviouslyRewardedAmount(owner2Report2Earnings, report2Id3, DEED2, true);
        this.checkPreviouslyRewardedAmount(tenant3Report2Earnings, report3Id3, DEED3, false);
        this.claimAndCheck(OWNER1_CREDENTIALS, OWNER1, owner1Report2Earnings, owner1Report2Earnings, owner1Report1Earnings.add(owner1Report2Earnings), owner1Report1Earnings.add(owner1Report2Earnings), 2, 3, report1Id3);
        this.claimAndCheck(TENANT1_CREDENTIALS, "0x0000000000000000000000000000000000000000", BigInteger.ZERO, tenant1Report1Earnings.add(tenant1Report2Earnings), tenant1Report1Earnings.add(tenant1Report2Earnings), tenant1Report1Earnings.add(tenant1Report2Earnings), 2, 3, report1Id3);
        this.claimAndCheck(OWNER2_CREDENTIALS, "0x0000000000000000000000000000000000000000", owner2Report1Earnings, owner2Report1Earnings, owner2Report1Earnings, owner2Report1Earnings.add(owner2Report2Earnings), 2, 3, report2Id3);
        this.claimAndCheck(OWNER2_CREDENTIALS, "0x0000000000000000000000000000000000000000", BigInteger.TWO, BigInteger.TWO, owner2Report1Earnings.add(BigInteger.TWO), owner2Report1Earnings.add(owner2Report2Earnings), 2, 3, report2Id3);
        this.claimAndCheck(OWNER2_CREDENTIALS, "0x0000000000000000000000000000000000000000", BigInteger.TEN, BigInteger.TEN, owner2Report1Earnings.add(BigInteger.TWO).add(BigInteger.TEN), owner2Report1Earnings.add(owner2Report2Earnings), 2, 3, report2Id3);
        this.claimAndCheck(OWNER2_CREDENTIALS, "0x0000000000000000000000000000000000000000", BigInteger.ZERO, owner2Report2Earnings.subtract(BigInteger.TWO).subtract(BigInteger.TEN), owner2Report1Earnings.add(owner2Report2Earnings), owner2Report1Earnings.add(owner2Report2Earnings), 2, 3, report2Id3);
        this.claimAndCheck(TENANT2_CREDENTIALS, "0x0000000000000000000000000000000000000000", BigInteger.ZERO, tenant2Report1Earnings.add(tenant2Report2Earnings), tenant2Report1Earnings.add(tenant2Report2Earnings), tenant2Report1Earnings.add(tenant2Report2Earnings), 2, 3, report2Id3);
        this.claimAndCheck(OWNER3_CREDENTIALS, "0x0000000000000000000000000000000000000000", BigInteger.ZERO, owner3Report1Earnings.add(owner3Report2Earnings), owner3Report1Earnings.add(owner3Report2Earnings), owner3Report1Earnings.add(owner3Report2Earnings), 0, 0, BigInteger.ZERO);
        this.claimAndCheck(TENANT3_CREDENTIALS, "0x0000000000000000000000000000000000000000", BigInteger.ZERO, tenant3Report1Earnings.add(tenant3Report2Earnings), tenant3Report1Earnings.add(tenant3Report2Earnings), tenant3Report1Earnings.add(tenant3Report2Earnings), 2, 3, report3Id3);
        BigInteger totalRewardsSent = owner1Report1Earnings.add(owner1Report2Earnings).add(tenant1Report1Earnings).add(tenant1Report2Earnings).add(owner2Report1Earnings).add(owner2Report2Earnings).add(tenant2Report1Earnings).add(tenant2Report2Earnings).add(owner3Report1Earnings).add(owner3Report2Earnings).add(tenant3Report1Earnings).add(tenant3Report2Earnings);
        Assertions.assertEquals((Object)new BigDecimal(PERIODIC_REWARD_AMOUNT.multiply(BigInteger.TWO)).divide(BigDecimal.TEN).toBigInteger(), (Object)new BigDecimal(totalRewardsSent).divide(BigDecimal.TEN).setScale(0, RoundingMode.HALF_EVEN).toBigInteger());
    }
}

