/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.meeds.deeds.contract.BaseWoMContractTest;
import io.meeds.deeds.contract.MeedsToken;
import io.meeds.deeds.contract.TestUEM;
import io.meeds.deeds.contract.UserEngagementMintingProxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.tuweni.bytes.Bytes;
import org.junit.jupiter.api.Assertions;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple10;
import org.web3j.tuples.generated.Tuple3;
import org.web3j.tuples.generated.Tuple5;
import org.web3j.tuples.generated.Tuple7;
import org.web3j.tuples.generated.Tuple9;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public abstract class BaseUEMContractTest
extends BaseWoMContractTest {
    protected static final String TOKEN_ADDRESS = "0x0143b71443650AA8eFA76BD82F35c22EBD558090";
    protected static final BigInteger TOKEN_CHAIN_ID = BigInteger.valueOf(80001L);
    protected static final long FROM_DATE = ZonedDateTime.now().minusWeeks(2L).toEpochSecond();
    protected static final long TO_DATE = ZonedDateTime.now().minusWeeks(1L).toEpochSecond();
    protected static final long START_REWARD_TIME_SEC = 1672617600L;
    protected static final BigInteger PERIODIC_REWARD_AMOUNT = BigInteger.valueOf(5L).multiply(BigInteger.valueOf(10L).pow(18));
    protected static final BigInteger START_REWARD_TIME = BigInteger.valueOf(1672617600L);
    protected MeedsToken meed;
    protected TestUEM uem;

    @Override
    public void init(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) throws Exception {
        super.init(web3j, transactionManager, contractGasProvider);
        this.meed = (MeedsToken)MeedsToken.deploy((Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider).send();
        this.uem = this.deployUem(web3j, transactionManager, contractGasProvider);
        this.uem.setPeriodicRewardAmount(PERIODIC_REWARD_AMOUNT).send();
    }

    protected void sendMeedsToUem() throws Exception {
        this.meed.mint(this.uem.getContractAddress(), BigInteger.valueOf(10L).pow(22)).send();
    }

    protected void connectHubs() throws Exception {
        this.sendGasFeesForAll();
        this.bridgeDeed(DEED1, OWNER1, TENANT1);
        this.bridgeDeed(DEED2, OWNER2, TENANT2);
        this.bridgeDeed(DEED3, OWNER3, TENANT3);
        this.connectHub(TENANT1_CREDENTIALS, HUB1, DEED1);
        this.connectHub(TENANT2_CREDENTIALS, HUB2, DEED2);
        this.connectHub(TENANT3_CREDENTIALS, HUB3, DEED3);
    }

    protected void setValidJoinDate(String hubAddress) throws Exception {
        this.setValidJoinDate(hubAddress, 1672617600L);
    }

    protected void setValidJoinDate(String hubAddress, long timeInMs) throws Exception {
        this.wom.setJoinDate(hubAddress, BigInteger.valueOf(timeInMs)).send();
    }

    protected void moveBackCurrentPeriodInWeeks(int weeks) throws Exception {
        this.uem.setTestOnPreviousPeriod(BigInteger.valueOf(weeks)).send();
    }

    protected static TestUEM.HubReport newHubReport() {
        return BaseUEMContractTest.newHubReport(HUB1, BaseUEMContractTest.usersCount(DEED1), BaseUEMContractTest.recipientsCount(DEED1), BaseUEMContractTest.participantsCount(DEED1), BaseUEMContractTest.achievementsCount(DEED1), BaseUEMContractTest.amount(DEED1), FROM_DATE, TO_DATE);
    }

    protected static TestUEM.HubReport newHubReport(String hub, BigInteger usersCount, BigInteger recipientsCount, BigInteger participantsCount, BigInteger achievementsCount, BigInteger amount, long fromDate, long toDate) {
        return new TestUEM.HubReport(hub, usersCount, recipientsCount, participantsCount, achievementsCount, amount, TOKEN_ADDRESS, TOKEN_CHAIN_ID, BigInteger.valueOf(fromDate), BigInteger.valueOf(toDate));
    }

    protected static TestUEM.HubReport newHubReport(String hub, long usersCount, long recipientsCount, long participantsCount, long achievementsCount, long amount, long fromDate, long toDate) {
        return new TestUEM.HubReport(hub, BigInteger.valueOf(usersCount), BigInteger.valueOf(recipientsCount), BigInteger.valueOf(participantsCount), BigInteger.valueOf(achievementsCount), BigInteger.valueOf(amount), TOKEN_ADDRESS, TOKEN_CHAIN_ID, BigInteger.valueOf(fromDate), BigInteger.valueOf(toDate));
    }

    protected BigInteger getFixedRewardIndex(BigInteger reportId) throws Exception {
        return this.getHubReportRewardById((BigInteger)reportId).fixedRewardIndex;
    }

    protected RewardPeriod getRewardPeriodByReportId(BigInteger reportId) throws Exception {
        BigInteger rewardPeriodId = this.getHubReportRewardById((BigInteger)reportId).rewardPeriodId;
        Tuple7 tuple = (Tuple7)this.uem.rewards(rewardPeriodId).send();
        return new RewardPeriod((BigInteger)tuple.component1(), (BigInteger)tuple.component2(), (BigInteger)tuple.component3(), (BigInteger)tuple.component4(), (BigInteger)tuple.component5(), (BigInteger)tuple.component6(), (BigInteger)tuple.component7());
    }

    protected BigInteger addReportAndCheckProperties(Credentials credentials, String hubAddress, BigInteger deedId, String ownerAddress, String tenantAddress, long fromTime, long toTime) throws Exception {
        BigInteger reportId = this.addReport(credentials, hubAddress, deedId, fromTime, toTime);
        TestUEM.HubReport hubReport = this.getHubReportById(reportId);
        Assertions.assertEquals((Object)hubAddress.replace("0x", "").toLowerCase(), (Object)hubReport.hub.replace("0x", "").toLowerCase());
        Assertions.assertEquals((Object)BaseUEMContractTest.usersCount(deedId), (Object)hubReport.usersCount);
        Assertions.assertEquals((Object)BaseUEMContractTest.recipientsCount(deedId), (Object)hubReport.recipientsCount);
        Assertions.assertEquals((Object)BaseUEMContractTest.participantsCount(deedId), (Object)hubReport.participantsCount);
        Assertions.assertEquals((Object)BaseUEMContractTest.achievementsCount(deedId), (Object)hubReport.achievementsCount);
        Assertions.assertEquals((Object)BaseUEMContractTest.amount(deedId), (Object)hubReport.amount);
        Assertions.assertEquals((long)fromTime, (long)hubReport.fromDate.longValue());
        Assertions.assertEquals((long)toTime, (long)hubReport.toDate.longValue());
        HubReportDeed hubDeed = this.getHubReportDeedById(reportId);
        Assertions.assertEquals((Object)deedId, (Object)hubDeed.deedId);
        Assertions.assertEquals((Object)this.maxUsers(deedId), (Object)hubDeed.maxUsers);
        Assertions.assertEquals((Object)this.mintingPower(deedId), (Object)hubDeed.mintingPower);
        Assertions.assertEquals((Object)this.cardType(deedId), (Object)hubDeed.cardType);
        Assertions.assertEquals((Object)CITY, (Object)hubDeed.city);
        HubReportReward hubReward = this.getHubReportRewardById(reportId);
        Assertions.assertFalse((boolean)hubReward.fraud);
        Assertions.assertTrue((hubReward.rewardPeriodId.longValue() > 0L ? 1 : 0) != 0);
        long currentRewardId = (this.now() - 1672617600L) / 604800L;
        Assertions.assertEquals((long)currentRewardId, (long)hubReward.rewardPeriodId.longValue());
        Assertions.assertEquals((Object)ownerAddress.replace("0x", "").toLowerCase(), (Object)hubReward.owner.replace("0x", "").toLowerCase());
        Assertions.assertEquals((Object)tenantAddress.replace("0x", "").toLowerCase(), (Object)hubReward.tenant.replace("0x", "").toLowerCase());
        Assertions.assertTrue((this.now() - hubReward.sentDate.longValue() <= 15L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)BigInteger.ZERO, (Object)hubReward.lastRewardedAmount);
        Assertions.assertEquals((Object)this.computeFixedRewardIndex(hubReport, hubReward, hubDeed), (Object)hubReward.fixedRewardIndex);
        Assertions.assertEquals((Object)hubReward.fixedRewardIndex.subtract(hubReward.ownerFixedIndex).divide(BigInteger.valueOf(10L)), (Object)hubReward.tenantFixedIndex.divide(BigInteger.valueOf(10L)));
        Assertions.assertEquals((Object)BigInteger.valueOf(100L).subtract(this.ownerPercentage(deedId)), (Object)new BigDecimal(hubReward.tenantFixedIndex.multiply(BigInteger.valueOf(100L))).divide(new BigDecimal(hubReward.fixedRewardIndex), MathContext.DECIMAL128).setScale(5, RoundingMode.HALF_UP).toBigInteger());
        Assertions.assertEquals((Object)this.ownerPercentage(deedId), (Object)new BigDecimal(hubReward.ownerFixedIndex.multiply(BigInteger.valueOf(100L))).divide(new BigDecimal(hubReward.fixedRewardIndex), MathContext.DECIMAL128).setScale(5, RoundingMode.HALF_UP).toBigInteger());
        return reportId;
    }

    protected BigInteger addReport(Credentials credentials, String hubAddress, BigInteger deedId, long fromTime, long toTime) throws Exception {
        TransactionReceipt receipt = (TransactionReceipt)this.loadUem(credentials).addReport(BaseUEMContractTest.newHubReport(hubAddress, BaseUEMContractTest.usersCount(deedId), BaseUEMContractTest.recipientsCount(deedId), BaseUEMContractTest.participantsCount(deedId), BaseUEMContractTest.achievementsCount(deedId), BaseUEMContractTest.amount(deedId), fromTime, toTime)).send();
        this.checkReceipt(receipt);
        List reportSentEvents = TestUEM.getReportSentEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)reportSentEvents);
        Assertions.assertEquals((int)1, (int)reportSentEvents.size());
        TestUEM.ReportSentEventResponse reportSent = (TestUEM.ReportSentEventResponse)reportSentEvents.get(0);
        Assertions.assertNotNull((Object)reportSent);
        Assertions.assertEquals((Object)hubAddress, (Object)reportSent.hub);
        Assertions.assertEquals((Object)this.uem.lastReportId().send(), (Object)reportSent.reportId);
        Assertions.assertNotEquals((Object)BigInteger.ZERO, (Object)reportSent.reportId);
        return reportSent.reportId;
    }

    protected TestUEM.HubReport getHubReportById(BigInteger reportId) throws Exception {
        Tuple10 report = (Tuple10)this.uem.hubReports(reportId).send();
        return new TestUEM.HubReport((String)report.component1(), (BigInteger)report.component2(), (BigInteger)report.component3(), (BigInteger)report.component4(), (BigInteger)report.component5(), (BigInteger)report.component6(), (String)report.component7(), (BigInteger)report.component8(), (BigInteger)report.component9(), (BigInteger)report.component10());
    }

    protected HubReportDeed getHubReportDeedById(BigInteger reportId) throws Exception {
        Tuple5 hubDeed = (Tuple5)this.uem.hubDeeds(reportId).send();
        return new HubReportDeed((BigInteger)hubDeed.component1(), (BigInteger)hubDeed.component2(), (BigInteger)hubDeed.component3(), (BigInteger)hubDeed.component4(), (BigInteger)hubDeed.component5());
    }

    protected HubReportReward getHubReportRewardById(BigInteger reportId) throws Exception {
        Tuple9 hubReward = (Tuple9)this.uem.hubRewards(reportId).send();
        return new HubReportReward((BigInteger)hubReward.component1(), (String)hubReward.component2(), (String)hubReward.component3(), (BigInteger)hubReward.component4(), (BigInteger)hubReward.component5(), (BigInteger)hubReward.component6(), (BigInteger)hubReward.component7(), (Boolean)hubReward.component8(), (BigInteger)hubReward.component9());
    }

    protected Recipient getRecipient(String address) throws Exception {
        Tuple3 tuple = (Tuple3)this.uem.recipients(address).send();
        return new Recipient((BigInteger)tuple.component1(), (BigInteger)tuple.component2(), (BigInteger)tuple.component3());
    }

    protected List<BigInteger> getRecipientReportIds(String address) throws Exception {
        return (List)this.uem.reportsByRecipient(address).send();
    }

    protected TestUEM deployUem(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) throws Exception {
        TestUEM uemImpl = (TestUEM)TestUEM.deploy((Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider).send();
        Function function = new Function("initialize", Arrays.asList(new Address(160, this.meed.getContractAddress()), new Address(160, this.wom.getContractAddress()), new Uint256(START_REWARD_TIME)), Collections.emptyList());
        byte[] data = Bytes.fromHexString((CharSequence)FunctionEncoder.encode((Function)function)).toArray();
        UserEngagementMintingProxy uemProxy = (UserEngagementMintingProxy)UserEngagementMintingProxy.deploy((Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, null, (String)uemImpl.getContractAddress(), (byte[])data).send();
        return TestUEM.load((String)uemProxy.getContractAddress(), (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider);
    }

    protected TestUEM loadUem(Credentials credentials) {
        return TestUEM.load((String)this.uem.getContractAddress(), (Web3j)this.web3j, (Credentials)credentials, (ContractGasProvider)this.contractGasProvider);
    }

    protected static BigInteger usersCount(BigInteger deedId) {
        if (DEED1.equals(deedId)) {
            return BigInteger.valueOf(550L);
        }
        if (DEED2.equals(deedId)) {
            return BigInteger.valueOf(5000L);
        }
        if (DEED3.equals(deedId)) {
            return BigInteger.valueOf(100000L);
        }
        throw new IllegalStateException("Unkown DeedId : " + String.valueOf(deedId));
    }

    protected static BigInteger recipientsCount(BigInteger deedId) {
        if (DEED1.equals(deedId)) {
            return BigInteger.valueOf(322L);
        }
        if (DEED2.equals(deedId)) {
            return BigInteger.valueOf(3030L);
        }
        if (DEED3.equals(deedId)) {
            return BigInteger.valueOf(9563L);
        }
        throw new IllegalStateException("Unkown DeedId : " + String.valueOf(deedId));
    }

    protected static BigInteger participantsCount(BigInteger deedId) {
        if (DEED1.equals(deedId)) {
            return BigInteger.valueOf(452L);
        }
        if (DEED2.equals(deedId)) {
            return BigInteger.valueOf(4581L);
        }
        if (DEED3.equals(deedId)) {
            return BigInteger.valueOf(11163L);
        }
        throw new IllegalStateException("Unkown DeedId : " + String.valueOf(deedId));
    }

    protected static BigInteger achievementsCount(BigInteger deedId) {
        if (DEED1.equals(deedId)) {
            return BigInteger.valueOf(540978L);
        }
        if (DEED2.equals(deedId)) {
            return BigInteger.valueOf(1040978L);
        }
        if (DEED3.equals(deedId)) {
            return BigInteger.valueOf(86040978L);
        }
        throw new IllegalStateException("Unkown DeedId : " + String.valueOf(deedId));
    }

    protected static BigInteger amount(BigInteger deedId) {
        if (DEED1.equals(deedId)) {
            return BigInteger.valueOf(2440L).multiply(BigInteger.valueOf(10L).pow(18));
        }
        if (DEED2.equals(deedId)) {
            return BigInteger.valueOf(5200L).multiply(BigInteger.valueOf(10L).pow(18));
        }
        if (DEED3.equals(deedId)) {
            return BigInteger.valueOf(11000L).multiply(BigInteger.valueOf(10L).pow(18));
        }
        throw new IllegalStateException("Unkown DeedId : " + String.valueOf(deedId));
    }

    protected BigInteger computeFixedRewardIndex(TestUEM.HubReport report, HubReportReward reportReward, HubReportDeed reportDeed) {
        BigInteger achievementsCount = report.achievementsCount;
        BigInteger participantsCount = report.participantsCount;
        BigInteger hubRewardAmount = report.amount;
        BigInteger lastRewardedAmount = reportReward.lastRewardedAmount;
        if (lastRewardedAmount.longValue() == 0L) {
            hubRewardAmount = BigInteger.ONE;
            lastRewardedAmount = BigInteger.ONE;
        }
        BigInteger recipientsCount = report.recipientsCount.min(reportDeed.maxUsers);
        BigInteger usersCount = report.usersCount;
        BigInteger mintingPower = reportDeed.mintingPower;
        return BigDecimal.valueOf(10L).pow(18).multiply(new BigDecimal(achievementsCount)).multiply(new BigDecimal(hubRewardAmount)).multiply(new BigDecimal(recipientsCount)).multiply(new BigDecimal(mintingPower)).divide(BigDecimal.valueOf(100L)).divide(new BigDecimal(participantsCount), MathContext.DECIMAL128).divide(new BigDecimal(lastRewardedAmount), MathContext.DECIMAL128).divide(new BigDecimal(usersCount), MathContext.DECIMAL128).setScale(0, RoundingMode.DOWN).toBigInteger();
    }

    protected BigInteger claimAndCheck(Credentials recipientCredentials, String targetReceiver, BigInteger amount, BigInteger expectedClaimedAmount, BigInteger expectedTotalClaimedAmount, BigInteger expectedAccumulatedRewards, int expectedIndex, int recipientReportsCount, BigInteger lastReportId) throws Exception {
        String recipient = recipientCredentials.getAddress();
        String receiver = targetReceiver;
        if (StringUtils.isBlank((CharSequence)targetReceiver) || StringUtils.equals((CharSequence)targetReceiver, (CharSequence)"0x0000000000000000000000000000000000000000")) {
            receiver = recipient;
        }
        BigInteger initialBalance = (BigInteger)this.meed.balanceOf(receiver).send();
        TransactionReceipt receipt = (TransactionReceipt)this.loadUem(recipientCredentials).claim(targetReceiver, amount).send();
        List claimedEvents = TestUEM.getClaimedEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)claimedEvents);
        Assertions.assertEquals((int)1, (int)claimedEvents.size());
        TestUEM.ClaimedEventResponse claimedEvent = (TestUEM.ClaimedEventResponse)claimedEvents.get(0);
        Assertions.assertEquals((Object)receiver.replace("0x", "").toLowerCase(), (Object)claimedEvent.receiver.replace("0x", "").toLowerCase());
        Assertions.assertEquals((Object)recipient.replace("0x", "").toLowerCase(), (Object)claimedEvent.recipient.replace("0x", "").toLowerCase());
        Assertions.assertEquals((Object)expectedClaimedAmount, (Object)claimedEvent.amount);
        Assertions.assertEquals((Object)initialBalance.add(claimedEvent.amount), (Object)this.meed.balanceOf(receiver).send());
        Recipient newRecipientProps = this.getRecipient(recipient);
        Assertions.assertEquals((Object)expectedTotalClaimedAmount, (Object)newRecipientProps.claimedRewards);
        Assertions.assertEquals((Object)expectedAccumulatedRewards, (Object)newRecipientProps.accRewards);
        Assertions.assertEquals((int)expectedIndex, (int)newRecipientProps.index.intValue());
        List<BigInteger> recipientReportIds = this.getRecipientReportIds(recipient);
        Assertions.assertEquals((int)recipientReportsCount, (int)recipientReportIds.size());
        if (!lastReportId.equals(BigInteger.ZERO)) {
            Assertions.assertEquals((Object)lastReportId, (Object)recipientReportIds.get(recipientReportIds.size() - 1));
        }
        BigInteger pendingReward = (BigInteger)this.uem.pendingRewardBalanceOf(recipient).send();
        Assertions.assertEquals((Object)newRecipientProps.accRewards.subtract(newRecipientProps.claimedRewards), (Object)pendingReward);
        return claimedEvent.amount;
    }

    protected BigInteger computeRewardByReportAndRecipientType(BigInteger reportId, boolean owner) throws Exception {
        RewardPeriod reward = this.getRewardPeriodByReportId(reportId);
        HubReportReward reportReward = this.getHubReportRewardById(reportId);
        return new BigDecimal(reward.amount).multiply(new BigDecimal(owner ? reportReward.ownerFixedIndex : reportReward.tenantFixedIndex)).divide(new BigDecimal(reward.fixedGlobalIndex), MathContext.DECIMAL128).setScale(0, RoundingMode.DOWN).toBigInteger();
    }

    protected void checkPreviouslyRewardedAmount(BigInteger ownerEarnings, BigInteger reportId1, BigInteger deedId, boolean owner) throws Exception {
        BigInteger previouslyRewardedAmount = ownerEarnings.multiply(BigInteger.valueOf(100L)).divide(owner ? this.ownerPercentage(deedId) : BigInteger.valueOf(100L).subtract(this.ownerPercentage(deedId)));
        this.checkPreviouslyRewardedAmount(reportId1, previouslyRewardedAmount);
    }

    protected void checkPreviouslyRewardedAmount(BigInteger reportId, BigInteger previousAmount) throws Exception {
        HubReportReward reportReward1 = this.getHubReportRewardById(reportId);
        Assertions.assertEquals((Object)previousAmount.divide(BigInteger.valueOf(100L)), (Object)reportReward1.lastRewardedAmount.divide(BigInteger.valueOf(100L)), (String)"The new generated reports should have used the last perceived rewards in UEM Rewards computation of current week");
        TestUEM.HubReport hubReport1 = this.getHubReportById(reportId);
        HubReportDeed hubDeed1 = this.getHubReportDeedById(reportId);
        BigInteger fixedRewardIndex = this.computeFixedRewardIndex(hubReport1, reportReward1, hubDeed1);
        Assertions.assertEquals((Object)fixedRewardIndex, (Object)reportReward1.fixedRewardIndex, (String)"Second report sent compuation is wrong");
    }

    public static class HubReportReward {
        BigInteger rewardPeriodId;
        String owner;
        String tenant;
        BigInteger fixedRewardIndex;
        BigInteger ownerFixedIndex;
        BigInteger tenantFixedIndex;
        BigInteger sentDate;
        boolean fraud;
        BigInteger lastRewardedAmount;

        @Generated
        public HubReportReward() {
        }

        @Generated
        public HubReportReward(BigInteger rewardPeriodId, String owner, String tenant, BigInteger fixedRewardIndex, BigInteger ownerFixedIndex, BigInteger tenantFixedIndex, BigInteger sentDate, boolean fraud, BigInteger lastRewardedAmount) {
            this.rewardPeriodId = rewardPeriodId;
            this.owner = owner;
            this.tenant = tenant;
            this.fixedRewardIndex = fixedRewardIndex;
            this.ownerFixedIndex = ownerFixedIndex;
            this.tenantFixedIndex = tenantFixedIndex;
            this.sentDate = sentDate;
            this.fraud = fraud;
            this.lastRewardedAmount = lastRewardedAmount;
        }

        @Generated
        public BigInteger getRewardPeriodId() {
            return this.rewardPeriodId;
        }

        @Generated
        public String getOwner() {
            return this.owner;
        }

        @Generated
        public String getTenant() {
            return this.tenant;
        }

        @Generated
        public BigInteger getFixedRewardIndex() {
            return this.fixedRewardIndex;
        }

        @Generated
        public BigInteger getOwnerFixedIndex() {
            return this.ownerFixedIndex;
        }

        @Generated
        public BigInteger getTenantFixedIndex() {
            return this.tenantFixedIndex;
        }

        @Generated
        public BigInteger getSentDate() {
            return this.sentDate;
        }

        @Generated
        public boolean isFraud() {
            return this.fraud;
        }

        @Generated
        public BigInteger getLastRewardedAmount() {
            return this.lastRewardedAmount;
        }

        @Generated
        public void setRewardPeriodId(BigInteger rewardPeriodId) {
            this.rewardPeriodId = rewardPeriodId;
        }

        @Generated
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @Generated
        public void setTenant(String tenant) {
            this.tenant = tenant;
        }

        @Generated
        public void setFixedRewardIndex(BigInteger fixedRewardIndex) {
            this.fixedRewardIndex = fixedRewardIndex;
        }

        @Generated
        public void setOwnerFixedIndex(BigInteger ownerFixedIndex) {
            this.ownerFixedIndex = ownerFixedIndex;
        }

        @Generated
        public void setTenantFixedIndex(BigInteger tenantFixedIndex) {
            this.tenantFixedIndex = tenantFixedIndex;
        }

        @Generated
        public void setSentDate(BigInteger sentDate) {
            this.sentDate = sentDate;
        }

        @Generated
        public void setFraud(boolean fraud) {
            this.fraud = fraud;
        }

        @Generated
        public void setLastRewardedAmount(BigInteger lastRewardedAmount) {
            this.lastRewardedAmount = lastRewardedAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HubReportReward)) {
                return false;
            }
            HubReportReward other = (HubReportReward)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isFraud() != other.isFraud()) {
                return false;
            }
            BigInteger this$rewardPeriodId = this.getRewardPeriodId();
            BigInteger other$rewardPeriodId = other.getRewardPeriodId();
            if (this$rewardPeriodId == null ? other$rewardPeriodId != null : !((Object)this$rewardPeriodId).equals(other$rewardPeriodId)) {
                return false;
            }
            String this$owner = this.getOwner();
            String other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
                return false;
            }
            String this$tenant = this.getTenant();
            String other$tenant = other.getTenant();
            if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
                return false;
            }
            BigInteger this$fixedRewardIndex = this.getFixedRewardIndex();
            BigInteger other$fixedRewardIndex = other.getFixedRewardIndex();
            if (this$fixedRewardIndex == null ? other$fixedRewardIndex != null : !((Object)this$fixedRewardIndex).equals(other$fixedRewardIndex)) {
                return false;
            }
            BigInteger this$ownerFixedIndex = this.getOwnerFixedIndex();
            BigInteger other$ownerFixedIndex = other.getOwnerFixedIndex();
            if (this$ownerFixedIndex == null ? other$ownerFixedIndex != null : !((Object)this$ownerFixedIndex).equals(other$ownerFixedIndex)) {
                return false;
            }
            BigInteger this$tenantFixedIndex = this.getTenantFixedIndex();
            BigInteger other$tenantFixedIndex = other.getTenantFixedIndex();
            if (this$tenantFixedIndex == null ? other$tenantFixedIndex != null : !((Object)this$tenantFixedIndex).equals(other$tenantFixedIndex)) {
                return false;
            }
            BigInteger this$sentDate = this.getSentDate();
            BigInteger other$sentDate = other.getSentDate();
            if (this$sentDate == null ? other$sentDate != null : !((Object)this$sentDate).equals(other$sentDate)) {
                return false;
            }
            BigInteger this$lastRewardedAmount = this.getLastRewardedAmount();
            BigInteger other$lastRewardedAmount = other.getLastRewardedAmount();
            return !(this$lastRewardedAmount == null ? other$lastRewardedAmount != null : !((Object)this$lastRewardedAmount).equals(other$lastRewardedAmount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HubReportReward;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFraud() ? 79 : 97);
            BigInteger $rewardPeriodId = this.getRewardPeriodId();
            result = result * 59 + ($rewardPeriodId == null ? 43 : ((Object)$rewardPeriodId).hashCode());
            String $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
            String $tenant = this.getTenant();
            result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
            BigInteger $fixedRewardIndex = this.getFixedRewardIndex();
            result = result * 59 + ($fixedRewardIndex == null ? 43 : ((Object)$fixedRewardIndex).hashCode());
            BigInteger $ownerFixedIndex = this.getOwnerFixedIndex();
            result = result * 59 + ($ownerFixedIndex == null ? 43 : ((Object)$ownerFixedIndex).hashCode());
            BigInteger $tenantFixedIndex = this.getTenantFixedIndex();
            result = result * 59 + ($tenantFixedIndex == null ? 43 : ((Object)$tenantFixedIndex).hashCode());
            BigInteger $sentDate = this.getSentDate();
            result = result * 59 + ($sentDate == null ? 43 : ((Object)$sentDate).hashCode());
            BigInteger $lastRewardedAmount = this.getLastRewardedAmount();
            result = result * 59 + ($lastRewardedAmount == null ? 43 : ((Object)$lastRewardedAmount).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BaseUEMContractTest.HubReportReward(rewardPeriodId=" + String.valueOf(this.getRewardPeriodId()) + ", owner=" + this.getOwner() + ", tenant=" + this.getTenant() + ", fixedRewardIndex=" + String.valueOf(this.getFixedRewardIndex()) + ", ownerFixedIndex=" + String.valueOf(this.getOwnerFixedIndex()) + ", tenantFixedIndex=" + String.valueOf(this.getTenantFixedIndex()) + ", sentDate=" + String.valueOf(this.getSentDate()) + ", fraud=" + this.isFraud() + ", lastRewardedAmount=" + String.valueOf(this.getLastRewardedAmount()) + ")";
        }
    }

    public static class RewardPeriod {
        BigInteger amount;
        BigInteger reportsCount;
        BigInteger fromReport;
        BigInteger toReport;
        BigInteger fixedGlobalIndex;
        BigInteger fromDate;
        BigInteger toDate;

        @Generated
        public RewardPeriod() {
        }

        @Generated
        public RewardPeriod(BigInteger amount, BigInteger reportsCount, BigInteger fromReport, BigInteger toReport, BigInteger fixedGlobalIndex, BigInteger fromDate, BigInteger toDate) {
            this.amount = amount;
            this.reportsCount = reportsCount;
            this.fromReport = fromReport;
            this.toReport = toReport;
            this.fixedGlobalIndex = fixedGlobalIndex;
            this.fromDate = fromDate;
            this.toDate = toDate;
        }

        @Generated
        public BigInteger getAmount() {
            return this.amount;
        }

        @Generated
        public BigInteger getReportsCount() {
            return this.reportsCount;
        }

        @Generated
        public BigInteger getFromReport() {
            return this.fromReport;
        }

        @Generated
        public BigInteger getToReport() {
            return this.toReport;
        }

        @Generated
        public BigInteger getFixedGlobalIndex() {
            return this.fixedGlobalIndex;
        }

        @Generated
        public BigInteger getFromDate() {
            return this.fromDate;
        }

        @Generated
        public BigInteger getToDate() {
            return this.toDate;
        }

        @Generated
        public void setAmount(BigInteger amount) {
            this.amount = amount;
        }

        @Generated
        public void setReportsCount(BigInteger reportsCount) {
            this.reportsCount = reportsCount;
        }

        @Generated
        public void setFromReport(BigInteger fromReport) {
            this.fromReport = fromReport;
        }

        @Generated
        public void setToReport(BigInteger toReport) {
            this.toReport = toReport;
        }

        @Generated
        public void setFixedGlobalIndex(BigInteger fixedGlobalIndex) {
            this.fixedGlobalIndex = fixedGlobalIndex;
        }

        @Generated
        public void setFromDate(BigInteger fromDate) {
            this.fromDate = fromDate;
        }

        @Generated
        public void setToDate(BigInteger toDate) {
            this.toDate = toDate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RewardPeriod)) {
                return false;
            }
            RewardPeriod other = (RewardPeriod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$amount = this.getAmount();
            BigInteger other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            BigInteger this$reportsCount = this.getReportsCount();
            BigInteger other$reportsCount = other.getReportsCount();
            if (this$reportsCount == null ? other$reportsCount != null : !((Object)this$reportsCount).equals(other$reportsCount)) {
                return false;
            }
            BigInteger this$fromReport = this.getFromReport();
            BigInteger other$fromReport = other.getFromReport();
            if (this$fromReport == null ? other$fromReport != null : !((Object)this$fromReport).equals(other$fromReport)) {
                return false;
            }
            BigInteger this$toReport = this.getToReport();
            BigInteger other$toReport = other.getToReport();
            if (this$toReport == null ? other$toReport != null : !((Object)this$toReport).equals(other$toReport)) {
                return false;
            }
            BigInteger this$fixedGlobalIndex = this.getFixedGlobalIndex();
            BigInteger other$fixedGlobalIndex = other.getFixedGlobalIndex();
            if (this$fixedGlobalIndex == null ? other$fixedGlobalIndex != null : !((Object)this$fixedGlobalIndex).equals(other$fixedGlobalIndex)) {
                return false;
            }
            BigInteger this$fromDate = this.getFromDate();
            BigInteger other$fromDate = other.getFromDate();
            if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
                return false;
            }
            BigInteger this$toDate = this.getToDate();
            BigInteger other$toDate = other.getToDate();
            return !(this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RewardPeriod;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            BigInteger $reportsCount = this.getReportsCount();
            result = result * 59 + ($reportsCount == null ? 43 : ((Object)$reportsCount).hashCode());
            BigInteger $fromReport = this.getFromReport();
            result = result * 59 + ($fromReport == null ? 43 : ((Object)$fromReport).hashCode());
            BigInteger $toReport = this.getToReport();
            result = result * 59 + ($toReport == null ? 43 : ((Object)$toReport).hashCode());
            BigInteger $fixedGlobalIndex = this.getFixedGlobalIndex();
            result = result * 59 + ($fixedGlobalIndex == null ? 43 : ((Object)$fixedGlobalIndex).hashCode());
            BigInteger $fromDate = this.getFromDate();
            result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
            BigInteger $toDate = this.getToDate();
            result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BaseUEMContractTest.RewardPeriod(amount=" + String.valueOf(this.getAmount()) + ", reportsCount=" + String.valueOf(this.getReportsCount()) + ", fromReport=" + String.valueOf(this.getFromReport()) + ", toReport=" + String.valueOf(this.getToReport()) + ", fixedGlobalIndex=" + String.valueOf(this.getFixedGlobalIndex()) + ", fromDate=" + String.valueOf(this.getFromDate()) + ", toDate=" + String.valueOf(this.getToDate()) + ")";
        }
    }

    public static class HubReportDeed {
        BigInteger deedId;
        BigInteger city;
        BigInteger cardType;
        BigInteger mintingPower;
        BigInteger maxUsers;

        @Generated
        public HubReportDeed() {
        }

        @Generated
        public HubReportDeed(BigInteger deedId, BigInteger city, BigInteger cardType, BigInteger mintingPower, BigInteger maxUsers) {
            this.deedId = deedId;
            this.city = city;
            this.cardType = cardType;
            this.mintingPower = mintingPower;
            this.maxUsers = maxUsers;
        }

        @Generated
        public BigInteger getDeedId() {
            return this.deedId;
        }

        @Generated
        public BigInteger getCity() {
            return this.city;
        }

        @Generated
        public BigInteger getCardType() {
            return this.cardType;
        }

        @Generated
        public BigInteger getMintingPower() {
            return this.mintingPower;
        }

        @Generated
        public BigInteger getMaxUsers() {
            return this.maxUsers;
        }

        @Generated
        public void setDeedId(BigInteger deedId) {
            this.deedId = deedId;
        }

        @Generated
        public void setCity(BigInteger city) {
            this.city = city;
        }

        @Generated
        public void setCardType(BigInteger cardType) {
            this.cardType = cardType;
        }

        @Generated
        public void setMintingPower(BigInteger mintingPower) {
            this.mintingPower = mintingPower;
        }

        @Generated
        public void setMaxUsers(BigInteger maxUsers) {
            this.maxUsers = maxUsers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HubReportDeed)) {
                return false;
            }
            HubReportDeed other = (HubReportDeed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$deedId = this.getDeedId();
            BigInteger other$deedId = other.getDeedId();
            if (this$deedId == null ? other$deedId != null : !((Object)this$deedId).equals(other$deedId)) {
                return false;
            }
            BigInteger this$city = this.getCity();
            BigInteger other$city = other.getCity();
            if (this$city == null ? other$city != null : !((Object)this$city).equals(other$city)) {
                return false;
            }
            BigInteger this$cardType = this.getCardType();
            BigInteger other$cardType = other.getCardType();
            if (this$cardType == null ? other$cardType != null : !((Object)this$cardType).equals(other$cardType)) {
                return false;
            }
            BigInteger this$mintingPower = this.getMintingPower();
            BigInteger other$mintingPower = other.getMintingPower();
            if (this$mintingPower == null ? other$mintingPower != null : !((Object)this$mintingPower).equals(other$mintingPower)) {
                return false;
            }
            BigInteger this$maxUsers = this.getMaxUsers();
            BigInteger other$maxUsers = other.getMaxUsers();
            return !(this$maxUsers == null ? other$maxUsers != null : !((Object)this$maxUsers).equals(other$maxUsers));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HubReportDeed;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $deedId = this.getDeedId();
            result = result * 59 + ($deedId == null ? 43 : ((Object)$deedId).hashCode());
            BigInteger $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : ((Object)$city).hashCode());
            BigInteger $cardType = this.getCardType();
            result = result * 59 + ($cardType == null ? 43 : ((Object)$cardType).hashCode());
            BigInteger $mintingPower = this.getMintingPower();
            result = result * 59 + ($mintingPower == null ? 43 : ((Object)$mintingPower).hashCode());
            BigInteger $maxUsers = this.getMaxUsers();
            result = result * 59 + ($maxUsers == null ? 43 : ((Object)$maxUsers).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BaseUEMContractTest.HubReportDeed(deedId=" + String.valueOf(this.getDeedId()) + ", city=" + String.valueOf(this.getCity()) + ", cardType=" + String.valueOf(this.getCardType()) + ", mintingPower=" + String.valueOf(this.getMintingPower()) + ", maxUsers=" + String.valueOf(this.getMaxUsers()) + ")";
        }
    }

    public static class Recipient {
        BigInteger claimedRewards;
        BigInteger accRewards;
        BigInteger index;

        @Generated
        public Recipient() {
        }

        @Generated
        public Recipient(BigInteger claimedRewards, BigInteger accRewards, BigInteger index) {
            this.claimedRewards = claimedRewards;
            this.accRewards = accRewards;
            this.index = index;
        }

        @Generated
        public BigInteger getClaimedRewards() {
            return this.claimedRewards;
        }

        @Generated
        public BigInteger getAccRewards() {
            return this.accRewards;
        }

        @Generated
        public BigInteger getIndex() {
            return this.index;
        }

        @Generated
        public void setClaimedRewards(BigInteger claimedRewards) {
            this.claimedRewards = claimedRewards;
        }

        @Generated
        public void setAccRewards(BigInteger accRewards) {
            this.accRewards = accRewards;
        }

        @Generated
        public void setIndex(BigInteger index) {
            this.index = index;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Recipient)) {
                return false;
            }
            Recipient other = (Recipient)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$claimedRewards = this.getClaimedRewards();
            BigInteger other$claimedRewards = other.getClaimedRewards();
            if (this$claimedRewards == null ? other$claimedRewards != null : !((Object)this$claimedRewards).equals(other$claimedRewards)) {
                return false;
            }
            BigInteger this$accRewards = this.getAccRewards();
            BigInteger other$accRewards = other.getAccRewards();
            if (this$accRewards == null ? other$accRewards != null : !((Object)this$accRewards).equals(other$accRewards)) {
                return false;
            }
            BigInteger this$index = this.getIndex();
            BigInteger other$index = other.getIndex();
            return !(this$index == null ? other$index != null : !((Object)this$index).equals(other$index));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Recipient;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $claimedRewards = this.getClaimedRewards();
            result = result * 59 + ($claimedRewards == null ? 43 : ((Object)$claimedRewards).hashCode());
            BigInteger $accRewards = this.getAccRewards();
            result = result * 59 + ($accRewards == null ? 43 : ((Object)$accRewards).hashCode());
            BigInteger $index = this.getIndex();
            result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BaseUEMContractTest.Recipient(claimedRewards=" + String.valueOf(this.getClaimedRewards()) + ", accRewards=" + String.valueOf(this.getAccRewards()) + ", index=" + String.valueOf(this.getIndex()) + ")";
        }
    }
}

