/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.meeds.deeds.contract.BaseWoMContractTest;
import io.meeds.deeds.contract.WoM;
import java.math.BigInteger;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.web3j.EVMTest;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

@EVMTest
public class WoMTest
extends BaseWoMContractTest {
    @Override
    @BeforeEach
    public void init(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) throws Exception {
        super.init(web3j, transactionManager, contractGasProvider);
    }

    @Test
    public void updateDeed() throws Exception {
        Assertions.assertThrows(Exception.class, () -> this.bridgeDeed(BigInteger.ZERO, OWNER1, TENANT1), (String)"Deed Id is mandatory");
        Assertions.assertThrows(Exception.class, () -> this.bridgeDeed(DEED1, "0x0000000000000000000000000000000000000000", TENANT1), (String)"Deed Owner is mandatory");
        Assertions.assertThrows(Exception.class, () -> this.bridgeDeed(DEED1, OWNER1, "0x0000000000000000000000000000000000000000"), (String)"Deed Tenant is mandatory");
        TransactionReceipt receipt = this.bridgeDeed(DEED1, OWNER1, TENANT1);
        this.checkReceipt(receipt);
        this.checkDeedUpdatedEvent(receipt, DEED1);
        this.checkDeedProperties(DEED1, "0x0000000000000000000000000000000000000000", OWNER1, TENANT1);
        Assertions.assertFalse((boolean)((Boolean)this.wom.isDeedConnected(DEED1).send()));
    }

    @Test
    public void autoConnect() throws Exception {
        this.sendGasFees();
        long txTimeStart = this.now();
        TransactionReceipt receipt = this.bridgeDeedAndAutoConnect(DEED1, HUB1, OWNER1, TENANT1);
        long txTimeEnd = this.now();
        this.checkReceipt(receipt);
        this.checkDeedUpdatedEvent(receipt, DEED1);
        this.checkHubConnectedEvent(receipt, DEED1, HUB1, TENANT1);
        this.checkDeedProperties(DEED1, HUB1, OWNER1, TENANT1);
        this.checkHubConnected(DEED1, HUB1);
        this.checkHubJoinDate(HUB1, txTimeStart, txTimeEnd);
        this.checkHubProperties(HUB1, TENANT1, DEED1);
        receipt = this.bridgeDeedAndAutoConnect(DEED1, HUB1, OWNER1, TENANT2);
        this.checkReceipt(receipt);
        this.checkDeedUpdatedEvent(receipt, DEED1);
        List hubConnectedEvents = WoM.getHubConnectedEvents((TransactionReceipt)receipt);
        Assertions.assertNotNull((Object)hubConnectedEvents);
        Assertions.assertEquals((int)0, (int)hubConnectedEvents.size(), (String)"Shouldn't connect automatically the Hub to the new Tenant since the old Tenant holds Hub ownership");
        Assertions.assertFalse((boolean)((Boolean)this.wom.isHubConnected(HUB1).send()), (String)"Should automatically disconnect the Hub when the new Deed Tenant isn't owner neither Tenant of the Deed");
        Assertions.assertEquals((Object)"0x0000000000000000000000000000000000000000".toLowerCase().replace("0x", ""), (Object)((String)this.wom.getConnectedHub(DEED1).send()).toLowerCase().replace("0x", ""), (String)"Must return 0x address. Should automatically disconnect the Hub when the new Deed Tenant isn't owner neither Tenant of the Deed");
        Assertions.assertFalse((boolean)((Boolean)this.wom.isDeedConnected(DEED1).send()), (String)"Should automatically disconnect the Deed when the new Deed Tenant isn't owner neither Tenant of the Deed");
        Assertions.assertEquals((Object)BigInteger.ZERO, (Object)this.wom.getConnectedDeed(HUB1).send(), (String)"Must return 0 Deed Id. Should automatically disconnect the Deed when the new Deed Tenant isn't owner neither Tenant of the Deed");
        this.checkDeedProperties(DEED1, HUB1, OWNER1, TENANT2);
        this.checkHubProperties(HUB1, TENANT1, DEED1);
        this.checkHubJoinDate(HUB1, txTimeStart, txTimeEnd);
        receipt = this.transferHubOwnership(TENANT1_CREDENTIALS, HUB1, TENANT2);
        this.checkReceipt(receipt);
        this.checkHubOwnershipTransferEvent(receipt, TENANT1, TENANT2);
        this.checkHubProperties(HUB1, TENANT2, DEED1);
        this.checkHubConnected(DEED1, HUB1);
        long txTime2Start = this.now();
        receipt = this.bridgeDeedAndAutoConnect(DEED1, HUB2, OWNER1, TENANT2);
        long txTime2End = this.now();
        this.checkReceipt(receipt);
        this.checkDeedUpdatedEvent(receipt, DEED1);
        this.checkHubDisconnectedEvent(receipt, DEED1, HUB1);
        this.checkHubConnectedEvent(receipt, DEED1, HUB2, TENANT2);
        this.checkDeedProperties(DEED1, HUB2, OWNER1, TENANT2);
        this.checkHubConnected(DEED1, HUB2);
        this.checkHubJoinDate(HUB2, txTime2Start, txTime2End);
        this.checkHubProperties(HUB2, TENANT2, DEED1);
        Assertions.assertFalse((boolean)((Boolean)this.wom.isHubConnected(HUB1).send()), (String)"Hub 1 should be disconnected automatically");
        receipt = this.bridgeDeed(DEED1, OWNER2, TENANT2);
        this.checkReceipt(receipt);
        this.checkDeedUpdatedEvent(receipt, DEED1);
        this.checkNoHubDisconnectedEvent(receipt);
        this.checkNoHubConnectedEvent(receipt);
        this.checkDeedProperties(DEED1, HUB2, OWNER2, TENANT2);
        this.checkHubConnected(DEED1, HUB2);
        this.checkHubJoinDate(HUB2, txTime2Start, txTime2End);
        this.checkHubProperties(HUB2, TENANT2, DEED1);
    }

    @Test
    public void transferHubOwnership() throws Exception {
        this.sendGasFees();
        this.bridgeDeed(DEED1, OWNER1, TENANT1);
        this.checkDeedProperties(DEED1, OWNER1, TENANT1);
        this.connectHub(TENANT1_CREDENTIALS, HUB1, DEED1);
        this.checkHubConnected(DEED1, HUB1);
        this.checkHubProperties(HUB1, TENANT1, DEED1);
        this.disconnectHub(TENANT1_CREDENTIALS, HUB1);
        this.checkHubDisconnected(DEED1, HUB1);
        this.bridgeDeed(DEED1, OWNER1, TENANT2);
        this.checkHubProperties(HUB1, TENANT1, DEED1, false);
        Assertions.assertThrows(Exception.class, () -> this.transferHubOwnership(TENANT2_CREDENTIALS, HUB1, TENANT2), (String)"Only Hub Owner must be allowed. The new Deed Tenant doesn't hold Hub ownership");
        Assertions.assertThrows(Exception.class, () -> this.transferHubOwnership(OWNER1_CREDENTIALS, HUB1, TENANT2), (String)"Only Hub Owner must be allowed. The Deed Owner doesn't hold Hub ownership");
        WoM womTenant1 = WoM.load((String)this.wom.getContractAddress(), (Web3j)this.web3j, (Credentials)TENANT1_CREDENTIALS, (ContractGasProvider)this.contractGasProvider);
        Assertions.assertThrows(Exception.class, () -> womTenant1.transferHubOwnership("0x0000000000000000000000000000000000000000", TENANT2).send(), (String)"Hub Address is mandatory");
        Assertions.assertThrows(Exception.class, () -> womTenant1.transferHubOwnership(HUB1, "0x0000000000000000000000000000000000000000").send(), (String)"New Owner Address is mandatory");
        Assertions.assertThrows(Exception.class, () -> womTenant1.transferHubOwnership(HUB1, TENANT1).send(), (String)"Can't transfer to the same owner");
        TransactionReceipt receipt = this.transferHubOwnership(TENANT1_CREDENTIALS, HUB1, TENANT2);
        this.checkReceipt(receipt);
        this.checkHubOwnershipTransferEvent(receipt, TENANT1, TENANT2);
        this.checkHubProperties(HUB1, TENANT2, DEED1, false);
        Assertions.assertThrows(Exception.class, () -> womTenant1.transferHubOwnership(HUB1, TENANT1).send(), (String)"TENANT1 shouldn't be allowed to redo the transfer again");
        receipt = this.transferHubOwnership(TENANT2_CREDENTIALS, HUB1, OWNER1);
        this.checkReceipt(receipt);
        this.checkHubOwnershipTransferEvent(receipt, TENANT2, OWNER1);
        this.checkHubProperties(HUB1, OWNER1, DEED1, false);
    }

    @Test
    public void connect() throws Exception {
        this.sendGasFees();
        this.bridgeDeed(DEED1, OWNER1, TENANT1);
        this.checkDeedProperties(DEED1, OWNER1, TENANT1);
        Assertions.assertThrows(Exception.class, () -> this.connectHub(OWNER1_CREDENTIALS, HUB1, DEED1), (String)"Deed Owner 1 shouldn't be able to manage Hub connection while lease is in progress for another Deed Tenant");
        TransactionReceipt receipt = this.connectHub(TENANT1_CREDENTIALS, HUB1, DEED1);
        this.checkHubConnectedEvent(receipt, DEED1, HUB1, TENANT1);
        this.checkHubProperties(HUB1, TENANT1, DEED1);
        this.bridgeDeed(DEED2, OWNER2, TENANT2);
        this.checkDeedProperties(DEED2, OWNER2, TENANT2);
        Assertions.assertThrows(Exception.class, () -> this.connectHub(OWNER2_CREDENTIALS, HUB2, DEED2), (String)"Deed Owner 2 shouldn't be able to manage Hub connection while lease is in progress for another Deed Tenant");
        receipt = this.connectHub(TENANT2_CREDENTIALS, HUB2, DEED2);
        this.checkHubConnectedEvent(receipt, DEED2, HUB2, TENANT2);
        this.checkHubProperties(HUB2, TENANT2, DEED2);
        this.checkHubConnected(DEED2, HUB2);
        this.bridgeDeed(DEED2, OWNER1, TENANT2);
        this.checkHubProperties(HUB2, TENANT2, DEED2);
        this.checkHubConnected(DEED2, HUB2);
        this.bridgeDeed(DEED2, OWNER1, TENANT1);
        this.checkHubProperties(HUB2, TENANT2, DEED2);
        this.checkHubDisconnected(DEED2, HUB2);
        this.transferHubOwnership(TENANT2_CREDENTIALS, HUB2, TENANT1);
        this.checkHubConnected(DEED2, HUB2);
        this.checkHubProperties(HUB2, TENANT1, DEED2);
    }

    @Test
    public void disconnect() throws Exception {
        this.sendGasFees();
        this.bridgeDeed(DEED1, OWNER1, TENANT1);
        this.checkDeedProperties(DEED1, OWNER1, TENANT1);
        this.connectHub(TENANT1_CREDENTIALS, HUB1, DEED1);
        this.checkHubProperties(HUB1, TENANT1, DEED1);
        Assertions.assertThrows(Exception.class, () -> this.disconnectHub(OWNER1_CREDENTIALS, HUB1), (String)"Deed Owner 1 shouldn't be able to disconnect Hub while lease is in progress for another Deed Tenant");
        this.checkHubConnected(DEED1, HUB1);
        TransactionReceipt receipt = this.disconnectHub(TENANT1_CREDENTIALS, HUB1);
        this.checkHubDisconnectedEvent(receipt, DEED1, HUB1);
        this.checkHubDisconnected(DEED1, HUB1);
        this.bridgeDeed(DEED2, OWNER2, TENANT2);
        this.checkDeedProperties(DEED2, OWNER2, TENANT2);
        this.connectHub(TENANT2_CREDENTIALS, HUB2, DEED2);
        Assertions.assertThrows(Exception.class, () -> this.disconnectHub(OWNER2_CREDENTIALS, HUB2), (String)"Deed Owner 2 shouldn't be able to disconnect Hub while lease is in progress for another Deed Tenant");
        this.checkHubProperties(HUB2, TENANT2, DEED2);
        this.checkHubConnected(DEED2, HUB2);
        this.bridgeDeed(DEED2, OWNER2, TENANT1);
        Assertions.assertThrows(Exception.class, () -> this.disconnectHub(TENANT1_CREDENTIALS, HUB2), (String)"New Deed Tenant TENANT1 shouldn't be able to disconnect Hub while it's owned by TENANT2");
        this.disconnectHub(TENANT2_CREDENTIALS, HUB2);
        this.transferHubOwnership(TENANT2_CREDENTIALS, HUB2, TENANT1);
        this.connectHub(TENANT1_CREDENTIALS, HUB2, DEED2);
        this.checkHubConnected(DEED2, HUB2);
        this.checkHubProperties(HUB2, TENANT1, DEED2);
    }
}

