/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.scheduling.task;

import io.meeds.dapp.service.ExchangeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class MeedsExchangeTask {
    private static final Logger LOG = LoggerFactory.getLogger(MeedsExchangeTask.class);
    @Autowired
    private ExchangeService exchangeService;

    @Scheduled(cron="${meeds.token.exchangeRate.cron:25 9 0/1 * * *}")
    public void computeExchangeRate() {
        LOG.info("Start Computing MEED exchange rates");
        long start = System.currentTimeMillis();
        try {
            this.exchangeService.computeMeedExchangeRate();
            LOG.info("End Computing MEED exchange rates in {}ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            LOG.error("An error occurred while computing Meeds exchange rates", (Throwable)e);
        }
    }
}

