/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint32;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple4;
import org.web3j.tuples.generated.Tuple6;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class XMeedsNFTRewarding
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_ALLOWANCE = "allowance";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_CARDTYPEINFO = "cardTypeInfo";
    public static final String FUNC_CITYINFO = "cityInfo";
    public static final String FUNC_CITYMINTINGSTARTDATE = "cityMintingStartDate";
    public static final String FUNC_CURRENTCITYINDEX = "currentCityIndex";
    public static final String FUNC_DECIMALS = "decimals";
    public static final String FUNC_DECREASEALLOWANCE = "decreaseAllowance";
    public static final String FUNC_EARNED = "earned";
    public static final String FUNC_EXIT = "exit";
    public static final String FUNC_INCREASEALLOWANCE = "increaseAllowance";
    public static final String FUNC_ISCURRENTCITYMINTABLE = "isCurrentCityMintable";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_LASTCITYMINTINGCOMPLETEDATE = "lastCityMintingCompleteDate";
    public static final String FUNC_MEED = "meed";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_NFT = "nft";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_REDEEM = "redeem";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_REWARDDISTRIBUTION = "rewardDistribution";
    public static final String FUNC_SETNFT = "setNFT";
    public static final String FUNC_STAKE = "stake";
    public static final String FUNC_STARTREWARDSTIME = "startRewardsTime";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_TRANSFER = "transfer";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_WITHDRAW = "withdraw";
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event NFTSET_EVENT = new Event("NFTSet", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event REDEEMED_EVENT = new Event("Redeemed", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Utf8String>(){}, new TypeReference<Utf8String>(){}, new TypeReference<Uint256>(){}));
    public static final Event STAKED_EVENT = new Event("Staked", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event WITHDRAWN_EVENT = new Event("Withdrawn", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));

    @Deprecated
    protected XMeedsNFTRewarding(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected XMeedsNFTRewarding(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected XMeedsNFTRewarding(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected XMeedsNFTRewarding(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List valueList = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)APPROVAL_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ApprovalEventResponse getApprovalEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)APPROVAL_EVENT, (Log)log);
        ApprovalEventResponse typedResponse = new ApprovalEventResponse();
        typedResponse.log = log;
        typedResponse.owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> XMeedsNFTRewarding.getApprovalEventFromLog(log));
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVAL_EVENT));
        return this.approvalEventFlowable(filter);
    }

    public static List<NFTSetEventResponse> getNFTSetEvents(TransactionReceipt transactionReceipt) {
        List valueList = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)NFTSET_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<NFTSetEventResponse> responses = new ArrayList<NFTSetEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NFTSetEventResponse typedResponse = new NFTSetEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newNFT = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static NFTSetEventResponse getNFTSetEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)NFTSET_EVENT, (Log)log);
        NFTSetEventResponse typedResponse = new NFTSetEventResponse();
        typedResponse.log = log;
        typedResponse.newNFT = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<NFTSetEventResponse> nFTSetEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> XMeedsNFTRewarding.getNFTSetEventFromLog(log));
    }

    public Flowable<NFTSetEventResponse> nFTSetEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NFTSET_EVENT));
        return this.nFTSetEventFlowable(filter);
    }

    public static List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OwnershipTransferredEventResponse getOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (Log)log);
        OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> XMeedsNFTRewarding.getOwnershipTransferredEventFromLog(log));
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public static List<RedeemedEventResponse> getRedeemedEvents(TransactionReceipt transactionReceipt) {
        List valueList = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)REDEEMED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<RedeemedEventResponse> responses = new ArrayList<RedeemedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RedeemedEventResponse typedResponse = new RedeemedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.city = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.cardType = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.id = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static RedeemedEventResponse getRedeemedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)REDEEMED_EVENT, (Log)log);
        RedeemedEventResponse typedResponse = new RedeemedEventResponse();
        typedResponse.log = log;
        typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.city = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.cardType = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        typedResponse.id = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
        return typedResponse;
    }

    public Flowable<RedeemedEventResponse> redeemedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> XMeedsNFTRewarding.getRedeemedEventFromLog(log));
    }

    public Flowable<RedeemedEventResponse> redeemedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)REDEEMED_EVENT));
        return this.redeemedEventFlowable(filter);
    }

    public static List<StakedEventResponse> getStakedEvents(TransactionReceipt transactionReceipt) {
        List valueList = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)STAKED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<StakedEventResponse> responses = new ArrayList<StakedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            StakedEventResponse typedResponse = new StakedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static StakedEventResponse getStakedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)STAKED_EVENT, (Log)log);
        StakedEventResponse typedResponse = new StakedEventResponse();
        typedResponse.log = log;
        typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<StakedEventResponse> stakedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> XMeedsNFTRewarding.getStakedEventFromLog(log));
    }

    public Flowable<StakedEventResponse> stakedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)STAKED_EVENT));
        return this.stakedEventFlowable(filter);
    }

    public static List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List valueList = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)TRANSFER_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static TransferEventResponse getTransferEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)TRANSFER_EVENT, (Log)log);
        TransferEventResponse typedResponse = new TransferEventResponse();
        typedResponse.log = log;
        typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> XMeedsNFTRewarding.getTransferEventFromLog(log));
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFER_EVENT));
        return this.transferEventFlowable(filter);
    }

    public static List<WithdrawnEventResponse> getWithdrawnEvents(TransactionReceipt transactionReceipt) {
        List valueList = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)WITHDRAWN_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<WithdrawnEventResponse> responses = new ArrayList<WithdrawnEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            WithdrawnEventResponse typedResponse = new WithdrawnEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static WithdrawnEventResponse getWithdrawnEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = XMeedsNFTRewarding.staticExtractEventParametersWithLog((Event)WITHDRAWN_EVENT, (Log)log);
        WithdrawnEventResponse typedResponse = new WithdrawnEventResponse();
        typedResponse.log = log;
        typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<WithdrawnEventResponse> withdrawnEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> XMeedsNFTRewarding.getWithdrawnEventFromLog(log));
    }

    public Flowable<WithdrawnEventResponse> withdrawnEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)WITHDRAWN_EVENT));
        return this.withdrawnEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> allowance(String owner, String spender) {
        Function function = new Function(FUNC_ALLOWANCE, Arrays.asList(new Address(160, owner), new Address(160, spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> approve(String spender, BigInteger amount) {
        Function function = new Function(FUNC_APPROVE, Arrays.asList(new Address(160, spender), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String account) {
        Function function = new Function(FUNC_BALANCEOF, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Tuple6<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>> cardTypeInfo(BigInteger param0) {
        final Function function = new Function(FUNC_CARDTYPEINFO, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Uint8>(){}, new TypeReference<Uint8>(){}, new TypeReference<Uint32>(){}, new TypeReference<Uint32>(){}, new TypeReference<Uint256>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple6<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>>(){

            @Override
            public Tuple6<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger> call() throws Exception {
                List results = XMeedsNFTRewarding.this.executeCallMultipleValueReturn(function);
                return new Tuple6((Object)((String)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((BigInteger)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()), (Object)((BigInteger)((Type)results.get(4)).getValue()), (Object)((BigInteger)((Type)results.get(5)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<Tuple4<String, BigInteger, BigInteger, BigInteger>> cityInfo(BigInteger param0) {
        final Function function = new Function(FUNC_CITYINFO, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Uint32>(){}, new TypeReference<Uint32>(){}, new TypeReference<Uint256>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple4<String, BigInteger, BigInteger, BigInteger>>(){

            @Override
            public Tuple4<String, BigInteger, BigInteger, BigInteger> call() throws Exception {
                List results = XMeedsNFTRewarding.this.executeCallMultipleValueReturn(function);
                return new Tuple4((Object)((String)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((BigInteger)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<BigInteger> cityMintingStartDate() {
        Function function = new Function(FUNC_CITYMINTINGSTARTDATE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> currentCityIndex() {
        Function function = new Function(FUNC_CURRENTCITYINDEX, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> decimals() {
        Function function = new Function(FUNC_DECIMALS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> decreaseAllowance(String spender, BigInteger subtractedValue) {
        Function function = new Function(FUNC_DECREASEALLOWANCE, Arrays.asList(new Address(160, spender), new Uint256(subtractedValue)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> earned(String account) {
        Function function = new Function(FUNC_EARNED, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> exit() {
        Function function = new Function(FUNC_EXIT, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> increaseAllowance(String spender, BigInteger addedValue) {
        Function function = new Function(FUNC_INCREASEALLOWANCE, Arrays.asList(new Address(160, spender), new Uint256(addedValue)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isCurrentCityMintable() {
        Function function = new Function(FUNC_ISCURRENTCITYMINTABLE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        Function function = new Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> lastCityMintingCompleteDate() {
        Function function = new Function(FUNC_LASTCITYMINTINGCOMPLETEDATE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> meed() {
        Function function = new Function(FUNC_MEED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> name() {
        Function function = new Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> nft() {
        Function function = new Function(FUNC_NFT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> owner() {
        Function function = new Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> redeem(BigInteger cardTypeId) {
        Function function = new Function(FUNC_REDEEM, Arrays.asList(new Uint8(cardTypeId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        Function function = new Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> rewardDistribution() {
        Function function = new Function(FUNC_REWARDDISTRIBUTION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> setNFT(String _nftAddress) {
        Function function = new Function(FUNC_SETNFT, Arrays.asList(new Address(160, _nftAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> stake(BigInteger amount) {
        Function function = new Function(FUNC_STAKE, Arrays.asList(new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> startRewardsTime() {
        Function function = new Function(FUNC_STARTREWARDSTIME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> symbol() {
        Function function = new Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply() {
        Function function = new Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transfer(String recipient, BigInteger amount) {
        Function function = new Function(FUNC_TRANSFER, Arrays.asList(new Address(160, recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferFrom(String sender, String recipient, BigInteger amount) {
        Function function = new Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(160, sender), new Address(160, recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        Function function = new Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> withdraw(BigInteger amount) {
        Function function = new Function(FUNC_WITHDRAW, Arrays.asList(new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static XMeedsNFTRewarding load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new XMeedsNFTRewarding(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static XMeedsNFTRewarding load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new XMeedsNFTRewarding(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static XMeedsNFTRewarding load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new XMeedsNFTRewarding(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static XMeedsNFTRewarding load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new XMeedsNFTRewarding(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<XMeedsNFTRewarding> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _meed, String _rewardDistribution, String _nftAddress, BigInteger _startRewardsTime, List<String> _cityNames, List<String> _cardNames, List<BigInteger> _cardPrices, List<BigInteger> _cardSupply) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Address(160, _rewardDistribution), new Address(160, _nftAddress), new Uint256(_startRewardsTime), new DynamicArray(Utf8String.class, Utils.typeMap(_cityNames, Utf8String.class)), new DynamicArray(Utf8String.class, Utils.typeMap(_cardNames, Utf8String.class)), new DynamicArray(Uint256.class, Utils.typeMap(_cardPrices, Uint256.class)), new DynamicArray(Uint32.class, Utils.typeMap(_cardSupply, Uint32.class))));
        return XMeedsNFTRewarding.deployRemoteCall(XMeedsNFTRewarding.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    public static RemoteCall<XMeedsNFTRewarding> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _meed, String _rewardDistribution, String _nftAddress, BigInteger _startRewardsTime, List<String> _cityNames, List<String> _cardNames, List<BigInteger> _cardPrices, List<BigInteger> _cardSupply) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Address(160, _rewardDistribution), new Address(160, _nftAddress), new Uint256(_startRewardsTime), new DynamicArray(Utf8String.class, Utils.typeMap(_cityNames, Utf8String.class)), new DynamicArray(Utf8String.class, Utils.typeMap(_cardNames, Utf8String.class)), new DynamicArray(Uint256.class, Utils.typeMap(_cardPrices, Uint256.class)), new DynamicArray(Uint32.class, Utils.typeMap(_cardSupply, Uint32.class))));
        return XMeedsNFTRewarding.deployRemoteCall(XMeedsNFTRewarding.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<XMeedsNFTRewarding> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _meed, String _rewardDistribution, String _nftAddress, BigInteger _startRewardsTime, List<String> _cityNames, List<String> _cardNames, List<BigInteger> _cardPrices, List<BigInteger> _cardSupply) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Address(160, _rewardDistribution), new Address(160, _nftAddress), new Uint256(_startRewardsTime), new DynamicArray(Utf8String.class, Utils.typeMap(_cityNames, Utf8String.class)), new DynamicArray(Utf8String.class, Utils.typeMap(_cardNames, Utf8String.class)), new DynamicArray(Uint256.class, Utils.typeMap(_cardPrices, Uint256.class)), new DynamicArray(Uint32.class, Utils.typeMap(_cardSupply, Uint32.class))));
        return XMeedsNFTRewarding.deployRemoteCall(XMeedsNFTRewarding.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<XMeedsNFTRewarding> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _meed, String _rewardDistribution, String _nftAddress, BigInteger _startRewardsTime, List<String> _cityNames, List<String> _cardNames, List<BigInteger> _cardPrices, List<BigInteger> _cardSupply) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Address(160, _rewardDistribution), new Address(160, _nftAddress), new Uint256(_startRewardsTime), new DynamicArray(Utf8String.class, Utils.typeMap(_cityNames, Utf8String.class)), new DynamicArray(Utf8String.class, Utils.typeMap(_cardNames, Utf8String.class)), new DynamicArray(Uint256.class, Utils.typeMap(_cardPrices, Uint256.class)), new DynamicArray(Uint32.class, Utils.typeMap(_cardSupply, Uint32.class))));
        return XMeedsNFTRewarding.deployRemoteCall(XMeedsNFTRewarding.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    public static class ApprovalEventResponse
    extends BaseEventResponse {
        public String owner;
        public String spender;
        public BigInteger value;
    }

    public static class NFTSetEventResponse
    extends BaseEventResponse {
        public String newNFT;
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class RedeemedEventResponse
    extends BaseEventResponse {
        public String user;
        public String city;
        public String cardType;
        public BigInteger id;
    }

    public static class StakedEventResponse
    extends BaseEventResponse {
        public String user;
        public BigInteger amount;
    }

    public static class TransferEventResponse
    extends BaseEventResponse {
        public String from;
        public String to;
        public BigInteger value;
    }

    public static class WithdrawnEventResponse
    extends BaseEventResponse {
        public String user;
        public BigInteger amount;
    }
}

