/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class UUPSUpgradeable
extends Contract {
    public static final String BINARY = "";
    public static final String FUNC_PROXIABLEUUID = "proxiableUUID";
    public static final String FUNC_UPGRADETO = "upgradeTo";
    public static final String FUNC_UPGRADETOANDCALL = "upgradeToAndCall";
    public static final Event ADMINCHANGED_EVENT = new Event("AdminChanged", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Address>(){}));
    public static final Event BEACONUPGRADED_EVENT = new Event("BeaconUpgraded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event UPGRADED_EVENT = new Event("Upgraded", Arrays.asList(new TypeReference<Address>(true){}));

    @Deprecated
    protected UUPSUpgradeable(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected UUPSUpgradeable(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected UUPSUpgradeable(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected UUPSUpgradeable(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<AdminChangedEventResponse> getAdminChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UUPSUpgradeable.staticExtractEventParametersWithLog((Event)ADMINCHANGED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<AdminChangedEventResponse> responses = new ArrayList<AdminChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousAdmin = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.newAdmin = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static AdminChangedEventResponse getAdminChangedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UUPSUpgradeable.staticExtractEventParametersWithLog((Event)ADMINCHANGED_EVENT, (Log)log);
        AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
        typedResponse.log = log;
        typedResponse.previousAdmin = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.newAdmin = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UUPSUpgradeable.getAdminChangedEventFromLog(log));
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADMINCHANGED_EVENT));
        return this.adminChangedEventFlowable(filter);
    }

    public static List<BeaconUpgradedEventResponse> getBeaconUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UUPSUpgradeable.staticExtractEventParametersWithLog((Event)BEACONUPGRADED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<BeaconUpgradedEventResponse> responses = new ArrayList<BeaconUpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.beacon = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static BeaconUpgradedEventResponse getBeaconUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UUPSUpgradeable.staticExtractEventParametersWithLog((Event)BEACONUPGRADED_EVENT, (Log)log);
        BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.beacon = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UUPSUpgradeable.getBeaconUpgradedEventFromLog(log));
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)BEACONUPGRADED_EVENT));
        return this.beaconUpgradedEventFlowable(filter);
    }

    public static List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UUPSUpgradeable.staticExtractEventParametersWithLog((Event)UPGRADED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementation = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static UpgradedEventResponse getUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UUPSUpgradeable.staticExtractEventParametersWithLog((Event)UPGRADED_EVENT, (Log)log);
        UpgradedEventResponse typedResponse = new UpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.implementation = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UUPSUpgradeable.getUpgradedEventFromLog(log));
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADED_EVENT));
        return this.upgradedEventFlowable(filter);
    }

    public RemoteFunctionCall<byte[]> proxiableUUID() {
        Function function = new Function(FUNC_PROXIABLEUUID, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bytes32>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeTo(String newImplementation) {
        Function function = new Function(FUNC_UPGRADETO, Arrays.asList(new Address(160, newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeToAndCall(String newImplementation, byte[] data, BigInteger weiValue) {
        Function function = new Function(FUNC_UPGRADETOANDCALL, Arrays.asList(new Address(160, newImplementation), new DynamicBytes(data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function, weiValue);
    }

    @Deprecated
    public static UUPSUpgradeable load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new UUPSUpgradeable(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static UUPSUpgradeable load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new UUPSUpgradeable(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static UUPSUpgradeable load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new UUPSUpgradeable(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static UUPSUpgradeable load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new UUPSUpgradeable(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<UUPSUpgradeable> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return UUPSUpgradeable.deployRemoteCall(UUPSUpgradeable.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<UUPSUpgradeable> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return UUPSUpgradeable.deployRemoteCall(UUPSUpgradeable.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    public static RemoteCall<UUPSUpgradeable> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return UUPSUpgradeable.deployRemoteCall(UUPSUpgradeable.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<UUPSUpgradeable> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return UUPSUpgradeable.deployRemoteCall(UUPSUpgradeable.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    public static class AdminChangedEventResponse
    extends BaseEventResponse {
        public String previousAdmin;
        public String newAdmin;
    }

    public static class BeaconUpgradedEventResponse
    extends BaseEventResponse {
        public String beacon;
    }

    public static class UpgradedEventResponse
    extends BaseEventResponse {
        public String implementation;
    }
}

