/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.scheduling.task;

import io.meeds.dapp.service.MeedAssetsMetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.web3j.protocol.exceptions.ClientConnectionException;

@Component
public class MeedAssetsMetricTask {
    private static final Logger LOG = LoggerFactory.getLogger(MeedAssetsMetricTask.class);
    @Autowired
    private MeedAssetsMetricsService meedAssetsMetricsService;

    @Scheduled(cron="${meeds.token.assets.cron:0 0/15 * * * *}")
    public void computeMeedAssetsMetrics() {
        LOG.info("Start Computing Meed Assets Metrics for Investors app offline access");
        long start = System.currentTimeMillis();
        try {
            this.meedAssetsMetricsService.computeMeedAssetsMetrics();
            LOG.info("End Computing Meed Assets Metrics in {}ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            if (!LOG.isDebugEnabled() && (e instanceof ClientConnectionException || e.getCause() instanceof ClientConnectionException)) {
                LOG.warn("An error occurred while computing Meed Assets Metrics: {}", (Object)e.getMessage());
            }
            LOG.warn("An error occurred while computing Meed Assets Metrics", (Throwable)e);
        }
    }
}

