/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;

@Configuration
public class ElasticSearchConfig
extends ElasticsearchConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchConfig.class);
    @Value(value="${meeds.elasticsearch.username:}")
    private String esUsername;
    @Value(value="${meeds.elasticsearch.password:}")
    private String esPassword;
    @Value(value="${meeds.elasticsearch.url:http://127.0.0.1:9200}")
    private String esUrl;
    @Value(value="${meeds.elasticsearch.socketTimeout:20}")
    private int socketTimeout;
    @Value(value="${meeds.elasticsearch.connectTimeout:20}")
    private int connectionTimeout;
    @Value(value="${meeds.elasticsearch.connectionRetry:60}")
    private int connectionRetry;

    public ClientConfiguration clientConfiguration() {
        String hostAndPort = this.esUrl.split("//")[1];
        ClientConfiguration.ClientConfigurationBuilderWithRequiredEndpoint builder = ClientConfiguration.builder();
        ClientConfiguration.MaybeSecureClientConfigurationBuilder connectionBuilder = builder.connectedTo(hostAndPort);
        if (this.esUrl.contains("https://")) {
            connectionBuilder.usingSsl();
        }
        if (StringUtils.isNotBlank((CharSequence)this.esPassword) && StringUtils.isNotBlank((CharSequence)this.esUsername)) {
            connectionBuilder.withBasicAuth(this.esUsername, this.esPassword);
        }
        connectionBuilder.withConnectTimeout(Duration.ofSeconds(this.connectionTimeout));
        connectionBuilder.withSocketTimeout(Duration.ofSeconds(this.socketTimeout));
        return connectionBuilder.build();
    }

    public ElasticsearchOperations elasticsearchOperations(ElasticsearchConverter elasticsearchConverter, ElasticsearchClient elasticsearchClient) {
        ElasticsearchTemplate elasticsearchTemplate = new ElasticsearchTemplate(elasticsearchClient, elasticsearchConverter);
        elasticsearchTemplate.setRefreshPolicy(RefreshPolicy.IMMEDIATE);
        this.tryConnection((ElasticsearchOperations)elasticsearchTemplate, elasticsearchClient);
        return elasticsearchTemplate;
    }

    private void tryConnection(ElasticsearchOperations elasticsearchOperations, ElasticsearchClient elasticsearchClient) {
        int i = this.connectionRetry;
        while (i-- > 0) {
            int tentative = this.connectionRetry - i;
            try {
                RestClient restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.esUrl.split("//")[1].split(":")[0], Integer.parseInt(this.esUrl.split(":")[2]))}).build();
                Request request = new Request("GET", "/_cluster/health");
                Response response = restClient.performRequest(request);
                try (InputStream is = response.getEntity().getContent();){
                    JsonNode node = new ObjectMapper().readTree(is);
                    boolean timedOut = node.get("timed_out").asBoolean();
                    double activeShardsPercent = node.get("active_shards_percent_as_number").asDouble();
                    int activeShards = node.get("active_shards").asInt();
                    String status = node.get("status").asText();
                    if (timedOut || activeShardsPercent < 1.0 || activeShards == 0 || !StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"green")) {
                        throw new IllegalStateException(String.format("Elasticsearch Cluster Health Check Failed. Active shards = '%s', Percentage = '%.2f', Status = '%s'", activeShards, activeShardsPercent, status));
                    }
                }
                LOG.info("Connection established to ES after {}/{} tentatives", (Object)tentative, (Object)this.connectionRetry);
                i = 0;
            }
            catch (Exception e) {
                if (i == 0) {
                    LOG.warn("Connection failure to ES. tentative {}/{}.", (Object)tentative, (Object)this.connectionRetry);
                    continue;
                }
                LOG.info("Connection failure to ES. tentative {}/{}. Error Message: {}", new Object[]{tentative, this.connectionRetry, e.getMessage()});
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

