/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.elasticsearch.model.UemRewardEntity;
import io.meeds.deeds.common.elasticsearch.storage.UemRewardRepository;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.common.service.HubReportService;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.utils.UemRewardMapper;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.HubReportPayload;
import io.meeds.wom.api.model.UemReward;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class UemRewardService {
    public static final String UEM_REWARD_SAVED = "uem.reward.saved";
    @Autowired
    private HubReportService hubReportService;
    @Autowired
    private BlockchainService blockchainService;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private UemRewardRepository rewardRepository;

    public Page<UemReward> getRewards(String hubAddress, Pageable pageable) {
        Object object = pageable = pageable.isUnpaged() ? pageable : PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSortOr(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"fromDate"})));
        if (StringUtils.isBlank((CharSequence)hubAddress)) {
            return this.rewardRepository.findAll(pageable).map(UemRewardMapper::fromEntity);
        }
        return this.rewardRepository.findByHubAddresses(hubAddress, pageable).map(UemRewardMapper::fromEntity);
    }

    public UemReward getRewardById(long rewardId) {
        return this.rewardRepository.findById(rewardId).map(UemRewardMapper::fromEntity).orElse(null);
    }

    public double getClaimableRewards(String address) {
        return this.blockchainService.getPendingRewards(address);
    }

    public String getUemAddress() {
        return this.blockchainService.getUemAddress();
    }

    public UemReward refreshRewardProperties(long rewardId) {
        UemReward reward = new UemReward();
        reward.setRewardId(rewardId);
        this.blockchainService.retrieveRewardProperties(reward);
        UemRewardEntity rewardEntity = UemRewardMapper.toEntity(reward);
        this.computeUemReward(rewardEntity);
        rewardEntity = (UemRewardEntity)this.rewardRepository.save(rewardEntity);
        this.listenerService.publishEvent(UEM_REWARD_SAVED, rewardEntity.getRewardId());
        return UemRewardMapper.fromEntity(rewardEntity);
    }

    private void computeUemReward(UemRewardEntity rewardEntity) {
        List<HubReport> reports = this.hubReportService.getReportsByRewardId(rewardEntity.getRewardId());
        if (CollectionUtils.isEmpty(reports)) {
            rewardEntity.setSumEd(0.0);
            rewardEntity.setHubAddresses(Collections.emptySet());
        } else {
            reports.forEach(report -> this.hubReportService.computeUemReward((HubReport)report, rewardEntity.getFixedGlobalIndex(), rewardEntity.getAmount()));
            rewardEntity.setSumEd(reports.stream().mapToDouble(HubReport::getEd).sum());
            rewardEntity.setHubAddresses(reports.stream().map(HubReportPayload::getHubAddress).map(StringUtils::lowerCase).collect(Collectors.toSet()));
        }
    }
}

