/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.rest;

import io.meeds.deeds.common.elasticsearch.model.TrialContactInformation;
import io.meeds.deeds.common.service.AuthorizationCodeService;
import io.meeds.deeds.common.service.TrialService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/trials"})
public class TrialController {
    @Autowired
    private TrialService trialService;
    @Autowired
    private AuthorizationCodeService authorizationCodeService;

    @PostMapping(value={"/contact"}, consumes={"application/x-www-form-urlencoded"})
    public TrialContactInformation saveTrial(@RequestParam(name="fullname") String fullname, @RequestParam(name="position") String position, @RequestParam(name="organization") String organization, @RequestParam(name="motivation") String motivation, @RequestParam(name="email") String email, @RequestHeader(name="X-AUTHORIZATION", required=true) int code) {
        if (email == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        try {
            this.authorizationCodeService.validateAndGetData(email, code);
            return this.trialService.saveTrial(fullname, position, organization, motivation, email);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }
}

