/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.rest.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.meeds.wom.api.model.Hub;
import lombok.Generated;
import org.springframework.hateoas.server.core.Relation;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Relation(collectionRelation="hubs", itemRelation="hub")
public class HubWithReward
extends Hub {
    private long actionsCount;
    private double topHubReceiverAmount;
    private double engagementScore;
    private boolean hasReports;

    public HubWithReward(Hub hub, long actionsCount, double topHubReceiverAmount, double engagementScore, boolean hasReports) {
        super(hub.getDeedId(), hub.getCity(), hub.getType(), hub.getAddress(), hub.getName(), hub.getDescription(), hub.getUrl(), hub.getColor(), hub.getHubOwnerAddress(), hub.getDeedOwnerAddress(), hub.getDeedManagerAddress(), hub.getCreatedDate(), hub.getUntilDate(), hub.getJoinDate(), hub.getUpdatedDate(), hub.getUsersCount(), hub.getRewardsPeriodType(), hub.getRewardsPerPeriod(), hub.isConnected(), hub.getOwnerClaimableAmount(), hub.getManagerClaimableAmount());
        this.actionsCount = actionsCount;
        this.topHubReceiverAmount = topHubReceiverAmount;
        this.engagementScore = engagementScore;
        this.hasReports = hasReports;
    }

    @Generated
    public long getActionsCount() {
        return this.actionsCount;
    }

    @Generated
    public double getTopHubReceiverAmount() {
        return this.topHubReceiverAmount;
    }

    @Generated
    public double getEngagementScore() {
        return this.engagementScore;
    }

    @Generated
    public boolean isHasReports() {
        return this.hasReports;
    }

    @Generated
    public void setActionsCount(long actionsCount) {
        this.actionsCount = actionsCount;
    }

    @Generated
    public void setTopHubReceiverAmount(double topHubReceiverAmount) {
        this.topHubReceiverAmount = topHubReceiverAmount;
    }

    @Generated
    public void setEngagementScore(double engagementScore) {
        this.engagementScore = engagementScore;
    }

    @Generated
    public void setHasReports(boolean hasReports) {
        this.hasReports = hasReports;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HubWithReward)) {
            return false;
        }
        HubWithReward other = (HubWithReward)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getActionsCount() != other.getActionsCount()) {
            return false;
        }
        if (Double.compare(this.getTopHubReceiverAmount(), other.getTopHubReceiverAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getEngagementScore(), other.getEngagementScore()) != 0) {
            return false;
        }
        return this.isHasReports() == other.isHasReports();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HubWithReward;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $actionsCount = this.getActionsCount();
        result = result * 59 + (int)($actionsCount >>> 32 ^ $actionsCount);
        long $topHubReceiverAmount = Double.doubleToLongBits(this.getTopHubReceiverAmount());
        result = result * 59 + (int)($topHubReceiverAmount >>> 32 ^ $topHubReceiverAmount);
        long $engagementScore = Double.doubleToLongBits(this.getEngagementScore());
        result = result * 59 + (int)($engagementScore >>> 32 ^ $engagementScore);
        result = result * 59 + (this.isHasReports() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "HubWithReward(super=" + super.toString() + ", actionsCount=" + this.getActionsCount() + ", topHubReceiverAmount=" + this.getTopHubReceiverAmount() + ", engagementScore=" + this.getEngagementScore() + ", hasReports=" + this.isHasReports() + ")";
    }
}

