/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.constant;

import java.time.Period;
import lombok.Generated;

public enum ExpirationDuration {
    ONE_DAY(Period.ofDays(1), 1),
    THREE_DAYS(Period.ofDays(3), 3),
    ONE_WEEK(Period.ofWeeks(1), 7),
    ONE_MONTH(Period.ofMonths(1), 30),
    OTHER(null, 0);

    private Period period;
    private int days;

    public static ExpirationDuration fromDays(int expirationDays) {
        switch (expirationDays) {
            case 1: {
                return ONE_DAY;
            }
            case 3: {
                return THREE_DAYS;
            }
            case 7: {
                return ONE_WEEK;
            }
            case 30: {
                return ONE_MONTH;
            }
        }
        return OTHER;
    }

    @Generated
    private ExpirationDuration(Period period, int days) {
        this.period = period;
        this.days = days;
    }

    @Generated
    public Period getPeriod() {
        return this.period;
    }

    @Generated
    public int getDays() {
        return this.days;
    }
}

