/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.elasticsearch.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.meeds.deeds.common.model.DeedMetadataAttribute;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="deed_nft_metadata", createIndex=true)
@Setting(replicas=0, shards=1)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DeedMetadata
implements Cloneable {
    @Id
    private long nftId;
    private String name;
    private String description;
    @JsonProperty(value="image")
    private String imageUrl;
    @JsonProperty(value="background_color")
    private String backgroundColor;
    @JsonProperty(value="external_url")
    private String externalUrl;
    @JsonProperty(value="external_link")
    private String externalLink;
    @JsonProperty(value="seller_fee_basis_points")
    private String sellerFeeBasisPoints;
    @JsonProperty(value="fee_recipient")
    private String feeRecipient;
    private Set<DeedMetadataAttribute> attributes = new HashSet<DeedMetadataAttribute>();
    @Field(type=FieldType.Date, format={DateFormat.year_month_day})
    private LocalDate date;

    public DeedMetadata clone() {
        return new DeedMetadata(this.nftId, this.name, this.description, this.imageUrl, this.backgroundColor, this.externalUrl, this.externalLink, this.sellerFeeBasisPoints, this.feeRecipient, this.attributes == null ? new HashSet<DeedMetadataAttribute>() : new HashSet<DeedMetadataAttribute>(this.attributes), this.date);
    }

    @Generated
    public long getNftId() {
        return this.nftId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Generated
    public String getExternalLink() {
        return this.externalLink;
    }

    @Generated
    public String getSellerFeeBasisPoints() {
        return this.sellerFeeBasisPoints;
    }

    @Generated
    public String getFeeRecipient() {
        return this.feeRecipient;
    }

    @Generated
    public Set<DeedMetadataAttribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Generated
    public void setNftId(long nftId) {
        this.nftId = nftId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Generated
    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    @Generated
    public void setExternalLink(String externalLink) {
        this.externalLink = externalLink;
    }

    @Generated
    public void setSellerFeeBasisPoints(String sellerFeeBasisPoints) {
        this.sellerFeeBasisPoints = sellerFeeBasisPoints;
    }

    @Generated
    public void setFeeRecipient(String feeRecipient) {
        this.feeRecipient = feeRecipient;
    }

    @Generated
    public void setAttributes(Set<DeedMetadataAttribute> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setDate(LocalDate date) {
        this.date = date;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeedMetadata)) {
            return false;
        }
        DeedMetadata other = (DeedMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNftId() != other.getNftId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor)) {
            return false;
        }
        String this$externalUrl = this.getExternalUrl();
        String other$externalUrl = other.getExternalUrl();
        if (this$externalUrl == null ? other$externalUrl != null : !this$externalUrl.equals(other$externalUrl)) {
            return false;
        }
        String this$externalLink = this.getExternalLink();
        String other$externalLink = other.getExternalLink();
        if (this$externalLink == null ? other$externalLink != null : !this$externalLink.equals(other$externalLink)) {
            return false;
        }
        String this$sellerFeeBasisPoints = this.getSellerFeeBasisPoints();
        String other$sellerFeeBasisPoints = other.getSellerFeeBasisPoints();
        if (this$sellerFeeBasisPoints == null ? other$sellerFeeBasisPoints != null : !this$sellerFeeBasisPoints.equals(other$sellerFeeBasisPoints)) {
            return false;
        }
        String this$feeRecipient = this.getFeeRecipient();
        String other$feeRecipient = other.getFeeRecipient();
        if (this$feeRecipient == null ? other$feeRecipient != null : !this$feeRecipient.equals(other$feeRecipient)) {
            return false;
        }
        Set<DeedMetadataAttribute> this$attributes = this.getAttributes();
        Set<DeedMetadataAttribute> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeedMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $nftId = this.getNftId();
        result = result * 59 + (int)($nftId >>> 32 ^ $nftId);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        String $externalUrl = this.getExternalUrl();
        result = result * 59 + ($externalUrl == null ? 43 : $externalUrl.hashCode());
        String $externalLink = this.getExternalLink();
        result = result * 59 + ($externalLink == null ? 43 : $externalLink.hashCode());
        String $sellerFeeBasisPoints = this.getSellerFeeBasisPoints();
        result = result * 59 + ($sellerFeeBasisPoints == null ? 43 : $sellerFeeBasisPoints.hashCode());
        String $feeRecipient = this.getFeeRecipient();
        result = result * 59 + ($feeRecipient == null ? 43 : $feeRecipient.hashCode());
        Set<DeedMetadataAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeedMetadata(nftId=" + this.getNftId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", imageUrl=" + this.getImageUrl() + ", backgroundColor=" + this.getBackgroundColor() + ", externalUrl=" + this.getExternalUrl() + ", externalLink=" + this.getExternalLink() + ", sellerFeeBasisPoints=" + this.getSellerFeeBasisPoints() + ", feeRecipient=" + this.getFeeRecipient() + ", attributes=" + String.valueOf(this.getAttributes()) + ", date=" + String.valueOf(this.getDate()) + ")";
    }

    @Generated
    public DeedMetadata() {
    }

    @Generated
    public DeedMetadata(long nftId, String name, String description, String imageUrl, String backgroundColor, String externalUrl, String externalLink, String sellerFeeBasisPoints, String feeRecipient, Set<DeedMetadataAttribute> attributes, LocalDate date) {
        this.nftId = nftId;
        this.name = name;
        this.description = description;
        this.imageUrl = imageUrl;
        this.backgroundColor = backgroundColor;
        this.externalUrl = externalUrl;
        this.externalLink = externalLink;
        this.sellerFeeBasisPoints = sellerFeeBasisPoints;
        this.feeRecipient = feeRecipient;
        this.attributes = attributes;
        this.date = date;
    }
}

