/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.elasticsearch.model.DeedFileBinary;
import io.meeds.deeds.common.elasticsearch.storage.DeedFileRepository;
import io.meeds.deeds.common.model.FileBinary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileService {
    @Autowired
    private DeedFileRepository fileRepository;

    public String saveFile(FileBinary fileBinary) throws IOException {
        if (fileBinary == null) {
            throw new IllegalArgumentException("wom.fileIsMandatory");
        }
        DeedFileBinary file = new DeedFileBinary(fileBinary.getId(), fileBinary.getName(), fileBinary.getMimeType(), Base64.encodeBase64String((byte[])IOUtils.toByteArray((InputStream)fileBinary.getBinary())), Instant.now());
        file = (DeedFileBinary)this.fileRepository.save(file);
        return file.getId();
    }

    public FileBinary getFile(String fileId) {
        DeedFileBinary file = this.fileRepository.findById(fileId).orElse(null);
        return file == null ? null : new FileBinary(file.getId(), file.getName(), file.getMimeType(), new ByteArrayInputStream(Base64.decodeBase64((String)file.getBinary())), file.getUpdatedDate());
    }

    public void removeFile(String fileId) {
        this.fileRepository.deleteById(fileId);
    }
}

