/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.constant.TrialStatus;
import io.meeds.deeds.common.elasticsearch.model.TrialContactInformation;
import io.meeds.deeds.common.elasticsearch.storage.TrialRepository;
import io.meeds.deeds.common.service.ListenerService;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrialService {
    @Autowired
    private TrialRepository trialRepository;
    @Autowired
    private ListenerService listenerService;

    public TrialContactInformation getTrialByEmail(String email) {
        return this.trialRepository.findByEmail(email);
    }

    public TrialContactInformation saveTrial(String fullname, String position, String organization, String motivation, String email) {
        if (StringUtils.isBlank((CharSequence)fullname)) {
            throw new IllegalArgumentException("fullname is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)email)) {
            throw new IllegalArgumentException("email is mandatory");
        }
        TrialContactInformation trial = new TrialContactInformation();
        trial.setFullName(fullname);
        trial.setPosition(position);
        trial.setOrganization(organization);
        trial.setMotivation(motivation);
        trial.setEmail(email);
        trial.setCreatedDate(LocalDateTime.now());
        trial.setLastModifiedDate(trial.getCreatedDate());
        trial.setStatus(TrialStatus.OPEN);
        TrialContactInformation savedTrial = (TrialContactInformation)this.trialRepository.save(trial);
        this.listenerService.publishEvent("deed.event.trialCreate", savedTrial);
        return savedTrial;
    }
}

