/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.listener;

import io.meeds.deeds.common.constant.UnauthorizedOperationException;
import io.meeds.deeds.common.listener.EventListener;
import io.meeds.deeds.common.model.DeedTenantLeaseDTO;
import io.meeds.deeds.common.service.OfferService;
import io.meeds.deeds.common.service.TenantService;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfferAcquiredListener
implements EventListener<DeedTenantLeaseDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(OfferAcquiredListener.class);
    public static final String LISTENER_NAME = "OfferAcquiredListener";
    private static final List<String> SUPPORTED_EVENTS = Collections.singletonList("deed.event.leaseAcquisionConfirmed");
    @Autowired
    private OfferService offerService;
    @Autowired
    private TenantService tenantService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, DeedTenantLeaseDTO lease) {
        if (!lease.isConfirmed()) {
            LOG.warn("Seems a bug, the lease change has been triggered as lease acquisition confirmed while it's not!");
            return;
        }
        if (lease.getStartDate() != null && lease.getStartDate().isBefore(Instant.now())) {
            try {
                this.tenantService.markDeedAsAcquired(lease.getNftId(), lease.getManagerAddress());
            }
            catch (UnauthorizedOperationException e) {
                LOG.warn("It seems that Hub Manager {} isn't Provisioning Manager of Deed {} anymore. Ignore assigning Tenant to this manager", (Object)lease.getManagerAddress(), (Object)lease.getNftId());
            }
            catch (Exception e) {
                LOG.warn("Error Marking Tenant as acquired for lease with id {} and nft id {}", new Object[]{lease.getId(), lease.getNftId(), e});
            }
        } else {
            LOG.info("Acquired Lease {} by {} of nft {} seems to be in the future, thus Tenant Management will not be delegated immediatly", new Object[]{lease.getId(), lease.getManagerAddress(), lease.getNftId()});
        }
        try {
            this.offerService.markOfferAsAcquired(lease.getId(), lease.getEndDate());
        }
        catch (Exception e) {
            LOG.warn("Error Marking Offers as acquired for lease with id {} and end date {}", new Object[]{lease.getId(), Date.from(lease.getEndDate()), e});
        }
    }
}

