/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.service;

import io.meeds.deeds.common.model.FundInfo;
import io.meeds.deeds.common.model.MeedAssetsMetrics;
import io.meeds.deeds.common.service.BlockchainService;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MeedAssetsMetricsService {
    @Autowired
    private BlockchainService blockchainService;
    protected MeedAssetsMetrics meedAssetsMetrics;

    public MeedAssetsMetrics getMeedAssetsMetrics(boolean forceCompute) {
        if (this.meedAssetsMetrics == null || forceCompute) {
            this.computeMeedAssetsMetrics();
        }
        return this.meedAssetsMetrics;
    }

    public void computeMeedAssetsMetrics() {
        MeedAssetsMetrics metrics = new MeedAssetsMetrics();
        this.addPools(metrics);
        metrics.setTotalAllocationPoints(this.blockchainService.totalAllocationPoints());
        metrics.setTotalFixedPercentage(this.blockchainService.totalFixedPercentage());
        metrics.setCurrentCity(this.blockchainService.getCurrentCity());
        this.meedAssetsMetrics = metrics;
    }

    private void addPools(MeedAssetsMetrics metrics) {
        FundInfo sushiPairFundInfo;
        ArrayList<FundInfo> pools = new ArrayList<FundInfo>();
        FundInfo xMeedFundInfo = this.blockchainService.getXMeedFundInfo();
        if (xMeedFundInfo != null) {
            pools.add(xMeedFundInfo);
        }
        if ((sushiPairFundInfo = this.blockchainService.getSushiPairFundInfo()) != null) {
            pools.add(sushiPairFundInfo);
        }
        metrics.setPools(pools);
    }
}

