// SPDX-License-Identifier: UNLICENSED
pragma solidity 0.8.9;

/**
 * @notice Contract that handles metadata related methods.
 * @dev Methods assume a deterministic generation of URI based on token IDs.
 *      Methods also assume that URI uses hex representation of token IDs.
 */
abstract contract ERC1155Metadata {

    /***********************************|
     *   |     Metadata Public Function s    |
     |__________________________________*/
    /**
     * @notice A distinct Uniform Resource Identifier (URI) for a given token.
     * @dev URIs are defined in RFC 3986.
     *      URIs are assumed to be deterministically generated based on token ID
     *      Token IDs are assumed to be represented in their hex format in URIs
     * @return URI string
     */
    function uri(uint256 _id) external view virtual returns (string memory);
}


