/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.constant;

import java.time.Period;

public enum NoticePeriod {
    NO_PERIOD(Period.ZERO, 0),
    ONE_MONTH(Period.ofMonths(1), 1),
    TWO_MONTHS(Period.ofMonths(2), 2),
    THREE_MONTHS(Period.ofMonths(3), 3),
    OTHER(null, 0);

    private Period period;
    private int months;

    public static NoticePeriod fromMonths(int months) {
        switch (months) {
            case 0: {
                return NO_PERIOD;
            }
            case 1: {
                return ONE_MONTH;
            }
            case 2: {
                return TWO_MONTHS;
            }
            case 3: {
                return THREE_MONTHS;
            }
        }
        return OTHER;
    }

    private NoticePeriod(Period period, int months) {
        this.period = period;
        this.months = months;
    }

    public Period getPeriod() {
        return this.period;
    }

    public int getMonths() {
        return this.months;
    }
}

