/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.model;

import java.math.BigDecimal;
import java.time.LocalDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="meed_exchange_rate", createIndex=true)
@Setting(sortFields={"date"}, sortOrders={Setting.SortOrder.desc}, replicas=0, shards=1)
public class MeedExchangeRate {
    @Id
    @Field(type=FieldType.Date, format={DateFormat.year_month_day})
    private LocalDate date;
    private BigDecimal ethUsdPrice;
    private BigDecimal meedEthPrice;
    private BigDecimal meedReserve;
    private BigDecimal ethReserve;
    private boolean finalRate;

    public MeedExchangeRate(LocalDate date) {
        this.date = date;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public BigDecimal getEthUsdPrice() {
        return this.ethUsdPrice;
    }

    public BigDecimal getMeedEthPrice() {
        return this.meedEthPrice;
    }

    public BigDecimal getMeedReserve() {
        return this.meedReserve;
    }

    public BigDecimal getEthReserve() {
        return this.ethReserve;
    }

    public boolean isFinalRate() {
        return this.finalRate;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public void setEthUsdPrice(BigDecimal ethUsdPrice) {
        this.ethUsdPrice = ethUsdPrice;
    }

    public void setMeedEthPrice(BigDecimal meedEthPrice) {
        this.meedEthPrice = meedEthPrice;
    }

    public void setMeedReserve(BigDecimal meedReserve) {
        this.meedReserve = meedReserve;
    }

    public void setEthReserve(BigDecimal ethReserve) {
        this.ethReserve = ethReserve;
    }

    public void setFinalRate(boolean finalRate) {
        this.finalRate = finalRate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeedExchangeRate)) {
            return false;
        }
        MeedExchangeRate other = (MeedExchangeRate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFinalRate() != other.isFinalRate()) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        BigDecimal this$ethUsdPrice = this.getEthUsdPrice();
        BigDecimal other$ethUsdPrice = other.getEthUsdPrice();
        if (this$ethUsdPrice == null ? other$ethUsdPrice != null : !((Object)this$ethUsdPrice).equals(other$ethUsdPrice)) {
            return false;
        }
        BigDecimal this$meedEthPrice = this.getMeedEthPrice();
        BigDecimal other$meedEthPrice = other.getMeedEthPrice();
        if (this$meedEthPrice == null ? other$meedEthPrice != null : !((Object)this$meedEthPrice).equals(other$meedEthPrice)) {
            return false;
        }
        BigDecimal this$meedReserve = this.getMeedReserve();
        BigDecimal other$meedReserve = other.getMeedReserve();
        if (this$meedReserve == null ? other$meedReserve != null : !((Object)this$meedReserve).equals(other$meedReserve)) {
            return false;
        }
        BigDecimal this$ethReserve = this.getEthReserve();
        BigDecimal other$ethReserve = other.getEthReserve();
        return !(this$ethReserve == null ? other$ethReserve != null : !((Object)this$ethReserve).equals(other$ethReserve));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeedExchangeRate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFinalRate() ? 79 : 97);
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        BigDecimal $ethUsdPrice = this.getEthUsdPrice();
        result = result * 59 + ($ethUsdPrice == null ? 43 : ((Object)$ethUsdPrice).hashCode());
        BigDecimal $meedEthPrice = this.getMeedEthPrice();
        result = result * 59 + ($meedEthPrice == null ? 43 : ((Object)$meedEthPrice).hashCode());
        BigDecimal $meedReserve = this.getMeedReserve();
        result = result * 59 + ($meedReserve == null ? 43 : ((Object)$meedReserve).hashCode());
        BigDecimal $ethReserve = this.getEthReserve();
        result = result * 59 + ($ethReserve == null ? 43 : ((Object)$ethReserve).hashCode());
        return result;
    }

    public String toString() {
        return "MeedExchangeRate(date=" + this.getDate() + ", ethUsdPrice=" + this.getEthUsdPrice() + ", meedEthPrice=" + this.getMeedEthPrice() + ", meedReserve=" + this.getMeedReserve() + ", ethReserve=" + this.getEthReserve() + ", finalRate=" + this.isFinalRate() + ")";
    }

    public MeedExchangeRate(LocalDate date, BigDecimal ethUsdPrice, BigDecimal meedEthPrice, BigDecimal meedReserve, BigDecimal ethReserve, boolean finalRate) {
        this.date = date;
        this.ethUsdPrice = ethUsdPrice;
        this.meedEthPrice = meedEthPrice;
        this.meedReserve = meedReserve;
        this.ethReserve = ethReserve;
        this.finalRate = finalRate;
    }

    public MeedExchangeRate() {
    }
}

