/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest;

import io.meeds.deeds.constant.Currency;
import io.meeds.deeds.model.MeedPrice;
import io.meeds.deeds.service.ExchangeService;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/exchange"})
public class ExchangeController {
    @Autowired
    private ExchangeService exchangeService;

    @GetMapping(value={"/{currency}"})
    public ResponseEntity<List<MeedPrice>> getExchangeRates(@PathVariable(name="currency") Currency currency, @RequestParam(name="from", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fromDate) {
        LocalDate today = LocalDate.now(ZoneOffset.UTC);
        if (fromDate.isAfter(today)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "From date must be before today");
        }
        List<MeedPrice> exchangeRates = this.exchangeService.getExchangeRates(currency, fromDate, today);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)15L, (TimeUnit)TimeUnit.MINUTES).cachePublic())).lastModified(ZonedDateTime.now())).body(exchangeRates);
    }
}

