/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.scheduling.task;

import io.meeds.deeds.model.DeedTenantOfferDTO;
import io.meeds.deeds.service.BlockchainService;
import io.meeds.deeds.service.OfferService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class OfferBlockchainTransactionCheckTask {
    private static final Logger LOG = LoggerFactory.getLogger(OfferBlockchainTransactionCheckTask.class);
    @Autowired
    private OfferService offerService;
    @Autowired
    private BlockchainService blockchainService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelay=1L, timeUnit=TimeUnit.MINUTES, initialDelay=1L)
    public void checkPendingOffers() {
        List<DeedTenantOfferDTO> pendingOffers = this.offerService.getPendingTransactions();
        int pendingOffersSize = pendingOffers.size();
        if (pendingOffersSize == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        LOG.info("Check {} pending transactions for Deed Offers.", (Object)pendingOffersSize);
        try {
            pendingOffers.forEach(deedOffer -> {
                String transactionHash = deedOffer.getOfferTransactionHash();
                try {
                    if (StringUtils.isBlank((CharSequence)transactionHash)) {
                        this.offerService.updateRentingOfferStatusFromBlockchain(deedOffer.getId(), Collections.emptyMap());
                    } else if (this.blockchainService.isTransactionMined(transactionHash)) {
                        Map minedEvents = this.blockchainService.getOfferTransactionEvents(transactionHash);
                        this.offerService.updateRentingOfferStatusFromBlockchain(deedOffer.getId(), minedEvents);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Can't update offer pending transaction {} status. It will be reattempted later.", (Object)transactionHash, (Object)e);
                }
            });
        }
        finally {
            LOG.info("End checking {} pending transactions for Deed Offers in {}ms.", (Object)pendingOffersSize, (Object)(System.currentTimeMillis() - start));
        }
    }
}

