/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.scheduling.task;

import io.meeds.deeds.constant.BlockchainLeaseStatus;
import io.meeds.deeds.constant.BlockchainOfferStatus;
import io.meeds.deeds.model.DeedLeaseBlockchainState;
import io.meeds.deeds.model.DeedOfferBlockchainState;
import io.meeds.deeds.service.BlockchainService;
import io.meeds.deeds.service.LeaseService;
import io.meeds.deeds.service.OfferService;
import io.meeds.deeds.service.SettingService;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RentingBlockchainMinedEventsCheckTask {
    private static final Logger LOG = LoggerFactory.getLogger(RentingBlockchainMinedEventsCheckTask.class);
    private static final String SETTING_LAST_TIME_CHECK_KEY = "minedProvisioningTransactionsCheck";
    @Autowired
    private LeaseService leaseService;
    @Autowired
    private OfferService offerService;
    @Autowired
    private BlockchainService blockchainService;
    @Autowired
    private SettingService settingService;

    @Scheduled(fixedDelay=5L, timeUnit=TimeUnit.MINUTES, initialDelay=2L)
    public void checkMinedRentingEvents() {
        long lastBlock = this.blockchainService.getLastBlock();
        long lastCheckedBlock = this.getLastCheckedBlock();
        long start = System.currentTimeMillis();
        LOG.debug("Checking Renting events happened on Blockchain contract.");
        List minedEvents = this.blockchainService.getMinedRentingTransactions(lastCheckedBlock, lastBlock);
        if (CollectionUtils.isEmpty((Collection)minedEvents)) {
            LOG.debug("End retrieving renting events in {}ms. No events for now", (Object)(System.currentTimeMillis() - start));
            return;
        }
        LOG.debug("End retrieving renting events happened on Blockchain contract {} in {}ms.", (Object)minedEvents.size(), (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        LOG.debug("Check Renting events happened on Blockchain contract {} .", (Object)minedEvents.size());
        minedEvents.forEach(event -> {
            if (!event.isEmpty() && event instanceof EnumMap) {
                Object keyType = event.keySet().iterator().next();
                if (keyType instanceof BlockchainLeaseStatus) {
                    BlockchainLeaseStatus status = (BlockchainLeaseStatus)keyType;
                    Map events = event;
                    DeedLeaseBlockchainState deedLease = (DeedLeaseBlockchainState)events.get(status);
                    LOG.debug("Check Lease event {} happened on Blockchain contract {} .", (Object)status, (Object)deedLease);
                    this.updateLeaseStatusFromBlockchain(status, deedLease);
                } else if (keyType instanceof BlockchainOfferStatus) {
                    BlockchainOfferStatus status = (BlockchainOfferStatus)keyType;
                    Map events = event;
                    DeedOfferBlockchainState blockchainOffer = (DeedOfferBlockchainState)events.get(status);
                    LOG.debug("Check Offer event {} happened on Blockchain contract {} .", (Object)status, (Object)blockchainOffer);
                    this.updateOfferFromBlockchain(blockchainOffer);
                }
            }
        });
        this.saveLastCheckedBlock(lastBlock);
        LOG.debug("End checking renting events happened on Blockchain contract {} in {}ms.", (Object)minedEvents.size(), (Object)(System.currentTimeMillis() - start));
    }

    private void updateOfferFromBlockchain(DeedOfferBlockchainState blockchainOffer) {
        try {
            this.offerService.updateOfferFromBlockchain(blockchainOffer, true);
        }
        catch (Exception e) {
            LOG.warn("Error updating blockchain information of blockchain change for an offer: {}", (Object)blockchainOffer, (Object)e);
        }
    }

    private void updateLeaseStatusFromBlockchain(BlockchainLeaseStatus status, DeedLeaseBlockchainState deedLease) {
        try {
            this.leaseService.updateLeaseStatusFromBlockchain(deedLease, status);
        }
        catch (Exception e) {
            LOG.warn("Error updating blockchain information of blockchain change for a lease: {}", (Object)deedLease, (Object)e);
        }
    }

    private long getLastCheckedBlock() {
        String settingValue = this.settingService.get(SETTING_LAST_TIME_CHECK_KEY);
        return settingValue == null ? 0L : Long.parseLong(settingValue);
    }

    private void saveLastCheckedBlock(long lastBlock) {
        this.settingService.save(SETTING_LAST_TIME_CHECK_KEY, String.valueOf(lastBlock));
    }
}

