/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest;

import io.meeds.deeds.model.UserProfileDTO;
import io.meeds.deeds.service.UserProfileService;
import java.security.Principal;
import javax.annotation.security.RolesAllowed;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/profile"})
public class UserProfileController {
    @Autowired
    private UserProfileService userProfileService;

    @GetMapping(path={"/email"}, produces={"text/plain"})
    @RolesAllowed(value={"USER"})
    @ResponseStatus(value=HttpStatus.OK)
    public String getEmail(Principal principal) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName())) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
        String walletAddress = principal.getName();
        UserProfileDTO userProfile = this.userProfileService.getUserProfile(walletAddress);
        return userProfile == null ? null : userProfile.getEmail();
    }
}

