/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest.utils;

import io.meeds.deeds.constant.TenantProvisioningStatus;
import io.meeds.deeds.constant.TenantStatus;
import io.meeds.deeds.elasticsearch.model.DeedMetadata;
import io.meeds.deeds.elasticsearch.model.DeedMetadataAttribute;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.web.rest.model.DeedMetadataPresentation;
import io.meeds.deeds.web.rest.model.DeedTenantPresentation;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;

public class EntityMapper {
    private EntityMapper() {
    }

    public static ResponseEntity<DeedTenantPresentation> getDeedTenantResponse(DeedTenant deedTenant) {
        if (deedTenant == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok().body((Object)EntityMapper.build(deedTenant));
    }

    public static ResponseEntity<DeedMetadataPresentation> getDeedMetadataResponse(DeedMetadata deedMetadata) {
        if (deedMetadata == null) {
            return ResponseEntity.notFound().build();
        }
        ResponseEntity.BodyBuilder response = ResponseEntity.ok();
        EntityMapper.applyCache(response);
        EntityMapper.allowOtherOrigins(response);
        return response.body((Object)EntityMapper.build(deedMetadata));
    }

    public static DeedMetadataPresentation build(DeedMetadata deedMetadata) {
        if (deedMetadata == null) {
            return null;
        }
        HashSet<DeedMetadataAttribute> attributes = deedMetadata.getAttributes() == null ? new HashSet<DeedMetadataAttribute>() : new HashSet(deedMetadata.getAttributes());
        return new DeedMetadataPresentation(deedMetadata.getName(), deedMetadata.getDescription(), deedMetadata.getImageUrl(), deedMetadata.getBackgroundColor(), deedMetadata.getExternalUrl(), deedMetadata.getExternalLink(), deedMetadata.getSellerFeeBasisPoints(), deedMetadata.getFeeRecipient(), attributes);
    }

    public static DeedTenantPresentation build(DeedTenant deedTenant) {
        LocalDateTime date = deedTenant.getDate();
        long epochSecond = date == null ? 0L : date.toEpochSecond(ZoneOffset.UTC);
        return new DeedTenantPresentation(deedTenant.getNftId(), deedTenant.getManagerAddress(), Objects.requireNonNullElse(deedTenant.getTenantProvisioningStatus(), TenantProvisioningStatus.STOP_CONFIRMED), Objects.requireNonNullElse(deedTenant.getTenantStatus(), TenantStatus.UNDEPLOYED), epochSecond);
    }

    private static void applyCache(ResponseEntity.BodyBuilder response) {
        ((ResponseEntity.BodyBuilder)response.cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.DAYS).cachePublic())).lastModified(ZonedDateTime.now());
    }

    private static void allowOtherOrigins(ResponseEntity.BodyBuilder response) {
        response.headers(headers -> {
            headers.set("Access-Control-Allow-Origin", "*");
            headers.addAll("Access-Control-Allow-Headers", Arrays.asList("Content-Type", "Range", "User-Agent", "X-Requested-With"));
            headers.addAll("Access-Control-Expose-Headers", Arrays.asList("Content-Range", "X-Chunked-Output", "X-Stream-Output"));
            headers.addAll("Access-Control-Allow-Methods", Arrays.asList("GET", "HEAD"));
        });
    }
}

