/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest;

import io.meeds.deeds.elasticsearch.model.DeedMetadata;
import io.meeds.deeds.service.DeedMetadataService;
import io.meeds.deeds.web.rest.model.DeedMetadataPresentation;
import io.meeds.deeds.web.rest.utils.EntityMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/deeds"})
public class DeedMetadataController {
    @Autowired
    private DeedMetadataService deedMetadataService;

    @GetMapping
    public ResponseEntity<DeedMetadataPresentation> getContractMetadata() {
        DeedMetadata deedMetadata = this.deedMetadataService.getContractMetadata();
        return EntityMapper.getDeedMetadataResponse(deedMetadata);
    }

    @GetMapping(value={"/{nftId}"})
    public ResponseEntity<DeedMetadataPresentation> getNftMetadata(@PathVariable(name="nftId") Long nftId) {
        DeedMetadata deedMetadata = this.deedMetadataService.getDeedMetadata(nftId);
        return EntityMapper.getDeedMetadataResponse(deedMetadata);
    }

    @GetMapping(value={"/type/{cityIndex}/{cardType}"})
    public ResponseEntity<DeedMetadataPresentation> getNftMetadata(@PathVariable(name="cityIndex") short cityIndex, @PathVariable(name="cardType") short cardType) {
        DeedMetadata deedMetadata = this.deedMetadataService.getDeedMetadataOfCard(cityIndex, cardType);
        return EntityMapper.getDeedMetadataResponse(deedMetadata);
    }
}

