/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.constant;

import java.time.Period;

public enum RentalDuration {
    ONE_MONTH(Period.ofMonths(1), 1),
    THREE_MONTHS(Period.ofMonths(3), 3),
    SIX_MONTHS(Period.ofMonths(6), 6),
    ONE_YEAR(Period.ofYears(1), 12),
    OTHER(null, 0);

    private Period period;
    private int months;

    public static RentalDuration fromMonths(int months) {
        switch (months) {
            case 1: {
                return ONE_MONTH;
            }
            case 3: {
                return THREE_MONTHS;
            }
            case 6: {
                return SIX_MONTHS;
            }
            case 12: {
                return ONE_YEAR;
            }
        }
        return OTHER;
    }

    private RentalDuration(Period period, int months) {
        this.period = period;
        this.months = months;
    }

    public Period getPeriod() {
        return this.period;
    }

    public int getMonths() {
        return this.months;
    }
}

