/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.model;

import io.meeds.deeds.constant.DeedCard;
import io.meeds.deeds.constant.DeedCity;
import io.meeds.deeds.constant.RentalPaymentPeriodicity;
import io.meeds.deeds.constant.TransactionStatus;
import java.time.Instant;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="deed_tenant_lease", createIndex=true)
@Setting(replicas=0, shards=1)
public class DeedTenantLease {
    @Id
    @Field(type=FieldType.Long)
    private long id;
    @Field(type=FieldType.Long)
    private long nftId;
    @Field(type=FieldType.Auto)
    private DeedCity city;
    @Field(type=FieldType.Auto)
    private DeedCard cardType;
    @Field(type=FieldType.Long)
    private int months;
    @Field(type=FieldType.Long)
    private int paidMonths;
    @Field(type=FieldType.Integer)
    private int noticePeriod;
    @Field(type=FieldType.Long)
    private int monthPaymentInProgress;
    @Field(type=FieldType.Keyword, storeNullValue=true)
    private String owner;
    @Field(type=FieldType.Keyword, storeNullValue=true)
    private String manager;
    @Field(type=FieldType.Keyword)
    private String managerEmail;
    @Field(type=FieldType.Keyword)
    private List<String> viewAddresses;
    @Field(type=FieldType.Keyword)
    private RentalPaymentPeriodicity paymentPeriodicity;
    @Field(type=FieldType.Double)
    private double amount;
    @Field(type=FieldType.Double)
    private double allDurationAmount;
    @Field(type=FieldType.Double)
    private double distributedAmount;
    @Field(type=FieldType.Integer)
    private int ownerMintingPercentage;
    @Field(type=FieldType.Double)
    private double mintingPower;
    @Field(type=FieldType.Keyword)
    private List<String> pendingTransactions;
    @Field(type=FieldType.Keyword)
    private TransactionStatus transactionStatus;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant startDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant endDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant noticeDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant paidRentsDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant createdDate;
    @Field(type=FieldType.Boolean)
    private boolean confirmed;
    @Field(type=FieldType.Boolean)
    private boolean enabled;
    @Field(type=FieldType.Boolean)
    private boolean endingLease;
    @Field(type=FieldType.Keyword)
    private String endingLeaseAddress;
    @Field(type=FieldType.Long)
    private long lastCheckedBlock;

    public long getId() {
        return this.id;
    }

    public long getNftId() {
        return this.nftId;
    }

    public DeedCity getCity() {
        return this.city;
    }

    public DeedCard getCardType() {
        return this.cardType;
    }

    public int getMonths() {
        return this.months;
    }

    public int getPaidMonths() {
        return this.paidMonths;
    }

    public int getNoticePeriod() {
        return this.noticePeriod;
    }

    public int getMonthPaymentInProgress() {
        return this.monthPaymentInProgress;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getManager() {
        return this.manager;
    }

    public String getManagerEmail() {
        return this.managerEmail;
    }

    public List<String> getViewAddresses() {
        return this.viewAddresses;
    }

    public RentalPaymentPeriodicity getPaymentPeriodicity() {
        return this.paymentPeriodicity;
    }

    public double getAmount() {
        return this.amount;
    }

    public double getAllDurationAmount() {
        return this.allDurationAmount;
    }

    public double getDistributedAmount() {
        return this.distributedAmount;
    }

    public int getOwnerMintingPercentage() {
        return this.ownerMintingPercentage;
    }

    public double getMintingPower() {
        return this.mintingPower;
    }

    public List<String> getPendingTransactions() {
        return this.pendingTransactions;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public Instant getNoticeDate() {
        return this.noticeDate;
    }

    public Instant getPaidRentsDate() {
        return this.paidRentsDate;
    }

    public Instant getCreatedDate() {
        return this.createdDate;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEndingLease() {
        return this.endingLease;
    }

    public String getEndingLeaseAddress() {
        return this.endingLeaseAddress;
    }

    public long getLastCheckedBlock() {
        return this.lastCheckedBlock;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setNftId(long nftId) {
        this.nftId = nftId;
    }

    public void setCity(DeedCity city) {
        this.city = city;
    }

    public void setCardType(DeedCard cardType) {
        this.cardType = cardType;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public void setPaidMonths(int paidMonths) {
        this.paidMonths = paidMonths;
    }

    public void setNoticePeriod(int noticePeriod) {
        this.noticePeriod = noticePeriod;
    }

    public void setMonthPaymentInProgress(int monthPaymentInProgress) {
        this.monthPaymentInProgress = monthPaymentInProgress;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public void setManagerEmail(String managerEmail) {
        this.managerEmail = managerEmail;
    }

    public void setViewAddresses(List<String> viewAddresses) {
        this.viewAddresses = viewAddresses;
    }

    public void setPaymentPeriodicity(RentalPaymentPeriodicity paymentPeriodicity) {
        this.paymentPeriodicity = paymentPeriodicity;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public void setAllDurationAmount(double allDurationAmount) {
        this.allDurationAmount = allDurationAmount;
    }

    public void setDistributedAmount(double distributedAmount) {
        this.distributedAmount = distributedAmount;
    }

    public void setOwnerMintingPercentage(int ownerMintingPercentage) {
        this.ownerMintingPercentage = ownerMintingPercentage;
    }

    public void setMintingPower(double mintingPower) {
        this.mintingPower = mintingPower;
    }

    public void setPendingTransactions(List<String> pendingTransactions) {
        this.pendingTransactions = pendingTransactions;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setStartDate(Instant startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Instant endDate) {
        this.endDate = endDate;
    }

    public void setNoticeDate(Instant noticeDate) {
        this.noticeDate = noticeDate;
    }

    public void setPaidRentsDate(Instant paidRentsDate) {
        this.paidRentsDate = paidRentsDate;
    }

    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEndingLease(boolean endingLease) {
        this.endingLease = endingLease;
    }

    public void setEndingLeaseAddress(String endingLeaseAddress) {
        this.endingLeaseAddress = endingLeaseAddress;
    }

    public void setLastCheckedBlock(long lastCheckedBlock) {
        this.lastCheckedBlock = lastCheckedBlock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeedTenantLease)) {
            return false;
        }
        DeedTenantLease other = (DeedTenantLease)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getNftId() != other.getNftId()) {
            return false;
        }
        if (this.getMonths() != other.getMonths()) {
            return false;
        }
        if (this.getPaidMonths() != other.getPaidMonths()) {
            return false;
        }
        if (this.getNoticePeriod() != other.getNoticePeriod()) {
            return false;
        }
        if (this.getMonthPaymentInProgress() != other.getMonthPaymentInProgress()) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getAllDurationAmount(), other.getAllDurationAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getDistributedAmount(), other.getDistributedAmount()) != 0) {
            return false;
        }
        if (this.getOwnerMintingPercentage() != other.getOwnerMintingPercentage()) {
            return false;
        }
        if (Double.compare(this.getMintingPower(), other.getMintingPower()) != 0) {
            return false;
        }
        if (this.isConfirmed() != other.isConfirmed()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isEndingLease() != other.isEndingLease()) {
            return false;
        }
        if (this.getLastCheckedBlock() != other.getLastCheckedBlock()) {
            return false;
        }
        DeedCity this$city = this.getCity();
        DeedCity other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        DeedCard this$cardType = this.getCardType();
        DeedCard other$cardType = other.getCardType();
        if (this$cardType == null ? other$cardType != null : !this$cardType.equals(other$cardType)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$manager = this.getManager();
        String other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !this$manager.equals(other$manager)) {
            return false;
        }
        String this$managerEmail = this.getManagerEmail();
        String other$managerEmail = other.getManagerEmail();
        if (this$managerEmail == null ? other$managerEmail != null : !this$managerEmail.equals(other$managerEmail)) {
            return false;
        }
        List<String> this$viewAddresses = this.getViewAddresses();
        List<String> other$viewAddresses = other.getViewAddresses();
        if (this$viewAddresses == null ? other$viewAddresses != null : !((Object)this$viewAddresses).equals(other$viewAddresses)) {
            return false;
        }
        RentalPaymentPeriodicity this$paymentPeriodicity = this.getPaymentPeriodicity();
        RentalPaymentPeriodicity other$paymentPeriodicity = other.getPaymentPeriodicity();
        if (this$paymentPeriodicity == null ? other$paymentPeriodicity != null : !((Object)((Object)this$paymentPeriodicity)).equals((Object)other$paymentPeriodicity)) {
            return false;
        }
        List<String> this$pendingTransactions = this.getPendingTransactions();
        List<String> other$pendingTransactions = other.getPendingTransactions();
        if (this$pendingTransactions == null ? other$pendingTransactions != null : !((Object)this$pendingTransactions).equals(other$pendingTransactions)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        Instant this$startDate = this.getStartDate();
        Instant other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Instant this$endDate = this.getEndDate();
        Instant other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Instant this$noticeDate = this.getNoticeDate();
        Instant other$noticeDate = other.getNoticeDate();
        if (this$noticeDate == null ? other$noticeDate != null : !((Object)this$noticeDate).equals(other$noticeDate)) {
            return false;
        }
        Instant this$paidRentsDate = this.getPaidRentsDate();
        Instant other$paidRentsDate = other.getPaidRentsDate();
        if (this$paidRentsDate == null ? other$paidRentsDate != null : !((Object)this$paidRentsDate).equals(other$paidRentsDate)) {
            return false;
        }
        Instant this$createdDate = this.getCreatedDate();
        Instant other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        String this$endingLeaseAddress = this.getEndingLeaseAddress();
        String other$endingLeaseAddress = other.getEndingLeaseAddress();
        return !(this$endingLeaseAddress == null ? other$endingLeaseAddress != null : !this$endingLeaseAddress.equals(other$endingLeaseAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeedTenantLease;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $nftId = this.getNftId();
        result = result * 59 + (int)($nftId >>> 32 ^ $nftId);
        result = result * 59 + this.getMonths();
        result = result * 59 + this.getPaidMonths();
        result = result * 59 + this.getNoticePeriod();
        result = result * 59 + this.getMonthPaymentInProgress();
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $allDurationAmount = Double.doubleToLongBits(this.getAllDurationAmount());
        result = result * 59 + (int)($allDurationAmount >>> 32 ^ $allDurationAmount);
        long $distributedAmount = Double.doubleToLongBits(this.getDistributedAmount());
        result = result * 59 + (int)($distributedAmount >>> 32 ^ $distributedAmount);
        result = result * 59 + this.getOwnerMintingPercentage();
        long $mintingPower = Double.doubleToLongBits(this.getMintingPower());
        result = result * 59 + (int)($mintingPower >>> 32 ^ $mintingPower);
        result = result * 59 + (this.isConfirmed() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isEndingLease() ? 79 : 97);
        long $lastCheckedBlock = this.getLastCheckedBlock();
        result = result * 59 + (int)($lastCheckedBlock >>> 32 ^ $lastCheckedBlock);
        DeedCity $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        DeedCard $cardType = this.getCardType();
        result = result * 59 + ($cardType == null ? 43 : $cardType.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : $manager.hashCode());
        String $managerEmail = this.getManagerEmail();
        result = result * 59 + ($managerEmail == null ? 43 : $managerEmail.hashCode());
        List<String> $viewAddresses = this.getViewAddresses();
        result = result * 59 + ($viewAddresses == null ? 43 : ((Object)$viewAddresses).hashCode());
        RentalPaymentPeriodicity $paymentPeriodicity = this.getPaymentPeriodicity();
        result = result * 59 + ($paymentPeriodicity == null ? 43 : ((Object)((Object)$paymentPeriodicity)).hashCode());
        List<String> $pendingTransactions = this.getPendingTransactions();
        result = result * 59 + ($pendingTransactions == null ? 43 : ((Object)$pendingTransactions).hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        Instant $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Instant $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Instant $noticeDate = this.getNoticeDate();
        result = result * 59 + ($noticeDate == null ? 43 : ((Object)$noticeDate).hashCode());
        Instant $paidRentsDate = this.getPaidRentsDate();
        result = result * 59 + ($paidRentsDate == null ? 43 : ((Object)$paidRentsDate).hashCode());
        Instant $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        String $endingLeaseAddress = this.getEndingLeaseAddress();
        result = result * 59 + ($endingLeaseAddress == null ? 43 : $endingLeaseAddress.hashCode());
        return result;
    }

    public String toString() {
        return "DeedTenantLease(id=" + this.getId() + ", nftId=" + this.getNftId() + ", city=" + this.getCity() + ", cardType=" + this.getCardType() + ", months=" + this.getMonths() + ", paidMonths=" + this.getPaidMonths() + ", noticePeriod=" + this.getNoticePeriod() + ", monthPaymentInProgress=" + this.getMonthPaymentInProgress() + ", owner=" + this.getOwner() + ", manager=" + this.getManager() + ", managerEmail=" + this.getManagerEmail() + ", viewAddresses=" + this.getViewAddresses() + ", paymentPeriodicity=" + this.getPaymentPeriodicity() + ", amount=" + this.getAmount() + ", allDurationAmount=" + this.getAllDurationAmount() + ", distributedAmount=" + this.getDistributedAmount() + ", ownerMintingPercentage=" + this.getOwnerMintingPercentage() + ", mintingPower=" + this.getMintingPower() + ", pendingTransactions=" + this.getPendingTransactions() + ", transactionStatus=" + this.getTransactionStatus() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", noticeDate=" + this.getNoticeDate() + ", paidRentsDate=" + this.getPaidRentsDate() + ", createdDate=" + this.getCreatedDate() + ", confirmed=" + this.isConfirmed() + ", enabled=" + this.isEnabled() + ", endingLease=" + this.isEndingLease() + ", endingLeaseAddress=" + this.getEndingLeaseAddress() + ", lastCheckedBlock=" + this.getLastCheckedBlock() + ")";
    }

    public DeedTenantLease(long id, long nftId, DeedCity city, DeedCard cardType, int months, int paidMonths, int noticePeriod, int monthPaymentInProgress, String owner, String manager, String managerEmail, List<String> viewAddresses, RentalPaymentPeriodicity paymentPeriodicity, double amount, double allDurationAmount, double distributedAmount, int ownerMintingPercentage, double mintingPower, List<String> pendingTransactions, TransactionStatus transactionStatus, Instant startDate, Instant endDate, Instant noticeDate, Instant paidRentsDate, Instant createdDate, boolean confirmed, boolean enabled, boolean endingLease, String endingLeaseAddress, long lastCheckedBlock) {
        this.id = id;
        this.nftId = nftId;
        this.city = city;
        this.cardType = cardType;
        this.months = months;
        this.paidMonths = paidMonths;
        this.noticePeriod = noticePeriod;
        this.monthPaymentInProgress = monthPaymentInProgress;
        this.owner = owner;
        this.manager = manager;
        this.managerEmail = managerEmail;
        this.viewAddresses = viewAddresses;
        this.paymentPeriodicity = paymentPeriodicity;
        this.amount = amount;
        this.allDurationAmount = allDurationAmount;
        this.distributedAmount = distributedAmount;
        this.ownerMintingPercentage = ownerMintingPercentage;
        this.mintingPower = mintingPower;
        this.pendingTransactions = pendingTransactions;
        this.transactionStatus = transactionStatus;
        this.startDate = startDate;
        this.endDate = endDate;
        this.noticeDate = noticeDate;
        this.paidRentsDate = paidRentsDate;
        this.createdDate = createdDate;
        this.confirmed = confirmed;
        this.enabled = enabled;
        this.endingLease = endingLease;
        this.endingLeaseAddress = endingLeaseAddress;
        this.lastCheckedBlock = lastCheckedBlock;
    }

    public DeedTenantLease() {
    }
}

