/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest;

import io.meeds.deeds.constant.DeedCard;
import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.constant.UnauthorizedOperationException;
import io.meeds.deeds.model.DeedTenantLeaseDTO;
import io.meeds.deeds.model.LeaseFilter;
import io.meeds.deeds.service.AuthorizationCodeService;
import io.meeds.deeds.service.LeaseService;
import java.security.Principal;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/leases"})
public class LeaseController {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseController.class);
    @Autowired
    private LeaseService leaseService;
    @Autowired
    private AuthorizationCodeService authorizationCodeService;

    @GetMapping
    public PagedModel<EntityModel<DeedTenantLeaseDTO>> getLeases(Pageable pageable, PagedResourcesAssembler<DeedTenantLeaseDTO> assembler, @RequestParam(name="nftId", required=false) Long nftId, @RequestParam(name="cardType", required=false) List<DeedCard> cardTypes, @RequestParam(name="onlyConfirmed", required=false) boolean onlyConfirmed, @RequestParam(name="address", required=true) String address, @RequestParam(name="owner", required=true) boolean owner, @RequestParam(name="networkId", required=true) long networkId) {
        LeaseFilter leaseFilter = new LeaseFilter();
        if (nftId != null && nftId > 0L) {
            leaseFilter.setNftId(nftId);
        }
        leaseFilter.setExcludeNotConfirmed(onlyConfirmed);
        leaseFilter.setCardTypes(cardTypes);
        leaseFilter.setNetworkId(networkId);
        leaseFilter.setCurrentAddress(StringUtils.lowerCase((String)address));
        leaseFilter.setOwner(owner);
        Page<DeedTenantLeaseDTO> leases = this.leaseService.getLeases(leaseFilter, pageable);
        return assembler.toModel(leases);
    }

    @GetMapping(value={"/{leaseId}"})
    public DeedTenantLeaseDTO getLease(Principal principal, @RequestHeader(name="X-REFRESH", required=false) boolean refreshFromBlockchain, @PathVariable(name="leaseId", required=true) long leaseId) {
        String walletAddress = principal == null ? null : principal.getName();
        try {
            DeedTenantLeaseDTO lease = this.leaseService.getLease(leaseId, walletAddress, refreshFromBlockchain);
            if (lease == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND);
            }
            return lease;
        }
        catch (ObjectNotFoundException | UnauthorizedOperationException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOG.warn("Error retrieving lease by id {} and blockchainStateRefresh = {}", new Object[]{leaseId, refreshFromBlockchain, e});
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(consumes={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"USER"})
    public DeedTenantLeaseDTO createLease(Principal principal, @RequestHeader(name="X-AUTHORIZATION", required=true) int code, @RequestParam(name="offerId", required=true) String offerId, @RequestParam(name="transactionHash", required=true) String transactionHash) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName())) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
        String walletAddress = StringUtils.lowerCase((String)principal.getName());
        try {
            String email = (String)this.authorizationCodeService.validateAndGetData(walletAddress, code);
            return this.leaseService.createLease(walletAddress, email, offerId, transactionHash);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        catch (UnauthorizedOperationException | IllegalAccessException e) {
            LOG.warn("[SECURITY ALERT] {} attempts to create Deed tenant lease while not allowed based on offerId {} and transactionHash {}", new Object[]{walletAddress, offerId, transactionHash, e});
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
    }

    @PatchMapping(path={"/{leaseId}"}, consumes={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"USER"})
    public DeedTenantLeaseDTO payRent(Principal principal, @PathVariable(name="leaseId", required=true) long leaseId, @RequestParam(name="ownerAddress", required=true) String ownerAddress, @RequestParam(name="paidMonths", required=true) int paidMonths, @RequestParam(name="transactionHash", required=true) String transactionHash) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName())) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
        if (leaseId <= 0L) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Lease id is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)ownerAddress)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Owner Address is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Transaction hash is mandatory");
        }
        if (paidMonths == 0) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Paid months is mandatory");
        }
        String walletAddress = StringUtils.lowerCase((String)principal.getName());
        try {
            return this.leaseService.payRents(walletAddress, ownerAddress, leaseId, paidMonths, transactionHash);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        catch (UnauthorizedOperationException e) {
            LOG.warn("[SECURITY ALERT] {} attempts to indicate a rent pay for a tenant lease while not allowed based on leaseId {} and transactionHash {}", new Object[]{walletAddress, leaseId, transactionHash, e});
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
    }

    @DeleteMapping(path={"/{leaseId}"}, consumes={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"USER"})
    public DeedTenantLeaseDTO endLease(Principal principal, @PathVariable(name="leaseId", required=true) long leaseId, @RequestParam(name="transactionHash", required=true) String transactionHash) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName())) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
        if (leaseId <= 0L) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Lease id is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Transaction hash is mandatory");
        }
        String walletAddress = StringUtils.lowerCase((String)principal.getName());
        try {
            return this.leaseService.endLease(walletAddress, leaseId, transactionHash);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        catch (UnauthorizedOperationException e) {
            LOG.warn("[SECURITY ALERT] {} attempts to indicate a lease end while not allowed based on leaseId {} and transactionHash {}", new Object[]{walletAddress, leaseId, transactionHash, e});
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
    }
}

