/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.utils;

import io.meeds.dapp.web.utils.EnvironmentService;
import jakarta.servlet.http.HttpSession;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private static final String HOST_ENVIRONMENT_PARAM = "meeds.deed.hostEnvironment";
    private static final String HOST_ENVIRONMENT_PRODUCTION = "production";
    private static final String HOST_ENVIRONMENT_TEST = "test";
    private static final String EXTENDED_HTML_CONTENT_PATH_PARAM = "meeds.deed.extendedHtmlContent.path";
    private static final String APPLICATION_BUILD_NUMBER_PARAM = "application.buildNumber";
    private static final String LOGIN_MESSAGE_ATTRIBUTE_NAME = "login_message";
    private static final Random RANDOM = new Random();
    private static String buildNumber;
    private static String hostEnvironment;

    private Utils() {
    }

    public static String generateLoginMessage(HttpSession session) {
        Object token = Utils.getLoginMessage(session);
        if (token == null) {
            token = RANDOM.nextLong() + "-" + RANDOM.nextLong() + "-" + RANDOM.nextLong();
            session.setAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME, token);
        }
        return token;
    }

    public static String getLoginMessage(HttpSession session) {
        return session == null ? null : (String)session.getAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME);
    }

    public static String getApplicationBuildNumber() {
        if (StringUtils.isBlank((CharSequence)buildNumber)) {
            buildNumber = EnvironmentService.getEnvironment().getProperty(APPLICATION_BUILD_NUMBER_PARAM, "");
        }
        return buildNumber;
    }

    public static boolean isProductionEnvironment() {
        if (hostEnvironment == null && StringUtils.isBlank((CharSequence)(hostEnvironment = EnvironmentService.getEnvironment().getProperty(HOST_ENVIRONMENT_PARAM, "")))) {
            String extFilePath = EnvironmentService.getEnvironment().getProperty(EXTENDED_HTML_CONTENT_PATH_PARAM, "");
            hostEnvironment = StringUtils.isNotBlank((CharSequence)extFilePath) && Files.exists(Paths.get(extFilePath, new String[0]), new LinkOption[0]) ? HOST_ENVIRONMENT_PRODUCTION : HOST_ENVIRONMENT_TEST;
        }
        return StringUtils.equals((CharSequence)hostEnvironment, (CharSequence)HOST_ENVIRONMENT_PRODUCTION);
    }
}

