/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.service;

import io.meeds.dapp.constant.Currency;
import io.meeds.dapp.elasticsearch.model.CurrencyExchangeRate;
import io.meeds.dapp.elasticsearch.model.MeedExchangeRate;
import io.meeds.dapp.model.MeedPrice;
import io.meeds.dapp.service.ExchangeService;
import io.meeds.dapp.storage.CurrencyExchangeRateRepository;
import io.meeds.dapp.storage.MeedExchangeRateRepository;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.stereotype.Component;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={ExchangeServiceNoInit.class})
@TestPropertySource(properties={"meeds.exchange.currencyApiUrl=CurrencyApiUrl", "meeds.exchange.currencyApiKey=CurrencyApiKey", "meeds.exchange.blockchainApiUrl=BlockchainApiUrl", "meeds.exchange.lpTokenApiUrl=LpTokenApiUrl", "meeds.exchange.lpTokenAddress=LpTokenAddress"})
class ExchangeServiceTest {
    @MockBean
    private CurrencyExchangeRateRepository currencyExchangeRateRepository;
    @MockBean
    private MeedExchangeRateRepository meedExchangeRateRepository;
    @Autowired
    private ExchangeServiceNoInit exchangeService;

    ExchangeServiceTest() {
    }

    @BeforeEach
    void init() {
        Mockito.reset((Object[])new ElasticsearchRepository[]{this.currencyExchangeRateRepository, this.meedExchangeRateRepository});
    }

    @Test
    void testComputeTodayCurrencyExchangeRate() {
        Assertions.assertNotNull((Object)((Object)this.exchangeService));
        this.exchangeService.computeTodayCurrencyExchangeRate();
        ((CurrencyExchangeRateRepository)Mockito.verify((Object)this.currencyExchangeRateRepository, (VerificationMode)Mockito.times((int)1))).save((CurrencyExchangeRate)ArgumentMatchers.any());
    }

    @Test
    void testComputeCurrencyExchangeRate() {
        Assertions.assertNotNull((Object)((Object)this.exchangeService));
        this.exchangeService.computeCurrencyExchangeRate();
        Duration between = Duration.between(this.exchangeService.firstMeedTokenDate().atStartOfDay(), LocalDate.now().atStartOfDay());
        ((CurrencyExchangeRateRepository)Mockito.verify((Object)this.currencyExchangeRateRepository, (VerificationMode)Mockito.times((int)((int)between.toDays() + 2)))).save((CurrencyExchangeRate)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<CurrencyExchangeRate>(this){

            public boolean matches(CurrencyExchangeRate argument) {
                return BigDecimal.valueOf(1.8).equals(argument.getRate()) && argument.getCurrency() == Currency.EUR;
            }
        }));
        ((CurrencyExchangeRateRepository)Mockito.verify((Object)this.currencyExchangeRateRepository, (VerificationMode)Mockito.times((int)1))).save(new CurrencyExchangeRate(this.exchangeService.firstMeedTokenDate(), Currency.EUR, BigDecimal.valueOf(1.8)));
    }

    @Test
    void testComputeMeedExchangeRate() {
        Assertions.assertNotNull((Object)((Object)this.exchangeService));
        this.exchangeService.computeMeedExchangeRate();
        Duration between = Duration.between(this.exchangeService.firstMeedTokenDate().atStartOfDay(), LocalDate.now().atStartOfDay());
        ((MeedExchangeRateRepository)Mockito.verify((Object)this.meedExchangeRateRepository, (VerificationMode)Mockito.times((int)((int)between.toDays() + 1)))).save((MeedExchangeRate)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<MeedExchangeRate>(this){

            public boolean matches(MeedExchangeRate argument) {
                return argument != null && argument.getDate() != null && BigDecimal.valueOf(300L).equals(argument.getEthReserve()) && BigDecimal.valueOf(200L).equals(argument.getMeedReserve()) && BigDecimal.valueOf(2L).equals(argument.getMeedEthPrice()) && BigDecimal.valueOf(3L).equals(argument.getEthUsdPrice());
            }
        }));
        ((MeedExchangeRateRepository)Mockito.verify((Object)this.meedExchangeRateRepository, (VerificationMode)Mockito.times((int)1))).save(new MeedExchangeRate(this.exchangeService.firstMeedTokenDate(), BigDecimal.valueOf(3L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(300L), true));
        ((MeedExchangeRateRepository)Mockito.verify((Object)this.meedExchangeRateRepository, (VerificationMode)Mockito.times((int)1))).save(new MeedExchangeRate(LocalDate.now(), BigDecimal.valueOf(3L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(300L), false));
    }

    @Test
    void testGetExchangeRates() {
        Assertions.assertNotNull((Object)((Object)this.exchangeService));
        this.mockExchangeRates();
        List exchangeRates = this.exchangeService.getExchangeRates(Currency.ETH, LocalDate.now().minusDays(2L), LocalDate.now());
        Assertions.assertNotNull((Object)exchangeRates);
        Assertions.assertEquals((int)3, (int)exchangeRates.size());
        MeedPrice meedPrice = (MeedPrice)exchangeRates.get(0);
        Assertions.assertNotNull((Object)meedPrice);
        Assertions.assertEquals((Object)LocalDate.now().minusDays(2L), (Object)meedPrice.getDate());
        Assertions.assertEquals((Object)BigDecimal.valueOf(2L), (Object)meedPrice.getEthPrice());
        Assertions.assertEquals((Object)BigDecimal.valueOf(2L), (Object)meedPrice.getCurrencyPrice());
        exchangeRates = this.exchangeService.getExchangeRates(Currency.USD, LocalDate.now().minusDays(2L), LocalDate.now());
        Assertions.assertNotNull((Object)exchangeRates);
        Assertions.assertEquals((int)3, (int)exchangeRates.size());
        meedPrice = (MeedPrice)exchangeRates.get(0);
        Assertions.assertEquals((Object)new MeedPrice(LocalDate.now().minusDays(2L), BigDecimal.valueOf(2L), BigDecimal.valueOf(6L)), (Object)meedPrice);
        exchangeRates = this.exchangeService.getExchangeRates(Currency.EUR, LocalDate.now().minusDays(2L), LocalDate.now());
        Assertions.assertNotNull((Object)exchangeRates);
        Assertions.assertEquals((int)3, (int)exchangeRates.size());
        meedPrice = (MeedPrice)exchangeRates.get(0);
        Assertions.assertEquals((Object)new MeedPrice(LocalDate.now().minusDays(2L), BigDecimal.valueOf(2L), BigDecimal.valueOf(10.8)), (Object)meedPrice);
        Assertions.assertEquals((int)new MeedPrice(LocalDate.now().minusDays(2L), BigDecimal.valueOf(2L), BigDecimal.valueOf(10.8)).hashCode(), (int)meedPrice.hashCode());
    }

    @Test
    void testGetExchangeRate() {
        Assertions.assertNotNull((Object)((Object)this.exchangeService));
        this.mockExchangeRates();
        BigDecimal usdExchangeRate = this.exchangeService.getExchangeRate(Currency.USD);
        Assertions.assertEquals((Object)BigDecimal.ONE, (Object)usdExchangeRate);
        usdExchangeRate = this.exchangeService.getExchangeRate(null);
        Assertions.assertEquals((Object)BigDecimal.ONE, (Object)usdExchangeRate);
        BigDecimal ethExchangeRate = this.exchangeService.getExchangeRate(Currency.ETH);
        Assertions.assertEquals((Object)new BigDecimal("0.333333333333333333"), (Object)ethExchangeRate);
        BigDecimal eurExchangeRate = this.exchangeService.getExchangeRate(Currency.EUR);
        Assertions.assertEquals((Object)BigDecimal.valueOf(1.8), (Object)eurExchangeRate);
    }

    @Test
    void testGetMeedUsdPrice() {
        Assertions.assertNotNull((Object)((Object)this.exchangeService));
        ArrayList meedExchangeRates = new ArrayList();
        Mockito.when((Object)this.meedExchangeRateRepository.save((MeedExchangeRate)ArgumentMatchers.any())).thenAnswer(invocation -> {
            MeedExchangeRate exchangeRate = (MeedExchangeRate)invocation.getArgument(0, MeedExchangeRate.class);
            meedExchangeRates.add(exchangeRate);
            return exchangeRate;
        });
        this.exchangeService.computeMeedExchangeRate();
        Mockito.when((Object)this.meedExchangeRateRepository.findByDateBetween((LocalDate)ArgumentMatchers.any(), (LocalDate)ArgumentMatchers.any())).thenAnswer(invocation -> {
            LocalDate fromDate = (LocalDate)invocation.getArgument(0, LocalDate.class);
            LocalDate toDate = (LocalDate)invocation.getArgument(1, LocalDate.class);
            return meedExchangeRates.stream().filter(meedExchangeRate -> !(!meedExchangeRate.getDate().isAfter(fromDate) && !meedExchangeRate.getDate().isEqual(fromDate) || !meedExchangeRate.getDate().isBefore(toDate) && !meedExchangeRate.getDate().isEqual(toDate))).collect(Collectors.toList());
        });
        BigDecimal price = this.exchangeService.getMeedUsdPrice();
        Assertions.assertEquals((Object)BigDecimal.valueOf(6L), (Object)price);
    }

    private void mockExchangeRates() {
        ArrayList currencyExchangeRates = new ArrayList();
        ArrayList meedExchangeRates = new ArrayList();
        Mockito.when((Object)this.meedExchangeRateRepository.save((MeedExchangeRate)ArgumentMatchers.any())).thenAnswer(invocation -> {
            MeedExchangeRate exchangeRate = (MeedExchangeRate)invocation.getArgument(0, MeedExchangeRate.class);
            meedExchangeRates.add(exchangeRate);
            return exchangeRate;
        });
        Mockito.when((Object)this.currencyExchangeRateRepository.save((CurrencyExchangeRate)ArgumentMatchers.any())).thenAnswer(invocation -> {
            CurrencyExchangeRate exchangeRate = (CurrencyExchangeRate)invocation.getArgument(0, CurrencyExchangeRate.class);
            currencyExchangeRates.add(exchangeRate);
            return exchangeRate;
        });
        this.exchangeService.computeMeedExchangeRate();
        this.exchangeService.computeCurrencyExchangeRate();
        Mockito.when((Object)this.currencyExchangeRateRepository.findByCurrencyAndDateBetween((Currency)ArgumentMatchers.any(), (LocalDate)ArgumentMatchers.any(), (LocalDate)ArgumentMatchers.any())).thenAnswer(invocation -> {
            LocalDate fromDate = (LocalDate)invocation.getArgument(1, LocalDate.class);
            LocalDate toDate = (LocalDate)invocation.getArgument(2, LocalDate.class);
            return currencyExchangeRates.stream().filter(currencyExchangeRate -> !(!currencyExchangeRate.getDate().isAfter(fromDate) && !currencyExchangeRate.getDate().isEqual(fromDate) || !currencyExchangeRate.getDate().isBefore(toDate) && !currencyExchangeRate.getDate().isEqual(toDate))).collect(Collectors.toList());
        });
        Mockito.when((Object)this.meedExchangeRateRepository.findByDateBetween((LocalDate)ArgumentMatchers.any(), (LocalDate)ArgumentMatchers.any())).thenAnswer(invocation -> {
            LocalDate fromDate = (LocalDate)invocation.getArgument(0, LocalDate.class);
            LocalDate toDate = (LocalDate)invocation.getArgument(1, LocalDate.class);
            return meedExchangeRates.stream().filter(meedExchangeRate -> !(!meedExchangeRate.getDate().isAfter(fromDate) && !meedExchangeRate.getDate().isEqual(fromDate) || !meedExchangeRate.getDate().isBefore(toDate) && !meedExchangeRate.getDate().isEqual(toDate))).collect(Collectors.toList());
        });
    }

    @Component
    public static class ExchangeServiceNoInit
    extends ExchangeService {
        private AtomicBoolean ethPriceRequest = new AtomicBoolean(false);
        private AtomicBoolean simulateErrorRequest = new AtomicBoolean(false);

        public void computeRates() {
        }

        protected String executeQuery(String url, String body) {
            this.ethPriceRequest.set(StringUtils.contains((CharSequence)body, (CharSequence)"ethPrice"));
            if (StringUtils.contains((CharSequence)body, (CharSequence)"block:")) {
                this.simulateErrorRequest.set(!this.simulateErrorRequest.get());
            }
            return super.executeQuery(url, body);
        }

        protected HttpsURLConnection newURLConnection(String apiUrl) throws IOException {
            if (StringUtils.contains((CharSequence)apiUrl, (CharSequence)"CurrencyApiUrl")) {
                HttpsURLConnection connection = (HttpsURLConnection)Mockito.mock(HttpsURLConnection.class);
                Mockito.when((Object)connection.getResponseCode()).thenReturn((Object)200);
                Mockito.when((Object)connection.getInputStream()).thenReturn((Object)new ByteArrayInputStream("{\"data\": {\"EUR\": {\"value\": 1.8}}}".getBytes()));
                return connection;
            }
            if (StringUtils.contains((CharSequence)apiUrl, (CharSequence)"BlockchainApiUrl")) {
                HttpsURLConnection connection = (HttpsURLConnection)Mockito.mock(HttpsURLConnection.class);
                Mockito.when((Object)connection.getResponseCode()).thenReturn((Object)200);
                Mockito.when((Object)connection.getOutputStream()).thenReturn((Object)((OutputStream)Mockito.mock(OutputStream.class)));
                Mockito.when((Object)connection.getInputStream()).thenReturn((Object)new ByteArrayInputStream("{\"data\": {\"blocks\": [{\"number\": \"1111\"}]}}".getBytes()));
                return connection;
            }
            if (StringUtils.contains((CharSequence)apiUrl, (CharSequence)"LpTokenApiUrl") && this.simulateErrorRequest.get()) {
                HttpsURLConnection connection = (HttpsURLConnection)Mockito.mock(HttpsURLConnection.class);
                Mockito.when((Object)connection.getResponseCode()).thenReturn((Object)200);
                Mockito.when((Object)connection.getOutputStream()).thenReturn((Object)((OutputStream)Mockito.mock(OutputStream.class)));
                Mockito.when((Object)connection.getInputStream()).thenReturn((Object)new ByteArrayInputStream("{\"errors\": [{\"message\": \"Error: up to block number 1000 .\"}]}".getBytes()));
                return connection;
            }
            if (StringUtils.contains((CharSequence)apiUrl, (CharSequence)"LpTokenApiUrl") && this.ethPriceRequest.get()) {
                HttpsURLConnection connection = (HttpsURLConnection)Mockito.mock(HttpsURLConnection.class);
                Mockito.when((Object)connection.getResponseCode()).thenReturn((Object)200);
                Mockito.when((Object)connection.getOutputStream()).thenReturn((Object)((OutputStream)Mockito.mock(OutputStream.class)));
                Mockito.when((Object)connection.getInputStream()).thenReturn((Object)new ByteArrayInputStream("{\"data\": {\"bundle\": {\"ethPrice\": \"3\"}}}".getBytes()));
                return connection;
            }
            if (StringUtils.contains((CharSequence)apiUrl, (CharSequence)"LpTokenApiUrl")) {
                HttpsURLConnection connection = (HttpsURLConnection)Mockito.mock(HttpsURLConnection.class);
                Mockito.when((Object)connection.getResponseCode()).thenReturn((Object)200);
                Mockito.when((Object)connection.getOutputStream()).thenReturn((Object)((OutputStream)Mockito.mock(OutputStream.class)));
                Mockito.when((Object)connection.getInputStream()).thenReturn((Object)new ByteArrayInputStream("{\"data\": {\"pair\": {\"token1Price\": \"2\", \"reserve0\": \"200\", \"reserve1\": \"300\"}}}".getBytes()));
                return connection;
            }
            return super.newURLConnection(apiUrl);
        }

        protected LocalDate firstMeedTokenDate() {
            return LocalDate.now().minusDays(3L);
        }
    }
}

