/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.listener;

import io.meeds.deeds.common.constant.CommonConstants;
import io.meeds.deeds.common.listener.EventListener;
import io.meeds.deeds.common.service.LeaseService;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeaseDeedOwnershipTransferredListener
implements EventListener<CommonConstants.DeedOwnershipTransferEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseDeedOwnershipTransferredListener.class);
    public static final String LISTENER_NAME = "DeedOwnershipTransferredLeaseListener";
    private static final List<String> SUPPORTED_EVENTS = Collections.singletonList("deed.event.transferOwnershipFromDeedTenant");
    @Autowired
    private LeaseService leaseService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, CommonConstants.DeedOwnershipTransferEvent ownershipTransferEvent) {
        String newOnwer;
        String oldOwner = ownershipTransferEvent.getFrom();
        if (StringUtils.equalsIgnoreCase((CharSequence)oldOwner, (CharSequence)(newOnwer = ownershipTransferEvent.getTo()))) {
            return;
        }
        long nftId = ownershipTransferEvent.getNftId();
        try {
            this.leaseService.transferDeedOwnership(newOnwer, nftId);
        }
        catch (Exception e) {
            LOG.warn("Owner modification on current leases for new owner {} had failed", (Object)newOnwer, (Object)e);
        }
    }
}

