/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.rest;

import io.meeds.dapp.web.rest.model.HubWithReward;
import io.meeds.dapp.web.rest.utils.EntityBuilder;
import io.meeds.deeds.common.model.FileBinary;
import io.meeds.deeds.common.service.HubReportService;
import io.meeds.deeds.common.service.HubService;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import io.meeds.wom.api.constant.WomAuthorizationException;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.constant.WomParsingException;
import io.meeds.wom.api.constant.WomRequestException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.HubUpdateRequest;
import io.meeds.wom.api.model.WomConnectionRequest;
import io.meeds.wom.api.model.WomConnectionResponse;
import io.meeds.wom.api.model.WomDisconnectionRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/hubs"})
public class HubController {
    private static final String WOM_UNKNOWN_ERROR_MESSAGE = "wom.unknownError:";
    private static final Logger LOG = LoggerFactory.getLogger(HubController.class);
    private static final String WOM_CONNECTION_LOG_MESSAGE = "WOM-CONNECTION-FAIL: {}: An error happened when trying to connect to the WoM";
    private static final String WOM_DISCONNECTION_LOG_MESSAGE = "WOM-DISCONNECTION-FAIL: {}: An error happened when trying to disconnect from the WoM";
    @Autowired
    private HubService hubService;
    @Autowired
    private HubReportService hubReportService;

    @GetMapping
    public ResponseEntity<PagedModel<EntityModel<HubWithReward>>> getHubs(Pageable pageable, PagedResourcesAssembler<HubWithReward> assembler, @RequestParam(name="rewardId", required=false, defaultValue="0") long rewardId) {
        Page hubs = this.hubService.getHubs(rewardId, pageable);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)assembler.toModel(hubs.map(hub -> EntityBuilder.decorateHubWithReward(hub, this.hubReportService))));
    }

    @GetMapping(value={"/{hubAddress}"})
    public ResponseEntity<Hub> getHub(@PathVariable(name="hubAddress") String hubAddress, @RequestParam(name="forceRefresh", required=false) boolean forceRefresh) {
        Hub hub = this.hubService.getHub(hubAddress, forceRefresh);
        if (hub == null) {
            return ResponseEntity.notFound().build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)EntityBuilder.decorateHubWithReward(hub, this.hubReportService));
    }

    @GetMapping(value={"/managed-deeds/{managerAddress}"})
    public ResponseEntity<Object> getManagedDeeds(@PathVariable(name="managerAddress") String managerAddress) {
        List deeds = this.hubService.getManagedDeeds(managerAddress);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)deeds);
    }

    @PostMapping(value={"/{hubAddress}/avatar"})
    public void saveHubAvatar(@PathVariable(name="hubAddress") String hubAddress, @RequestParam(value="signedMessage") String signedMessage, @RequestParam(value="rawMessage") String rawMessage, @RequestParam(value="token") String token, @RequestParam(value="file") MultipartFile file) {
        try {
            this.hubService.saveHubAvatar(hubAddress, signedMessage, rawMessage, token, file);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (WomException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (IOException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "wom.errorReadingFile:" + e.getMessage());
        }
    }

    @GetMapping(value={"/{hubAddress}/avatar"})
    public ResponseEntity<InputStreamResource> getHubAvatar(@PathVariable(name="hubAddress") String hubAddress, @RequestParam(name="v", required=false) String lastUpdated) {
        return this.getFileResponse(this.hubService.getHubAvatar(hubAddress), lastUpdated);
    }

    @PostMapping
    public ResponseEntity<Object> connectToWom(@RequestBody WomConnectionRequest hubConnectionRequest) {
        try {
            WomConnectionResponse connectionResponse = this.hubService.connectToWom(hubConnectionRequest);
            return ResponseEntity.ok((Object)connectionResponse);
        }
        catch (WomParsingException | WomRequestException e) {
            LOG.info(WOM_CONNECTION_LOG_MESSAGE, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getErrorCode());
        }
        catch (WomAuthorizationException e) {
            LOG.info(WOM_CONNECTION_LOG_MESSAGE, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getErrorCode());
        }
        catch (WomException e) {
            LOG.info(WOM_CONNECTION_LOG_MESSAGE, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getErrorCode());
        }
        catch (Exception e) {
            LOG.warn("An unkown error happened when trying to process the connection request", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)(WOM_UNKNOWN_ERROR_MESSAGE + e.getMessage()));
        }
    }

    @PutMapping
    public ResponseEntity<Object> updateHub(@RequestBody HubUpdateRequest hubUpdateRequest) {
        try {
            this.hubService.updateHub(hubUpdateRequest);
            return ResponseEntity.noContent().build();
        }
        catch (WomParsingException | WomRequestException e) {
            LOG.info(WOM_CONNECTION_LOG_MESSAGE, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getErrorCode());
        }
        catch (WomAuthorizationException e) {
            LOG.info(WOM_CONNECTION_LOG_MESSAGE, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getErrorCode());
        }
        catch (WomException e) {
            LOG.info(WOM_CONNECTION_LOG_MESSAGE, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getErrorCode());
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("An unkown error happened when trying to process the refresh Hub request", (Throwable)e);
            } else {
                LOG.warn("An unkown error happened when trying to process the refresh Hub request: {}", (Object)e.getMessage());
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)(WOM_UNKNOWN_ERROR_MESSAGE + e.getMessage()));
        }
    }

    @DeleteMapping
    public ResponseEntity<Object> disconnectFromWom(@RequestBody WomDisconnectionRequest disconnectionRequest) {
        try {
            String womAddress = this.hubService.disconnectFromWom(disconnectionRequest);
            return ResponseEntity.ok((Object)womAddress);
        }
        catch (WomParsingException | WomRequestException e) {
            LOG.info(WOM_DISCONNECTION_LOG_MESSAGE, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getErrorCode());
        }
        catch (WomAuthorizationException e) {
            LOG.info(WOM_DISCONNECTION_LOG_MESSAGE, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getErrorCode());
        }
        catch (WomException e) {
            LOG.info(WOM_DISCONNECTION_LOG_MESSAGE, (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getErrorCode());
        }
        catch (Exception e) {
            LOG.warn("An unkown error happened when trying to process the disconnection request", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)(WOM_UNKNOWN_ERROR_MESSAGE + e.getMessage()));
        }
    }

    @GetMapping(value={"/byNftId/{nftId}"})
    public ResponseEntity<Hub> getHubByNftId(@PathVariable(name="nftId") long nftId) {
        Hub hub = this.hubService.getHub(Long.valueOf(nftId));
        if (hub == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)hub);
    }

    @GetMapping(value={"/token"})
    public String generateToken(HttpServletRequest request) {
        String clientIp = request.getHeader("X-FORWARDED-FOR");
        if (clientIp == null) {
            clientIp = request.getRemoteAddr();
        }
        return this.hubService.generateToken(clientIp);
    }

    private ResponseEntity<InputStreamResource> getFileResponse(FileBinary file, String lastUpdated) {
        if (file == null) {
            return ResponseEntity.notFound().build();
        }
        ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
        if (StringUtils.isBlank((CharSequence)lastUpdated)) {
            builder.cacheControl(CacheControl.noStore());
        } else {
            builder.cacheControl(CacheControl.maxAge((Duration)Duration.ofDays(365L)).cachePublic());
        }
        return ((ResponseEntity.BodyBuilder)builder.lastModified(file.getUpdatedDate())).contentType(MediaType.valueOf((String)file.getMimeType())).body((Object)new InputStreamResource(file.getBinary()));
    }
}

