/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.rest;

import io.meeds.dapp.web.rest.LeaseController;
import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.WebSecurityConfig;
import io.meeds.deeds.common.constant.DeedCard;
import io.meeds.deeds.common.constant.DeedCity;
import io.meeds.deeds.common.constant.NoticePeriod;
import io.meeds.deeds.common.constant.RentalPaymentPeriodicity;
import io.meeds.deeds.common.constant.TenantProvisioningStatus;
import io.meeds.deeds.common.constant.TenantStatus;
import io.meeds.deeds.common.constant.TransactionStatus;
import io.meeds.deeds.common.constant.UnauthorizedOperationException;
import io.meeds.deeds.common.model.DeedTenantLeaseDTO;
import io.meeds.deeds.common.model.LeaseFilter;
import io.meeds.deeds.common.service.AuthorizationCodeService;
import io.meeds.deeds.common.service.LeaseService;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import java.time.Instant;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.security.test.context.support.WithAnonymousUser;
import org.springframework.security.test.context.support.WithMockUser;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={LeaseController.class, DeedAuthenticationProvider.class, WebSecurityConfig.class, DeedAccessDeniedHandler.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
public class LeaseControllerTest {
    private static final String OWNER_ADDRESS_PARAM = "ownerAddress";
    private static final String PAID_MONTHS_PARAM = "paidMonths";
    private static final String OFFER_ID_PARAM = "offerId";
    private static final String TRANSACTION_HASH_PARAM = "transactionHash";
    private static final String EMAIL = "email";
    private static final String USERNAME = "0x609a6f01b7976439603356e41d5456b42df957b7";
    private static final String API_LEASES = "/api/leases";
    @MockBean
    private LeaseService leaseService;
    @MockBean
    private AuthorizationCodeService authorizationCodeService;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;
    private String offerId = "offerId";
    private int code = 564889;
    private long leaseId = 5L;
    private long nftId = 56L;
    private DeedCity city = DeedCity.RESHEF;
    private DeedCard cardType = DeedCard.RARE;
    private boolean onlyConfirmed = true;
    private boolean owner = true;
    private String address = "0x609a6f01b7976439603356e41d5456b42df957b7";
    private TenantStatus tenantStatus = TenantStatus.DEPLOYED;
    private TenantProvisioningStatus provisioningStatus = TenantProvisioningStatus.START_CONFIRMED;
    private int months = 6;
    private int paidMonths = 3;
    private int monthPaymentInProgress = 1;
    private String ownerAddress = "0x530417D6909834f9Ebfe5d98b649433B616Efb38";
    private String managerAddress = "0xB36b174DC531B8055631A4E8d32f44eADC1B9695";
    private RentalPaymentPeriodicity paymentPeriodicity = RentalPaymentPeriodicity.ONE_MONTH;
    private double amount = 56648.36;
    private double allDurationAmount = 89648.36;
    private double distributedAmount = 5.89;
    private NoticePeriod noticePeriod = NoticePeriod.ONE_MONTH;
    private int ownerMintingPercentage = 60;
    private double mintingPower = 1.3;
    private TransactionStatus transactionStatus = TransactionStatus.VALIDATED;
    private Instant startDate = Instant.now();
    private Instant endDate = Instant.now();
    private Instant noticeDate = Instant.now();
    private Instant paidRentsDate = Instant.now();
    private boolean confirmed = true;
    private boolean endingLease = true;
    private String endingLeaseAddress = this.ownerAddress;
    private String transactionHash = "0xef4e9db309b5dd7020ce463ae726b4d0759e1de0635661de91d8d98e83ae2862";

    @BeforeEach
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).apply(SecurityMockMvcConfigurers.springSecurity())).build();
    }

    @Test
    @WithAnonymousUser
    void getLeases() throws Exception {
        Mockito.when((Object)this.leaseService.getLeases((LeaseFilter)ArgumentMatchers.argThat(leaseFilter -> leaseFilter.getNftId() == this.nftId && StringUtils.equals((CharSequence)leaseFilter.getCurrentAddress(), (CharSequence)this.address) && leaseFilter.getOwner() == this.owner && leaseFilter.isExcludeNotConfirmed() == this.onlyConfirmed && !leaseFilter.isIncludeOutdated() && leaseFilter.getCardTypes().get(0) == this.cardType), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(Collections.singletonList(this.newDeedTenantLease())));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)API_LEASES, (Object[])new Object[0]).param("nftId", new String[]{String.valueOf(this.nftId)}).param("cardType", new String[]{this.cardType.name()}).param("onlyConfirmed", new String[]{String.valueOf(this.onlyConfirmed)}).param("owner", new String[]{String.valueOf(this.owner)}).param("address", new String[]{this.address}));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    @WithAnonymousUser
    void getLeaseWhenNotFound() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void getLeaseWhenObjectNotFoundException() throws Exception {
        Mockito.when((Object)this.leaseService.getLease(this.leaseId, null, false)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void getLeaseWhenUnauthorizedOperationException() throws Exception {
        Mockito.when((Object)this.leaseService.getLease(this.leaseId, null, false)).thenThrow(UnauthorizedOperationException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void getLeaseWhenException() throws Exception {
        Mockito.when((Object)this.leaseService.getLease(this.leaseId, null, false)).thenThrow(RuntimeException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    @WithAnonymousUser
    void getLease() throws Exception {
        Mockito.when((Object)this.leaseService.getLease(this.leaseId, null, false)).thenReturn((Object)this.newDeedTenantLease());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    @WithAnonymousUser
    void createLeaseWithAnonymous() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_LEASES, (Object[])new Object[0]).header("X-AUTHORIZATION", new Object[]{String.valueOf(this.code)}).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(OFFER_ID_PARAM, new String[]{this.offerId}).param(TRANSACTION_HASH_PARAM, new String[]{this.transactionHash}));
        response.andExpect(MockMvcResultMatchers.status().is3xxRedirection());
    }

    @Test
    @WithMockUser(username="0x609a6f01b7976439603356e41d5456b42df957b7", authorities={"USER"})
    void createLease() throws Exception {
        Mockito.when((Object)this.authorizationCodeService.validateAndGetData(USERNAME, this.code)).thenReturn((Object)EMAIL);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_LEASES, (Object[])new Object[0]).header("X-AUTHORIZATION", new Object[]{String.valueOf(this.code)}).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(OFFER_ID_PARAM, new String[]{this.offerId}).param(TRANSACTION_HASH_PARAM, new String[]{this.transactionHash}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((LeaseService)Mockito.verify((Object)this.leaseService)).createLease(USERNAME, EMAIL, this.offerId, this.transactionHash);
    }

    @Test
    @WithMockUser(username="0x609a6f01b7976439603356e41d5456b42df957b7", authorities={"USER"})
    void createLeaseWhenIllegalAccessException() throws Exception {
        Mockito.when((Object)this.authorizationCodeService.validateAndGetData(USERNAME, this.code)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_LEASES, (Object[])new Object[0]).header("X-AUTHORIZATION", new Object[]{String.valueOf(this.code)}).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(OFFER_ID_PARAM, new String[]{this.offerId}).param(TRANSACTION_HASH_PARAM, new String[]{this.transactionHash}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    @WithMockUser(username="0x609a6f01b7976439603356e41d5456b42df957b7", authorities={"USER"})
    void createLeaseWhenUnauthorizedOperationException() throws Exception {
        Mockito.when((Object)this.authorizationCodeService.validateAndGetData(USERNAME, this.code)).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.leaseService.createLease(USERNAME, EMAIL, this.offerId, this.transactionHash)).thenThrow(UnauthorizedOperationException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_LEASES, (Object[])new Object[0]).header("X-AUTHORIZATION", new Object[]{String.valueOf(this.code)}).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(OFFER_ID_PARAM, new String[]{this.offerId}).param(TRANSACTION_HASH_PARAM, new String[]{this.transactionHash}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    @WithMockUser(username="0x609a6f01b7976439603356e41d5456b42df957b7", authorities={"USER"})
    void createLeaseWhenObjectNotFoundException() throws Exception {
        Mockito.when((Object)this.authorizationCodeService.validateAndGetData(USERNAME, this.code)).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.leaseService.createLease(USERNAME, EMAIL, this.offerId, this.transactionHash)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_LEASES, (Object[])new Object[0]).header("X-AUTHORIZATION", new Object[]{String.valueOf(this.code)}).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(OFFER_ID_PARAM, new String[]{this.offerId}).param(TRANSACTION_HASH_PARAM, new String[]{this.transactionHash}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void payRentWithAnonymous() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(PAID_MONTHS_PARAM, new String[]{String.valueOf(this.paidMonths)}).param(TRANSACTION_HASH_PARAM, new String[]{String.valueOf(this.transactionHash)}).param(OWNER_ADDRESS_PARAM, new String[]{this.ownerAddress}));
        response.andExpect(MockMvcResultMatchers.status().is3xxRedirection());
    }

    @Test
    @WithMockUser(username="0x609a6f01b7976439603356e41d5456b42df957b7", authorities={"USER"})
    void payRent() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(PAID_MONTHS_PARAM, new String[]{String.valueOf(this.paidMonths)}).param(TRANSACTION_HASH_PARAM, new String[]{String.valueOf(this.transactionHash)}).param(OWNER_ADDRESS_PARAM, new String[]{this.ownerAddress}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((LeaseService)Mockito.verify((Object)this.leaseService)).payRents(USERNAME, this.ownerAddress, this.leaseId, this.paidMonths, this.transactionHash);
    }

    @Test
    @WithMockUser(username="0x609a6f01b7976439603356e41d5456b42df957b7", authorities={"USER"})
    void payRentWhenBadLeaseId() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/leases/0", (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(PAID_MONTHS_PARAM, new String[]{String.valueOf(this.paidMonths)}).param(TRANSACTION_HASH_PARAM, new String[]{String.valueOf(this.transactionHash)}).param(OWNER_ADDRESS_PARAM, new String[]{this.ownerAddress}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithMockUser(username="0x609a6f01b7976439603356e41d5456b42df957b7", authorities={"USER"})
    void payRentWhenBadPaidMonths() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(PAID_MONTHS_PARAM, new String[]{String.valueOf(0)}).param(TRANSACTION_HASH_PARAM, new String[]{String.valueOf(this.transactionHash)}).param(OWNER_ADDRESS_PARAM, new String[]{this.ownerAddress}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithMockUser(username="0x609a6f01b7976439603356e41d5456b42df957b7", authorities={"USER"})
    void payRentWhenUnauthorizedOperationException() throws Exception {
        Mockito.when((Object)this.leaseService.payRents(USERNAME, this.ownerAddress, this.leaseId, this.paidMonths, this.transactionHash)).thenThrow(UnauthorizedOperationException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(PAID_MONTHS_PARAM, new String[]{String.valueOf(this.paidMonths)}).param(TRANSACTION_HASH_PARAM, new String[]{String.valueOf(this.transactionHash)}).param(OWNER_ADDRESS_PARAM, new String[]{this.ownerAddress}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    @WithMockUser(username="0x609a6f01b7976439603356e41d5456b42df957b7", authorities={"USER"})
    void payRentWhenObjectNotFoundException() throws Exception {
        Mockito.when((Object)this.leaseService.payRents(USERNAME, this.ownerAddress, this.leaseId, this.paidMonths, this.transactionHash)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/leases/" + this.leaseId), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED).param(PAID_MONTHS_PARAM, new String[]{String.valueOf(this.paidMonths)}).param(TRANSACTION_HASH_PARAM, new String[]{String.valueOf(this.transactionHash)}).param(OWNER_ADDRESS_PARAM, new String[]{this.ownerAddress}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    public DeedTenantLeaseDTO newDeedTenantLease() {
        return new DeedTenantLeaseDTO(this.leaseId, this.nftId, this.city, this.cardType, this.tenantStatus, this.provisioningStatus, this.months, this.paidMonths, this.monthPaymentInProgress, this.ownerAddress, this.managerAddress, this.paymentPeriodicity, this.amount, this.allDurationAmount, this.distributedAmount, this.noticePeriod, this.ownerMintingPercentage, this.mintingPower, this.transactionStatus, this.startDate, this.endDate, this.noticeDate, this.paidRentsDate, this.confirmed, this.endingLease, this.endingLeaseAddress);
    }
}

