/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.rest;

import io.meeds.dapp.elasticsearch.model.MeedTokenMetric;
import io.meeds.dapp.service.MeedTokenMetricService;
import io.meeds.dapp.web.rest.MeedTokenMetricController;
import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.WebSecurityConfig;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.security.test.context.support.WithAnonymousUser;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={MeedTokenMetricController.class, DeedAuthenticationProvider.class, WebSecurityConfig.class, DeedAccessDeniedHandler.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
class MeedTokenMetricControllerTest {
    @MockBean
    private MeedTokenMetricService meedTokenMetricService;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    MeedTokenMetricControllerTest() {
    }

    @BeforeEach
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).apply(SecurityMockMvcConfigurers.springSecurity())).build();
    }

    @Test
    @WithAnonymousUser
    void testGetLastMetric() throws Exception {
        LocalDate today = LocalDate.now();
        MeedTokenMetric result = new MeedTokenMetric(today, new BigDecimal("1"), Collections.singletonMap("", new BigDecimal("2")), Collections.singletonMap("", new BigDecimal("3")), new BigDecimal("4"), new BigDecimal("5"), new BigDecimal("6"), new BigDecimal("7"));
        Mockito.when((Object)this.meedTokenMetricService.getLastMetric(null)).thenReturn((Object)result);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/token/meed/", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.date", (Matcher)Matchers.is((Object)today.toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.totalSupply", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.lockedBalances", (Matcher)Matchers.aMapWithSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.reserveBalances", (Matcher)Matchers.aMapWithSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.circulatingSupply", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.marketCapitalization", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.totalValuelocked", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.meedUsdPrice", (Matcher)Matchers.is((Object)7)));
    }

    @Test
    @WithAnonymousUser
    void testGetCirculatingSupply() throws Exception {
        BigDecimal circulatingSupply = new BigDecimal("2");
        Mockito.when((Object)this.meedTokenMetricService.getCirculatingSupply()).thenReturn((Object)circulatingSupply);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/token/meed/circ", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    @WithAnonymousUser
    void testGetMarketCapitalization() throws Exception {
        BigDecimal marketCapitalization = new BigDecimal("5");
        Mockito.when((Object)this.meedTokenMetricService.getMarketCapitalization(null)).thenReturn((Object)marketCapitalization);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/token/meed/mcap", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Object)5)));
    }

    @Test
    @WithAnonymousUser
    void testGetTotalLockedValue() throws Exception {
        BigDecimal totalValuelocked = new BigDecimal("4");
        Mockito.when((Object)this.meedTokenMetricService.getTotalValueLocked(null)).thenReturn((Object)totalValuelocked);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/token/meed/tvl", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Object)4)));
    }

    @Test
    @WithAnonymousUser
    void testGetTotalSupply() throws Exception {
        BigDecimal totalSupply = new BigDecimal("3");
        Mockito.when((Object)this.meedTokenMetricService.getTotalSupply()).thenReturn((Object)totalSupply);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/token/meed/supply", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Object)3)));
    }
}

