/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.rest;

import io.meeds.dapp.service.DeedMetadataService;
import io.meeds.dapp.web.rest.model.DeedMetadataPresentation;
import io.meeds.dapp.web.rest.utils.EntityBuilder;
import io.meeds.deeds.common.elasticsearch.model.DeedMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/deeds"})
public class DeedMetadataController {
    @Autowired
    private DeedMetadataService deedMetadataService;

    @GetMapping
    public ResponseEntity<DeedMetadataPresentation> getContractMetadata() {
        DeedMetadata deedMetadata = this.deedMetadataService.getContractMetadata();
        return EntityBuilder.getDeedMetadataResponse(deedMetadata);
    }

    @GetMapping(value={"/{nftId}"})
    public ResponseEntity<DeedMetadataPresentation> getNftMetadata(@PathVariable(name="nftId") Long nftId) {
        DeedMetadata deedMetadata = this.deedMetadataService.getDeedMetadata(nftId);
        return EntityBuilder.getDeedMetadataResponse(deedMetadata);
    }

    @GetMapping(value={"/type/{cityIndex}/{cardType}"})
    public ResponseEntity<DeedMetadataPresentation> getNftMetadata(@PathVariable(name="cityIndex") short cityIndex, @PathVariable(name="cardType") short cardType) {
        DeedMetadata deedMetadata = this.deedMetadataService.getDeedMetadataOfCard(cityIndex, cardType);
        return EntityBuilder.getDeedMetadataResponse(deedMetadata);
    }
}

