/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.rest;

import io.meeds.dapp.web.rest.UemRewardController;
import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.WebSecurityConfig;
import io.meeds.deeds.common.service.UemRewardService;
import io.meeds.wom.api.model.UemReward;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.test.context.support.WithAnonymousUser;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={UemRewardController.class, DeedAuthenticationProvider.class, WebSecurityConfig.class, DeedAccessDeniedHandler.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
public class UemRewardControllerTest {
    private static final String API_UEM_REWARDS = "/api/uem/rewards";
    @MockBean
    private UemRewardService rewardService;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;
    private String hubAddress = "0x27d282d1e7e790df596f50a234602d9e761d22aa";
    private Set<String> hubAddresses = Collections.singleton(this.hubAddress);
    private long rewardId = 255648L;
    private double amount = 53364.23;
    private double fixedGlobalIndex = 56.3669845;
    private Instant fromDate = Instant.now();
    private Instant toDate = Instant.now();
    private List<Long> reportIds = Collections.singletonList(2L);
    private double sumEd = 655893.25;

    @BeforeEach
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).apply(SecurityMockMvcConfigurers.springSecurity())).build();
    }

    @Test
    @WithAnonymousUser
    void getRewards() throws Exception {
        Mockito.when((Object)this.rewardService.getRewards((String)ArgumentMatchers.eq((Object)this.hubAddress), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(Arrays.asList(this.newUemReward())));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)API_UEM_REWARDS, (Object[])new Object[0]).param("hubAddress", new String[]{this.hubAddress}));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    @WithAnonymousUser
    void getReward() throws Exception {
        Mockito.when((Object)this.rewardService.getRewardById(this.rewardId)).thenReturn((Object)this.newUemReward());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/uem/rewards/" + this.rewardId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardId", (Matcher)Matchers.is((Object)((int)this.rewardId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.amount", (Matcher)Matchers.is((Object)this.amount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.fixedGlobalIndex", (Matcher)Matchers.is((Object)this.fixedGlobalIndex))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.reportsCount", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sumEd", (Matcher)Matchers.is((Object)this.sumEd)));
    }

    private UemReward newUemReward() {
        return new UemReward(this.rewardId, this.amount, this.fixedGlobalIndex, this.fromDate, this.toDate, this.reportIds, this.hubAddresses, this.sumEd);
    }
}

