/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeedsExchangeServlet
extends HttpServlet {
    private static final long serialVersionUID = -4130223673549168957L;
    private static final Logger LOG = LoggerFactory.getLogger(MeedsExchangeServlet.class);
    private static final String PAIR_ADDRESS = "0x960bd61d0b960b107ff5309a2dcced4705567070";
    private static final Pattern LATEST_BLOCK_NUMBER_ERROR_PATTERN = Pattern.compile(".+ up to block number ([0-9]+) .+");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withResolverStyle(ResolverStyle.LENIENT);
    private static final LocalDate MEEDS_TOKEN_FIRST_DATE = LocalDate.of(2021, 11, 6);
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public void init() throws ServletException {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.computeExchangeRate(), 0L, 15L, TimeUnit.MINUTES);
    }

    public void destroy() {
        this.scheduledExecutorService.shutdownNow();
        super.destroy();
    }

    private void computeExchangeRate() {
        block8: {
            try {
                URL exchangeRate = this.getServletContext().getResource("/json/exchangeRate-meeds.json");
                if (exchangeRate == null) break block8;
                String exchangeRateObjectString = IOUtils.toString((URL)exchangeRate, (Charset)StandardCharsets.UTF_8);
                JSONObject exchangeRateObject = new JSONObject(exchangeRateObjectString);
                LocalDate localDate = MEEDS_TOKEN_FIRST_DATE;
                LocalDate today = LocalDate.now();
                while (localDate.isBefore(today)) {
                    ZonedDateTime date = localDate.plusDays(1L).atStartOfDay(ZoneOffset.UTC).minusSeconds(1L);
                    this.addExchangeRateForDate(exchangeRateObject, date, false);
                    localDate = localDate.plusDays(1L);
                }
                this.addExchangeRateForDate(exchangeRateObject, ZonedDateTime.now(ZoneOffset.UTC), true);
                try (FileOutputStream outputStream = new FileOutputStream(exchangeRate.getPath());){
                    IOUtils.write((String)exchangeRateObject.toString(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                }
            }
            catch (Exception e) {
                LOG.error("An error occurred while computing Meeds exchange rates", (Throwable)e);
            }
        }
    }

    private void addExchangeRateForDate(JSONObject exchangeRateObject, ZonedDateTime date, boolean todayValue) {
        String dateString = DATE_FORMATTER.format(date);
        if (!exchangeRateObject.has(dateString) || exchangeRateObject.getJSONObject(dateString).has("volatile") || todayValue) {
            JSONObject exchangeRateResult = this.getExchangeRateForDate(date, todayValue);
            if (exchangeRateResult == null) {
                LOG.warn("ETH and Meeds prices for date {} are empty, stop computing.", (Object)dateString);
                return;
            }
            if (todayValue) {
                exchangeRateResult.put("volatile", true);
            }
            exchangeRateObject.put(dateString, (Object)exchangeRateResult);
        }
    }

    private JSONObject getExchangeRateForDate(ZonedDateTime date, boolean todayValue) {
        JSONObject exchangeRateResult = new JSONObject();
        this.addEthPrice(exchangeRateResult, date, todayValue);
        this.addPairData(exchangeRateResult, date, todayValue);
        return exchangeRateResult;
    }

    private void addEthPrice(JSONObject exchangeRateResult, ZonedDateTime date, boolean todayValue) {
        String blockNumber = todayValue ? this.getLastBlockNumber() : this.getBlockNumber(date);
        boolean added = this.addEthPrice(exchangeRateResult, blockNumber);
        if (!added && ChronoUnit.DAYS.between(date, ZonedDateTime.now(ZoneOffset.UTC)) == 0L) {
            int previousBlock = Integer.parseInt(blockNumber) - 10;
            added = this.addEthPrice(exchangeRateResult, String.valueOf(previousBlock));
        }
        if (!added) {
            LOG.warn("Error computing Eth Price for date {}. Retrieve empty result.", (Object)DATE_FORMATTER.format(date));
            exchangeRateResult.put("volatile", true);
        }
    }

    private boolean addEthPrice(JSONObject exchangeRateResult, String blockNumber) {
        String body;
        String ethPriceDataJsonString;
        if (StringUtils.isBlank((String)blockNumber)) {
            exchangeRateResult.put("volatile", true);
        }
        if (StringUtils.isNotBlank((String)(ethPriceDataJsonString = this.executeQuery("https://api.thegraph.com/subgraphs/name/sushiswap/exchange", body = "{\"query\":\"{bundle(id: 1, block:{number:" + blockNumber + "}){ethPrice}}\"}")))) {
            JSONObject ethPriceDataJson = new JSONObject(ethPriceDataJsonString);
            if (ethPriceDataJson.has("data") && ethPriceDataJson.getJSONObject("data").has("bundle") && !ethPriceDataJson.getJSONObject("data").isNull("bundle")) {
                String ethPrice = ethPriceDataJson.getJSONObject("data").getJSONObject("bundle").getString("ethPrice");
                exchangeRateResult.put("ethPrice", (Object)ethPrice);
                return true;
            }
            if (ethPriceDataJson.has("errors") && !ethPriceDataJson.isNull("errors") && ethPriceDataJson.getJSONArray("errors").length() > 0 && ethPriceDataJson.getJSONArray("errors").getJSONObject(0).has("message") && !ethPriceDataJson.getJSONArray("errors").getJSONObject(0).isNull("message")) {
                Matcher matcher;
                String message = ethPriceDataJson.getJSONArray("errors").getJSONObject(0).getString("message");
                LOG.warn(message);
                if (message.contains("up to block number") && (matcher = LATEST_BLOCK_NUMBER_ERROR_PATTERN.matcher(message)).find()) {
                    blockNumber = matcher.group(1);
                    LOG.info("Attempt to retrieve data with block number {}", (Object)blockNumber);
                    return this.addEthPrice(exchangeRateResult, blockNumber);
                }
            }
        }
        return false;
    }

    private void addPairData(JSONObject exchangeRateResult, ZonedDateTime date, boolean todayValue) {
        String blockNumber = todayValue ? this.getLastBlockNumber() : this.getBlockNumber(date);
        boolean added = this.addPairData(exchangeRateResult, blockNumber);
        if (!added && ChronoUnit.DAYS.between(date, ZonedDateTime.now(ZoneOffset.UTC)) == 0L) {
            int previousBlock = Integer.parseInt(blockNumber) - 10;
            added = this.addPairData(exchangeRateResult, String.valueOf(previousBlock));
        }
        if (!added) {
            LOG.warn("Error computing Pair Data for date {}. Retrieve empty result.", (Object)DATE_FORMATTER.format(date));
            exchangeRateResult.put("volatile", true);
        }
    }

    private boolean addPairData(JSONObject exchangeRateResult, String blockNumber) {
        String body;
        String pairDataJsonString;
        if (StringUtils.isNotBlank((String)blockNumber) && StringUtils.isNotBlank((String)(pairDataJsonString = this.executeQuery("https://api.thegraph.com/subgraphs/name/sushiswap/exchange", body = "{\"query\":\"{pair(id: \\\"0x960bd61d0b960b107ff5309a2dcced4705567070\\\", block: {number:" + blockNumber + "}) {id,token1Price,reserve0,reserve1}}\"}")))) {
            JSONObject pairDataJson = new JSONObject(pairDataJsonString);
            if (pairDataJson.has("data") && pairDataJson.getJSONObject("data").has("pair") && !pairDataJson.getJSONObject("data").isNull("pair")) {
                JSONObject pairJsonObject = pairDataJson.getJSONObject("data").getJSONObject("pair");
                String meedsPrice = pairJsonObject.getString("token1Price");
                exchangeRateResult.put("meedsPrice", (Object)meedsPrice);
                String meedsReserve = pairJsonObject.getString("reserve1");
                exchangeRateResult.put("meedsReserve", (Object)meedsReserve);
                String wethReserve = pairJsonObject.getString("reserve0");
                exchangeRateResult.put("wethReserve", (Object)wethReserve);
                return true;
            }
            if (pairDataJson.has("errors") && !pairDataJson.isNull("errors") && pairDataJson.getJSONArray("errors").length() > 0 && pairDataJson.getJSONArray("errors").getJSONObject(0).has("message") && !pairDataJson.getJSONArray("errors").getJSONObject(0).isNull("message")) {
                Matcher matcher;
                String message = pairDataJson.getJSONArray("errors").getJSONObject(0).getString("message");
                LOG.warn(message);
                if (message.contains("up to block number") && (matcher = LATEST_BLOCK_NUMBER_ERROR_PATTERN.matcher(message)).find()) {
                    blockNumber = matcher.group(1);
                    LOG.info("Attempt to retrieve data with block number {}", (Object)blockNumber);
                    return this.addPairData(exchangeRateResult, blockNumber);
                }
            }
        }
        return false;
    }

    private String getBlockNumber(ZonedDateTime date) {
        JSONObject blockNumberDataJson;
        String body = "{\"query\":\"{blocks(first:1,orderBy:timestamp,orderDirection: desc,where:{timestamp_lte:" + date.toEpochSecond() + "}){number}}\"}";
        String blockNumberDataJsonString = this.executeQuery("https://api.thegraph.com/subgraphs/name/blocklytics/ethereum-blocks", body);
        if (StringUtils.isNotBlank((String)blockNumberDataJsonString) && (blockNumberDataJson = new JSONObject(blockNumberDataJsonString)).has("data") && blockNumberDataJson.getJSONObject("data").has("blocks") && !blockNumberDataJson.getJSONObject("data").isNull("blocks")) {
            return blockNumberDataJson.getJSONObject("data").getJSONArray("blocks").getJSONObject(0).getString("number");
        }
        return null;
    }

    private String getLastBlockNumber() {
        JSONObject blockNumberDataJson;
        String body = "{\"query\":\"{blocks(first:1,orderBy:number,orderDirection:desc){number}}\"}";
        String blockNumberDataJsonString = this.executeQuery("https://api.thegraph.com/subgraphs/name/blocklytics/ethereum-blocks", body);
        if (StringUtils.isNotBlank((String)blockNumberDataJsonString) && (blockNumberDataJson = new JSONObject(blockNumberDataJsonString)).has("data") && blockNumberDataJson.getJSONObject("data").has("blocks") && !blockNumberDataJson.getJSONObject("data").isNull("blocks")) {
            return blockNumberDataJson.getJSONObject("data").getJSONArray("blocks").getJSONObject(0).getString("number");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeQuery(String url, String body) {
        String string;
        URL apiUrl = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)apiUrl.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Content-Type", "application/json");
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(body);
        wr.flush();
        wr.close();
        int responseCode = con.getResponseCode();
        if (responseCode != 200) return null;
        InputStream inputStream = con.getInputStream();
        try {
            string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (inputStream == null) return string;
        }
        catch (Throwable throwable) {
            try {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("An error occurred while retrieving data from URL '{}' with data '{}'", new Object[]{url, body, e});
                return null;
            }
        }
        inputStream.close();
        return string;
    }
}

