/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 - 2022 Meeds Association contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.tenant.provisioning.web.model;

import java.time.ZonedDateTime;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.meeds.deeds.constant.TenantProvisioningStatus;
import io.meeds.deeds.constant.TenantStatus;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class DeedTenantProvisioning {

  private long                     nftId;

  private short                    cityIndex = -1;

  private short                    cardType  = -1;

  private String                   managerAddress;

  private String                   managerEmail;

  private String                   startupTransactionHash;

  private String                   shutdownTransactionHash;

  private TenantProvisioningStatus tenantProvisioningStatus;

  private TenantStatus             tenantStatus;

  @JsonFormat(shape = JsonFormat.Shape.STRING)
  private ZonedDateTime            date;

  private Map<String, String>      properties;

  private boolean                  completed;

  private String                   etherscanLink;

}
