/*
 * This file is part of the Meeds project (https://meeds.io/).
 * 
 * Copyright (C) 2020 - 2022 Meeds Association contact@meeds.io
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
import DeedProvisioningManagement from './components/DeedProvisioningManagement.vue';
import DeedProvisioningManagementNavbar from './components/layout/Navbar.vue';
import DeedProvisioningManagementPage from './components/layout/Page.vue';
import DeedProvisioningManagementDialogConfirm from './components/layout/DialogConfirm.vue';
import DeedProvisioningManagementTenants from './components/tenants/TenantsMain.vue';
import DeedProvisioningManagementTenantsStatusUpdater from './components/tenants/TenantStatusWebSocketUpdater.vue';
import DeedProvisioningManagementTenantsStatusPanel from './components/tenants/TenantsStatusPanel.vue';
import DeedProvisioningManagementTenantsTable from './components/tenants/TenantsTable.vue';
import DeedProvisioningManagementTenantsItem from './components/tenants/TenantsItem.vue';
import DeedProvisioningManagementTenantsManageDrawer from './components/tenants/drawers/ManageTenantDrawer.vue';
import DeedProvisioningManagementTenantsMailPreviewDrawer from './components/tenants/drawers/MailPreviewDrawer.vue';
import DeedProvisioningManagementSettings from './components/settings/SettingsMain.vue';
import DeedProvisioningManagementSettingsEmailDrawer from './components/settings/drawers/EmailSettingsDrawer.vue';
import DeedProvisioningManagementSettingsSignatureLogo from './components/settings/form/SignatureLogo.vue';
import DeedProvisioningManagementSettingsEmailTemplateDrawer from './components/settings/drawers/EmailTemplateDrawer.vue';
import DeedProvisioningManagementSettingsEmailTemplateItem from './components/settings/EmailTemplateItem.vue';
import DeedProvisioningManagementSettingsNotePageDrawer from './components/settings/drawers/NotePageDrawer.vue';

const components = {
  'deed-provisioning-management': DeedProvisioningManagement,
  'deed-provisioning-management-navbar': DeedProvisioningManagementNavbar,
  'deed-provisioning-management-page': DeedProvisioningManagementPage,
  'deed-provisioning-management-dialog-confirm': DeedProvisioningManagementDialogConfirm,
  'deed-provisioning-management-tenants': DeedProvisioningManagementTenants,
  'deed-provisioning-management-settings': DeedProvisioningManagementSettings,
  'deed-provisioning-management-tenants-status-panel': DeedProvisioningManagementTenantsStatusPanel,
  'deed-provisioning-management-tenants-table': DeedProvisioningManagementTenantsTable,
  'deed-provisioning-management-tenants-item': DeedProvisioningManagementTenantsItem,
  'deed-provisioning-management-tenants-manage-drawer': DeedProvisioningManagementTenantsManageDrawer,
  'deed-provisioning-management-tenants-preview-mail-drawer': DeedProvisioningManagementTenantsMailPreviewDrawer,
  'deed-provisioning-management-tenants-status-updater': DeedProvisioningManagementTenantsStatusUpdater,
  'deed-provisioning-management-settings-email-drawer': DeedProvisioningManagementSettingsEmailDrawer,
  'deed-provisioning-management-settings-signature-logo': DeedProvisioningManagementSettingsSignatureLogo,
  'deed-provisioning-management-settings-email-template-drawer': DeedProvisioningManagementSettingsEmailTemplateDrawer,
  'deed-provisioning-management-settings-email-template-item': DeedProvisioningManagementSettingsEmailTemplateItem,
  'deed-provisioning-management-settings-note-tree-drawer': DeedProvisioningManagementSettingsNotePageDrawer,
};

for (const key in components) {
  Vue.component(key, components[key]);
}
