/*
 * This file is part of the Meeds project (https://meeds.io/).
 * 
 * Copyright (C) 2020 - 2022 Meeds Association contact@meeds.io
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
import './initComponents.js';

import * as tenantProvisioningService from './js/TenantProvisioningService.js';
import * as tenantProvisioningSettingsService from './js/TenantProvisioningSettingsService.js';
import * as tenantProvisioningEmailService from './js/TenantProvisioningEmailService.js';
import * as tenantProvisioningWebSocket from './js/WebSocket.js';

if (!Vue.prototype.$tenantProvisioningWebSocket) {
  window.Object.defineProperty(Vue.prototype, '$tenantProvisioningWebSocket', {
    value: tenantProvisioningWebSocket,
  });
}

if (!Vue.prototype.$tenantProvisioningService) {
  window.Object.defineProperty(Vue.prototype, '$tenantProvisioningService', {
    value: tenantProvisioningService,
  });
}

if (!Vue.prototype.$tenantProvisioningSettingsService) {
  window.Object.defineProperty(Vue.prototype, '$tenantProvisioningSettingsService', {
    value: tenantProvisioningSettingsService,
  });
}

if (!Vue.prototype.$tenantProvisioningEmailService) {
  window.Object.defineProperty(Vue.prototype, '$tenantProvisioningEmailService', {
    value: tenantProvisioningEmailService,
  });
}

// get overrided components if exists
if (extensionRegistry) {
  const components = extensionRegistry.loadComponents('DeedProvisioningManagement');
  if (components && components.length > 0) {
    components.forEach(cmp => {
      Vue.component(cmp.componentName, cmp.componentOptions);
    });
  }
}

Vue.use(Vuetify);

const appId = 'DeedProvisioningManagement';

//getting language of the PLF
const lang = window.eXo?.env?.portal?.language || 'en';

//should expose the locale ressources as REST API 
const urls = [
  `${eXo.env.portal.context}/${eXo.env.portal.rest}/i18n/bundle/locale.portlet.taskManagement-${lang}.json`,
  `${eXo.env.portal.context}/${eXo.env.portal.rest}/i18n/bundle/locale.portlet.DeedProvisioningManagement-${lang}.json`
];

// WorkAround for Task Initialization
// Bug that makes the whole application
// Failed to load
// Thus the requirements here are moved
// from gatein-resources.xml
export function init() {
  try {
    window.require(['SHARED/taskCommentsDrawer'], () => {
      initApp();
    });
  } catch (e) {
    console.error('Error initializing Task Comment Drawer', e);
    initApp();
  }
}

export function initApp() {
  exoi18n.loadLanguageAsync(lang, urls).then(i18n => {
    Vue.createApp({
      data: {
        cardTypeColors: ['#BED67E', '#319AB3', '#774EA9', '#F97575'],
        cities: ['Tanit', 'Reshef', 'Ashtarte', 'Melqart', 'Eshmun', 'Kushor', 'Hammon'],
        cardTypes: ['Common', 'Uncommon', 'Rare', 'Legendary'],
      },
      computed: {
        automaticStatuses() {
          return [{
            value: 'NONE',
            text: this.$t('deeds.provisioning.management.dontLinkAutomaticEventToStatus'),
          }, {
            value: 'START_IN_PROGRESS',
            text: this.$t('deeds.provisioning.management.startTransactionInProgress'),
          }, {
            value: 'START_CONFIRMED',
            text: this.$t('deeds.provisioning.management.startTransactionConfirmed'),
          }, {
            value: 'STOP_IN_PROGRESS',
            text: this.$t('deeds.provisioning.management.stopTenantTransactionInProgress'),
          }, {
            value: 'STOP_CONFIRMED',
            text: this.$t('deeds.provisioning.management.stopTenantTransactionConfirmed'),
          }, {
            value: 'TRANSACTION_ERROR',
            text: this.$t('deeds.provisioning.management.transactionError'),
          }, {
            value: 'EMAIL_CONFIRMATION_CODE',
            text: this.$t('deeds.provisioning.management.emailConfirmationCode'),
          }];
        },
      },
      template: `<deed-provisioning-management id="${appId}" />`,
      vuetify: Vue.prototype.vuetifyOptions,
      i18n
    }, `#${appId}`, 'DeedProvisioningManagement');
  });
}
