/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.scheduling.task;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.service.BlockchainService;
import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ProvisioningBlockchainMinedEventsCheckTask {
    private static final Logger LOG = LoggerFactory.getLogger(ProvisioningBlockchainMinedEventsCheckTask.class);
    private static final String SETTING_LAST_TIME_CHECK_KEY = "minedProvisioningTransactionsCheck";
    private static final Scope SETTING_SCOPE = Scope.APPLICATION.id("DEED_TENANT_PROVISIONING");
    private static final Context SETTING_CONTEXT = Context.GLOBAL.id("DEED_TENANT_PROVISIONING");
    @Autowired
    private TenantProvisioningService tenantProvisioningService;
    @Autowired
    private BlockchainService blockchainService;
    private SettingService settingService;

    @Scheduled(fixedDelay=5L, timeUnit=TimeUnit.MINUTES, initialDelay=2L)
    public synchronized void checkPendingTenants() {
        long lastBlock = this.blockchainService.getLastBlock();
        long lastCheckedBlock = this.getLastCheckedBlock();
        if (lastCheckedBlock == 0L) {
            this.saveLastCheckedBlock(lastBlock);
            return;
        }
        List transactions = this.blockchainService.getMinedProvisioningTransactions(lastCheckedBlock, lastBlock);
        transactions.forEach(minedDeedTenantTransaction -> {
            String transactionHash = null;
            try {
                boolean startCommandTransaction;
                long nftId = minedDeedTenantTransaction.getNftId();
                if (!this.tenantProvisioningService.isDeedExists(nftId)) {
                    this.tenantProvisioningService.saveDeedTenant((DeedTenant)minedDeedTenantTransaction);
                }
                if (startCommandTransaction = StringUtils.isNotBlank((CharSequence)minedDeedTenantTransaction.getStartupTransactionHash())) {
                    transactionHash = minedDeedTenantTransaction.getStartupTransactionHash();
                    if (this.tenantProvisioningService.isTransactionAlreadyConfirmed(transactionHash, nftId)) {
                        LOG.info("The mined transaction [{}] for nftId='{}' is already confirmed with a created [TASK]. Ignore adding a new task for it.", (Object)transactionHash, (Object)nftId);
                    } else {
                        this.tenantProvisioningService.startTenant(nftId, transactionHash, true);
                    }
                } else {
                    transactionHash = minedDeedTenantTransaction.getShutdownTransactionHash();
                    if (!this.tenantProvisioningService.isTransactionAlreadyConfirmed(transactionHash, nftId)) {
                        this.tenantProvisioningService.stopTenant(nftId, transactionHash, true);
                    }
                }
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Can't check Provisioning status of transaction {}", transactionHash, (Object)e);
            }
        });
        this.saveLastCheckedBlock(lastBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastCheckedBlock() {
        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
        try {
            long lastCheckedBlock = 0L;
            SettingValue settingValue = this.getSettingService().get(SETTING_CONTEXT, SETTING_SCOPE, SETTING_LAST_TIME_CHECK_KEY);
            if (settingValue != null && settingValue.getValue() != null) {
                lastCheckedBlock = Long.parseLong(settingValue.getValue().toString());
            }
            long l = lastCheckedBlock;
            return l;
        }
        finally {
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    private void saveLastCheckedBlock(long lastBlock) {
        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
        try {
            this.getSettingService().set(SETTING_CONTEXT, SETTING_SCOPE, SETTING_LAST_TIME_CHECK_KEY, SettingValue.create((Long)lastBlock));
        }
        finally {
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
        }
        return this.settingService;
    }
}

