/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.service;

import io.meeds.deeds.constant.ObjectNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.model.Branding;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class TenantProvisioningSettingsService {
    public static final String EMAIL_SENDER_EMAIL_PROP = "emailSenderEmail";
    public static final String EMAIL_SENDER_NAME_PROP = "emailSenderName";
    public static final String EMAIL_SENDER_SIGNATURE_TEXT_PROP = "emailSenderSignatureText";
    public static final String EMAIL_SENDER_SIGNATURE_LOGO_PROP = "emailSenderSignatureLogo";
    public static final String EMAIL_ADITIONAL_RECEIVERS_PROP = "emailAdditionalReceivers";
    public static final String LOGO_UPLOAD_ID_PROP = "logoUploadId";
    private static final Context CONTEXT = Context.GLOBAL.id("TENANT_PROVISIONING");
    private static final Scope SCOPE = Scope.APPLICATION.id("TENANT_PROVISIONING");
    private static final String SETTINGS_PROP_NAME = "TENANT_PROVISIONING_SETTINGS";
    public static final String FILE_API_NAME_SPACE = "TenantProvisioning";
    public static final String LOGO_NAME = "logo.png";
    private BrandingService brandingService;
    private SettingService settingService;
    private FileService fileService;
    private UploadService uploadService;
    private Map<String, Object> tenantProvisioningSettings;
    private byte[] emailLogo;

    public Map<String, Object> getSettings() {
        String value;
        if (this.tenantProvisioningSettings != null) {
            return this.tenantProvisioningSettings;
        }
        this.setPortalContainerContext();
        SettingValue settingValue = this.getSettingService().get(CONTEXT, SCOPE, SETTINGS_PROP_NAME);
        String string = value = settingValue == null || settingValue.getValue() == null ? null : settingValue.getValue().toString();
        if (value == null) {
            Branding brandingInformation = this.getBrandingService().getBrandingInformation();
            if (brandingInformation == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put(EMAIL_SENDER_NAME_PROP, brandingInformation.getCompanyName());
            settings.put(EMAIL_SENDER_EMAIL_PROP, MailUtils.getSenderEmail());
            settings.put(EMAIL_SENDER_SIGNATURE_TEXT_PROP, brandingInformation.getSiteName());
            return settings;
        }
        return new JSONObject(URLDecoder.decode(value, StandardCharsets.UTF_8)).toMap();
    }

    public void saveSettings(Map<String, Object> settings, String username) throws ObjectNotFoundException {
        String uploadId;
        if (settings == null) {
            throw new IllegalArgumentException("settings is mandatory");
        }
        this.setPortalContainerContext();
        if (settings.containsKey(LOGO_UPLOAD_ID_PROP) && StringUtils.isNotBlank((CharSequence)(uploadId = Objects.toString(settings.remove(LOGO_UPLOAD_ID_PROP), null)))) {
            long logoFileId = this.updateEmailLogo(uploadId, username);
            settings.put(EMAIL_SENDER_SIGNATURE_LOGO_PROP, logoFileId);
        }
        String value = new JSONObject(settings).toString();
        this.getSettingService().set(CONTEXT, SCOPE, SETTINGS_PROP_NAME, SettingValue.create((String)URLEncoder.encode(value, StandardCharsets.UTF_8)));
        this.tenantProvisioningSettings = null;
    }

    public String getSenderFullEmail() {
        Map<String, Object> settings = this.getSettings();
        String senderEmail = (String)settings.get(EMAIL_SENDER_EMAIL_PROP);
        String senderName = (String)settings.get(EMAIL_SENDER_NAME_PROP);
        return StringUtils.isBlank((CharSequence)senderName) ? senderEmail : senderName + "<" + senderEmail + ">";
    }

    public String[] getEmailBcc() {
        String bccs = (String)this.getSettings().get(EMAIL_ADITIONAL_RECEIVERS_PROP);
        return StringUtils.split((String)bccs, (String)",");
    }

    public String getEmailSignature() {
        String signature = (String)this.getSettings().get(EMAIL_SENDER_SIGNATURE_TEXT_PROP);
        return StringUtils.isBlank((CharSequence)signature) ? "" : signature;
    }

    public InputStream getEmailLogo() {
        return new ByteArrayInputStream(this.getEmailLogoData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEmailLogoData() {
        if (this.emailLogo != null) {
            return this.emailLogo;
        }
        this.setPortalContainerContext();
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            Map<String, Object> settings = this.getSettings();
            if (settings.containsKey(EMAIL_SENDER_SIGNATURE_LOGO_PROP)) {
                long fileId = Long.parseLong(settings.get(EMAIL_SENDER_SIGNATURE_LOGO_PROP).toString());
                try {
                    FileItem file = this.getFileService().getFile(fileId);
                    this.emailLogo = file.getAsByte();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can't retrieve logo file with id " + fileId, e);
                }
            } else {
                this.emailLogo = this.getBrandingService().getLogo().getData();
            }
            byte[] byArray = this.emailLogo;
            return byArray;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private long updateEmailLogo(String uploadId, String username) throws ObjectNotFoundException {
        UploadResource uploadResource = this.getUploadService().getUploadResource(uploadId);
        FileInputStream inputStream = null;
        if (uploadResource != null) {
            try {
                inputStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
            }
            catch (FileNotFoundException e) {
                throw new ObjectNotFoundException("Upload Resource in location " + uploadResource.getStoreLocation() + " wasn't found");
            }
            finally {
                this.getUploadService().removeUploadResource(uploadId);
            }
        }
        if (inputStream == null) {
            throw new ObjectNotFoundException("Upload Resource with id " + uploadId + " wasn't found");
        }
        try {
            Long logoFileId = this.getLogoFileId();
            if (logoFileId == null) {
                FileItem fileItem = new FileItem(null, LOGO_NAME, "image/png", FILE_API_NAME_SPACE, (long)uploadResource.getUploadedSize(), new Date(), username, false, (InputStream)inputStream);
                fileItem = this.getFileService().writeFile(fileItem);
                logoFileId = fileItem.getFileInfo().getId();
            } else {
                FileItem fileItem = new FileItem(logoFileId, LOGO_NAME, "image/png", FILE_API_NAME_SPACE, (long)uploadResource.getUploadedSize(), new Date(), username, false, (InputStream)inputStream);
                this.getFileService().updateFile(fileItem);
            }
            this.emailLogo = null;
            return logoFileId;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while updating Tenant Provisioning Logo", e);
        }
    }

    private Long getLogoFileId() {
        Map<String, Object> settings = this.getSettings();
        if (settings.containsKey(EMAIL_SENDER_SIGNATURE_LOGO_PROP)) {
            return Long.parseLong(settings.get(EMAIL_SENDER_SIGNATURE_LOGO_PROP).toString());
        }
        return null;
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
        }
        return this.settingService;
    }

    private BrandingService getBrandingService() {
        if (this.brandingService == null) {
            this.brandingService = (BrandingService)PortalContainer.getInstance().getComponentInstanceOfType(BrandingService.class);
        }
        return this.brandingService;
    }

    private FileService getFileService() {
        if (this.fileService == null) {
            this.fileService = (FileService)PortalContainer.getInstance().getComponentInstanceOfType(FileService.class);
        }
        return this.fileService;
    }

    private UploadService getUploadService() {
        if (this.uploadService == null) {
            this.uploadService = (UploadService)PortalContainer.getInstance().getComponentInstanceOfType(UploadService.class);
        }
        return this.uploadService;
    }

    private void setPortalContainerContext() {
        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
    }
}

