/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.web.rest;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import io.meeds.tenant.provisioning.service.TenantProvisioningSettingsService;
import io.meeds.tenant.provisioning.web.model.DeedTenantProvisioningSettings;
import io.meeds.tenant.provisioning.web.rest.utils.EntityMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/provisioning/settings"})
public class TenantProvisioningSettingsController {
    private static final Logger LOG = LoggerFactory.getLogger(TenantProvisioningSettingsController.class);
    @Autowired
    private TenantProvisioningService tenantProvisioningService;
    @Autowired
    private TenantProvisioningSettingsService tenantProvisioningSettingsService;

    @GetMapping
    public ResponseEntity<DeedTenantProvisioningSettings> getSettings(Principal principal) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        Map<String, Object> settingsMap = this.tenantProvisioningSettingsService.getSettings();
        DeedTenantProvisioningSettings settings = EntityMapper.toObject(settingsMap, DeedTenantProvisioningSettings.class);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)settings);
    }

    @PatchMapping
    public ResponseEntity<DeedTenantProvisioningSettings> saveSettings(Principal principal, @RequestParam Map<Object, Object> fields) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        if (fields == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empty Settings");
        }
        DeedTenantProvisioningSettings settings = this.mergeSettings(fields);
        Map<String, Object> settingsMap = EntityMapper.toMap(settings);
        try {
            this.tenantProvisioningSettingsService.saveSettings(settingsMap, principal.getName());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Can't upload logo");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)settings);
    }

    @GetMapping(value={"/logo"})
    public void getEmailLogo(Principal principal, HttpServletResponse response) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        InputStream emailLogoInputstream = this.tenantProvisioningSettingsService.getEmailLogo();
        response.setContentType("image/png");
        response.setHeader("Cache-Control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            IOUtils.copy((InputStream)emailLogoInputstream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        finally {
            try {
                emailLogoInputstream.close();
            }
            catch (IOException e) {
                LOG.warn("Error while closing input stream of logo file", (Throwable)e);
            }
        }
    }

    private DeedTenantProvisioningSettings mergeSettings(Map<Object, Object> fields) {
        DeedTenantProvisioningSettings newValues = EntityMapper.toObject(fields, DeedTenantProvisioningSettings.class);
        Map<String, Object> settingsMap = this.tenantProvisioningSettingsService.getSettings();
        return EntityMapper.mergeObjects(EntityMapper.toObject(settingsMap, DeedTenantProvisioningSettings.class), newValues);
    }
}

