/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 - 2022 Meeds Association contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.tenant.provisioning.web.model;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;

import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

import io.meeds.deeds.constant.TenantProvisioningStatus;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class DeedTenantProvisioningList {

  private int                                                         limit;

  private Map<TenantProvisioningStatus, Long>                         sizes;

  private Map<TenantProvisioningStatus, List<DeedTenantProvisioning>> deeds;

  public DeedTenantProvisioningList(int limit) {
    this.limit = limit;
  }

  public void addSize(TenantProvisioningStatus provisioningStatus, long size) {
    if (sizes == null) {
      sizes = new EnumMap<>(TenantProvisioningStatus.class);
    }
    sizes.put(provisioningStatus, size);
  }

  public void appendElements(TenantProvisioningStatus provisioningStatus, List<DeedTenantProvisioning> list) {
    if (deeds == null) {
      deeds = new EnumMap<>(TenantProvisioningStatus.class);
    }
    deeds.put(provisioningStatus, list);
  }

  public void addTenantProvisioningStatus(TenantProvisioningStatus provisioningStatus, List<DeedTenantProvisioning> list, long count) {
    if (CollectionUtils.isNotEmpty(list)) {
      appendElements(provisioningStatus, list);
      addSize(provisioningStatus, count);
    }
  }

  @Override
  public String toString() {
    try {
      return new JsonGeneratorImpl().createJsonObject(this).toString();
    } catch (JsonException e) {
      throw new IllegalStateException("Error parsing object to JSON string", e);
    }
  }
}
