/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.listener;

import io.meeds.deeds.constant.CommonConstants;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.listener.EventListener;
import io.meeds.deeds.service.ListenerService;
import io.meeds.deeds.service.TenantService;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeedOwnershipTransferredListener
implements EventListener<CommonConstants.DeedOwnershipTransferEvent> {
    public static final String LISTENER_NAME = "DeedOwnershipTransferredProvisioningListener";
    private static final List<String> SUPPORTED_EVENTS = Collections.singletonList("deed.event.transferOwnershipFromBlockchain");
    @Autowired
    private TenantService tenantService;
    @Autowired
    private ListenerService listenerService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, CommonConstants.DeedOwnershipTransferEvent ownershipTransferEvent) {
        String newOwner;
        String oldOwner = ownershipTransferEvent.getFrom();
        if (StringUtils.equalsIgnoreCase((String)oldOwner, (String)(newOwner = ownershipTransferEvent.getTo()))) {
            return;
        }
        DeedTenant deedTenant = this.tenantService.getDeedTenant(ownershipTransferEvent.getNftId());
        if (deedTenant != null) {
            this.setNewOwner(oldOwner, newOwner, deedTenant);
            this.setNewDeedManager(oldOwner, newOwner, deedTenant);
            this.tenantService.saveDeedTenant(deedTenant);
            this.listenerService.publishEvent("deed.event.transferOwnershipFromDeedTenant", (Object)ownershipTransferEvent);
        }
    }

    private void setNewDeedManager(String oldOwner, String newOwner, DeedTenant deedTenant) {
        String deedManagerAddress = deedTenant.getManagerAddress();
        if (StringUtils.isBlank((String)deedManagerAddress) || StringUtils.equalsIgnoreCase((String)deedManagerAddress, (String)oldOwner)) {
            deedTenant.setManagerAddress(newOwner);
        }
    }

    private void setNewOwner(String oldOwner, String newOwner, DeedTenant deedTenant) {
        String deedOwnerAddress = deedTenant.getOwnerAddress();
        if (StringUtils.isBlank((String)deedOwnerAddress) || StringUtils.equalsIgnoreCase((String)deedOwnerAddress, (String)oldOwner)) {
            deedTenant.setOwnerAddress(newOwner);
        }
    }
}

